/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import oshi.hardware.common.AbstractFirmware;
import oshi.jna.platform.windows.WbemcliUtil;
import oshi.util.platform.windows.WmiUtil;

final class WindowsFirmware
extends AbstractFirmware {
    private static final long serialVersionUID = 1L;

    WindowsFirmware() {
        this.init();
    }

    private void init() {
        WbemcliUtil.WmiQuery<BiosProperty> biosQuery = new WbemcliUtil.WmiQuery<BiosProperty>("Win32_BIOS where PrimaryBIOS=true", BiosProperty.class);
        WbemcliUtil.WmiResult<BiosProperty> win32BIOS = WmiUtil.queryWMI(biosQuery);
        if (win32BIOS.getResultCount() > 0) {
            this.setManufacturer(WmiUtil.getString(win32BIOS, BiosProperty.MANUFACTURER, 0));
            this.setName(WmiUtil.getString(win32BIOS, BiosProperty.NAME, 0));
            this.setDescription(WmiUtil.getString(win32BIOS, BiosProperty.DESCRIPTION, 0));
            this.setVersion(WmiUtil.getString(win32BIOS, BiosProperty.VERSION, 0));
            this.setReleaseDate(WmiUtil.getDateString(win32BIOS, BiosProperty.RELEASEDATE, 0));
        }
    }

    static enum BiosProperty {
        MANUFACTURER,
        NAME,
        DESCRIPTION,
        VERSION,
        RELEASEDATE;

    }
}

