/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import com.sun.jna.ptr.IntByReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.UsbDevice;
import oshi.hardware.common.AbstractUsbDevice;
import oshi.jna.platform.windows.Cfgmgr32;
import oshi.jna.platform.windows.Cfgmgr32Util;
import oshi.jna.platform.windows.WbemcliUtil;
import oshi.util.MapUtil;
import oshi.util.ParseUtil;
import oshi.util.platform.windows.WmiUtil;

public class WindowsUsbDevice
extends AbstractUsbDevice {
    private static final long serialVersionUID = 2L;
    private static final Logger LOG = LoggerFactory.getLogger(WindowsUsbDevice.class);
    private static List<String> controllerDeviceIdList = new ArrayList<String>();
    private static final String PNPENTITY_BASE_CLASS = "Win32_PnPEntity";
    private static final WbemcliUtil.WmiQuery<PnPEntityProperty> PNPENTITY_QUERY;
    private static final String DISKDRIVE_BASE_CLASS = "Win32_DiskDrive";
    private static final WbemcliUtil.WmiQuery<DiskDriveProperty> DISKDRIVE_QUERY;
    private static final Pattern VENDOR_PRODUCT_ID;
    private static Map<String, WindowsUsbDevice> usbDeviceCache;
    private static Set<String> devicesToAdd;
    private static Set<String> devicesToRemove;
    private static Map<String, List<String>> deviceTreeMap;

    public WindowsUsbDevice(String name, String vendor, String vendorId, String productId, String serialNumber, UsbDevice[] connectedDevices) {
        super(name, vendor, vendorId, productId, serialNumber, connectedDevices);
    }

    public static UsbDevice[] getUsbDevices(boolean tree) {
        UsbDevice[] devices = WindowsUsbDevice.getUsbDevices();
        if (tree) {
            return devices;
        }
        ArrayList<UsbDevice> deviceList = new ArrayList<UsbDevice>();
        for (UsbDevice device : devices) {
            WindowsUsbDevice.addDevicesToList(deviceList, device.getConnectedDevices());
        }
        return deviceList.toArray(new UsbDevice[deviceList.size()]);
    }

    private static void addDevicesToList(List<UsbDevice> deviceList, UsbDevice[] connectedDevices) {
        for (UsbDevice device : connectedDevices) {
            deviceList.add(new WindowsUsbDevice(device.getName(), device.getVendor(), device.getVendorId(), device.getProductId(), device.getSerialNumber(), new UsbDevice[0]));
            WindowsUsbDevice.addDevicesToList(deviceList, device.getConnectedDevices());
        }
    }

    private static UsbDevice[] getUsbDevices() {
        deviceTreeMap.clear();
        devicesToAdd.clear();
        devicesToRemove = new HashSet<String>(usbDeviceCache.keySet());
        ArrayList<WindowsUsbDevice> controllerDevices = new ArrayList<WindowsUsbDevice>();
        for (String controllerDeviceId : controllerDeviceIdList) {
            WindowsUsbDevice.putChildrenInDeviceTree(controllerDeviceId, 0);
            WindowsUsbDevice.updateDeviceCache();
            WindowsUsbDevice deviceAndChildren = WindowsUsbDevice.getDeviceAndChildren(controllerDeviceId, "0000", "0000");
            if (deviceAndChildren == null) continue;
            controllerDevices.add(deviceAndChildren);
        }
        return controllerDevices.toArray(new WindowsUsbDevice[controllerDevices.size()]);
    }

    private static void updateDeviceCache() {
        for (String deviceID : devicesToRemove) {
            usbDeviceCache.remove(deviceID);
            LOG.debug("Removing {} from USB device cache.", (Object)deviceID);
        }
        devicesToRemove.clear();
        if (!devicesToAdd.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (String deviceID : devicesToAdd) {
                if (first) {
                    sb.append(" WHERE (PnPDeviceID=\"");
                    first = false;
                } else {
                    sb.append(" OR (PnPDeviceID=\"");
                }
                sb.append(deviceID).append("\")");
            }
            String whereClause = sb.toString();
            PNPENTITY_QUERY.setWmiClassName(PNPENTITY_BASE_CLASS + whereClause);
            WbemcliUtil.WmiResult<PnPEntityProperty> pnpEntity = WmiUtil.queryWMI(PNPENTITY_QUERY);
            for (int i = 0; i < pnpEntity.getResultCount(); ++i) {
                String pnpDeviceID = WmiUtil.getString(pnpEntity, PnPEntityProperty.PNPDEVICEID, i);
                String name = WmiUtil.getString(pnpEntity, PnPEntityProperty.NAME, i);
                String vendor = WmiUtil.getString(pnpEntity, PnPEntityProperty.MANUFACTURER, i);
                WindowsUsbDevice device = new WindowsUsbDevice(name, vendor, null, null, "", new WindowsUsbDevice[0]);
                usbDeviceCache.put(pnpDeviceID, device);
                LOG.debug("Adding {} to USB device cache.", (Object)pnpDeviceID);
            }
            DISKDRIVE_QUERY.setWmiClassName(DISKDRIVE_BASE_CLASS + whereClause);
            WbemcliUtil.WmiResult<DiskDriveProperty> serialNumber = WmiUtil.queryWMI(DISKDRIVE_QUERY);
            for (int i = 0; i < serialNumber.getResultCount(); ++i) {
                String pnpDeviceID = WmiUtil.getString(serialNumber, DiskDriveProperty.PNPDEVICEID, i);
                if (!usbDeviceCache.containsKey(pnpDeviceID)) continue;
                WindowsUsbDevice device = usbDeviceCache.get(pnpDeviceID);
                device.serialNumber = ParseUtil.hexStringToString(WmiUtil.getString(serialNumber, DiskDriveProperty.SERIALNUMBER, i));
            }
        }
    }

    private static void putChildrenInDeviceTree(String deviceId, int deviceInstance) {
        IntByReference child;
        int devInst;
        devicesToRemove.remove(deviceId);
        if (!usbDeviceCache.containsKey(deviceId)) {
            devicesToAdd.add(deviceId);
        }
        if ((devInst = deviceInstance) == 0) {
            IntByReference pdnDevInst = new IntByReference();
            Cfgmgr32.INSTANCE.CM_Locate_DevNode(pdnDevInst, deviceId, 0);
            devInst = pdnDevInst.getValue();
        }
        if (0 == Cfgmgr32.INSTANCE.CM_Get_Child(child = new IntByReference(), devInst, 0)) {
            ArrayList<String> childList = new ArrayList<String>();
            String childId = Cfgmgr32Util.CM_Get_Device_ID(child.getValue());
            childList.add(childId);
            deviceTreeMap.put(deviceId, childList);
            WindowsUsbDevice.putChildrenInDeviceTree(childId, child.getValue());
            IntByReference sibling = new IntByReference();
            while (0 == Cfgmgr32.INSTANCE.CM_Get_Sibling(sibling, child.getValue(), 0)) {
                String siblingId = Cfgmgr32Util.CM_Get_Device_ID(sibling.getValue());
                deviceTreeMap.get(deviceId).add(siblingId);
                WindowsUsbDevice.putChildrenInDeviceTree(siblingId, sibling.getValue());
                child = sibling;
            }
        }
    }

    private static WindowsUsbDevice getDeviceAndChildren(String hubDeviceId, String vid, String pid) {
        String vendorId = vid;
        String productId = pid;
        Matcher m = VENDOR_PRODUCT_ID.matcher(hubDeviceId);
        if (m.matches()) {
            vendorId = m.group(1).toLowerCase();
            productId = m.group(2).toLowerCase();
        }
        List pnpDeviceIds = MapUtil.getOrDefault(deviceTreeMap, hubDeviceId, new ArrayList());
        ArrayList<WindowsUsbDevice> usbDevices = new ArrayList<WindowsUsbDevice>();
        for (String pnpDeviceId : pnpDeviceIds) {
            WindowsUsbDevice deviceAndChildren = WindowsUsbDevice.getDeviceAndChildren(pnpDeviceId, vendorId, productId);
            if (deviceAndChildren == null) continue;
            usbDevices.add(deviceAndChildren);
        }
        Collections.sort(usbDevices);
        if (usbDeviceCache.containsKey(hubDeviceId)) {
            WindowsUsbDevice device = usbDeviceCache.get(hubDeviceId);
            if (device.name.isEmpty()) {
                device.name = vendorId + ":" + productId;
            }
            device.vendorId = vendorId;
            device.productId = productId;
            device.connectedDevices = usbDevices.toArray(new WindowsUsbDevice[usbDevices.size()]);
            return device;
        }
        return null;
    }

    static {
        WbemcliUtil.WmiQuery<USBControllerProperty> usbControllerQuery = WbemcliUtil.createQuery("Win32_USBController", USBControllerProperty.class);
        WbemcliUtil.WmiResult<USBControllerProperty> usbController = WmiUtil.queryWMI(usbControllerQuery);
        for (int i = 0; i < usbController.getResultCount(); ++i) {
            controllerDeviceIdList.add(WmiUtil.getString(usbController, USBControllerProperty.PNPDEVICEID, i));
        }
        PNPENTITY_QUERY = WbemcliUtil.createQuery(null, PnPEntityProperty.class);
        DISKDRIVE_QUERY = WbemcliUtil.createQuery(null, DiskDriveProperty.class);
        VENDOR_PRODUCT_ID = Pattern.compile(".*(?:VID|VEN)_(\\p{XDigit}{4})&(?:PID|DEV)_(\\p{XDigit}{4}).*");
        usbDeviceCache = new HashMap<String, WindowsUsbDevice>();
        devicesToAdd = new HashSet<String>();
        devicesToRemove = new HashSet<String>();
        deviceTreeMap = new HashMap<String, List<String>>();
    }

    static enum DiskDriveProperty {
        PNPDEVICEID,
        SERIALNUMBER;

    }

    static enum PnPEntityProperty {
        NAME,
        MANUFACTURER,
        PNPDEVICEID;

    }

    static enum USBControllerProperty {
        PNPDEVICEID;

    }
}

