/*
 * Decompiled with CFR 0.152.
 */
package oshi.json.hardware.impl;

import java.util.Properties;
import javax.json.Json;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import oshi.json.hardware.GlobalMemory;
import oshi.json.json.AbstractOshiJsonObject;
import oshi.json.json.NullAwareJsonObjectBuilder;
import oshi.json.util.PropertiesUtil;

public class GlobalMemoryImpl
extends AbstractOshiJsonObject
implements GlobalMemory {
    private static final long serialVersionUID = 1L;
    private transient JsonBuilderFactory jsonFactory = Json.createBuilderFactory(null);
    private oshi.hardware.GlobalMemory memory;

    public GlobalMemoryImpl(oshi.hardware.GlobalMemory memory) {
        this.memory = memory;
    }

    @Override
    public long getTotal() {
        return this.memory.getTotal();
    }

    @Override
    public long getAvailable() {
        return this.memory.getAvailable();
    }

    @Override
    public long getSwapTotal() {
        return this.memory.getSwapTotal();
    }

    @Override
    public long getSwapUsed() {
        return this.memory.getSwapUsed();
    }

    @Override
    public long getSwapPagesIn() {
        return this.memory.getSwapPagesIn();
    }

    @Override
    public long getSwapPagesOut() {
        return this.memory.getSwapPagesOut();
    }

    @Override
    public long getPageSize() {
        return this.memory.getPageSize();
    }

    @Override
    public JsonObject toJSON(Properties properties) {
        JsonObjectBuilder json = NullAwareJsonObjectBuilder.wrap(this.jsonFactory.createObjectBuilder());
        if (PropertiesUtil.getBoolean(properties, "hardware.memory.available")) {
            json.add("available", this.getAvailable());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.memory.total")) {
            json.add("total", this.getTotal());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.memory.swapTotal")) {
            json.add("swapTotal", this.getSwapTotal());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.memory.swapUsed")) {
            json.add("swapUsed", this.getSwapUsed());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.memory.swapPagesIn")) {
            json.add("swapPagesIn", this.getSwapPagesIn());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.memory.swapPagesOut")) {
            json.add("swapPagesOut", this.getSwapPagesOut());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.memory.pageSize")) {
            json.add("pageSize", this.getPageSize());
        }
        return json.build();
    }
}

