/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Psapi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.common.AbstractGlobalMemory;
import oshi.util.platform.windows.PdhUtil;

public class WindowsGlobalMemory
extends AbstractGlobalMemory {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(WindowsGlobalMemory.class);
    private String pdhPagesInputPerSecCounter = null;
    private String pdhPagesOutputPerSecCounter = null;
    private String pdhPagingPercentUsageCounter = null;
    private transient Psapi.PERFORMANCE_INFORMATION perfInfo = new Psapi.PERFORMANCE_INFORMATION();
    private long lastUpdate = 0L;

    public WindowsGlobalMemory() {
        this.initPdhCounters();
    }

    private void initPdhCounters() {
        this.pdhPagesInputPerSecCounter = "\\Memory\\Pages Input/sec";
        this.pdhPagesOutputPerSecCounter = "\\Memory\\Pages Output/sec";
        PdhUtil.addCounter(this.pdhPagesInputPerSecCounter);
        PdhUtil.addCounter(this.pdhPagesOutputPerSecCounter);
        this.pdhPagingPercentUsageCounter = "\\Paging File(_Total)\\% Usage";
        PdhUtil.addCounter(this.pdhPagingPercentUsageCounter);
    }

    @Override
    protected void updateMeminfo() {
        long now = System.currentTimeMillis();
        if (now - this.lastUpdate > 100L) {
            if (!Psapi.INSTANCE.GetPerformanceInfo(this.perfInfo, this.perfInfo.size())) {
                LOG.error("Failed to get Performance Info. Error code: {}", (Object)Kernel32.INSTANCE.GetLastError());
                return;
            }
            this.pageSize = this.perfInfo.PageSize.longValue();
            this.memAvailable = this.pageSize * this.perfInfo.PhysicalAvailable.longValue();
            this.memTotal = this.pageSize * this.perfInfo.PhysicalTotal.longValue();
            this.swapTotal = this.pageSize * (this.perfInfo.CommitLimit.longValue() - this.perfInfo.PhysicalTotal.longValue());
            this.swapPagesIn = PdhUtil.queryCounter(this.pdhPagesInputPerSecCounter);
            this.swapPagesOut = PdhUtil.queryCounter(this.pdhPagesOutputPerSecCounter);
            this.lastUpdate = now;
        }
    }

    @Override
    protected void updateSwap() {
        this.updateMeminfo();
        this.swapUsed = PdhUtil.queryCounter(this.pdhPagingPercentUsageCounter) * this.pageSize;
    }
}

