/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oshi.hardware.Sensors;
import oshi.util.platform.windows.WmiUtil;

public class WindowsSensors
implements Sensors {
    private static final long serialVersionUID = 1L;
    private String wmiTempNamespace = null;
    private String wmiTempClass = null;
    private String wmiTempProperty = null;
    private String wmiVoltNamespace = null;
    private String wmiVoltClass = null;
    private String wmiVoltProperty = null;
    private static final String OHM_NAMESPACE = "root\\OpenHardwareMonitor";
    private static final String HARDWARE_CLASS = "Hardware";
    private static final String SENSOR_CLASS = "Sensor";
    private static final String IDENTIFIER_PROPERTY = "Identifier";
    private static final String VALUE_PROPERTY = "Value";
    private static final String CPU_FILTER = "WHERE HardwareType=\"CPU\"";
    private static final String CPU_SENSOR_FILTER = "WHERE Parent=\"%s\" AND SensorType=\"%s\"";

    @Override
    public double getCpuTemperature() {
        long tempK;
        double tempC = 0.0;
        String cpuIdentifier = WmiUtil.selectStringFrom(OHM_NAMESPACE, HARDWARE_CLASS, IDENTIFIER_PROPERTY, CPU_FILTER);
        if (cpuIdentifier.length() > 0) {
            Map<String, List<Float>> vals = WmiUtil.selectFloatsFrom(OHM_NAMESPACE, SENSOR_CLASS, VALUE_PROPERTY, String.format(CPU_SENSOR_FILTER, cpuIdentifier, "Temperature"));
            if (!vals.get(VALUE_PROPERTY).isEmpty()) {
                double sum = 0.0;
                Iterator<Float> iterator = vals.get(VALUE_PROPERTY).iterator();
                while (iterator.hasNext()) {
                    double val = iterator.next().floatValue();
                    sum += val;
                }
                tempC = sum / (double)vals.get(VALUE_PROPERTY).size();
            }
            return tempC;
        }
        if (this.wmiTempClass == null) {
            this.wmiTempNamespace = "root\\cimv2";
            this.wmiTempClass = "Win32_Temperature";
            this.wmiTempProperty = "CurrentReading";
            tempK = WmiUtil.selectUint32From(this.wmiTempNamespace, this.wmiTempClass, this.wmiTempProperty, null);
            if (tempK == 0L) {
                this.wmiTempClass = "Win32_TemperatureProbe";
                tempK = WmiUtil.selectUint32From(this.wmiTempNamespace, this.wmiTempClass, this.wmiTempProperty, null);
            }
            if (tempK == 0L) {
                this.wmiTempClass = "Win32_PerfFormattedData_Counters_ThermalZoneInformation";
                this.wmiTempProperty = "Temperature";
                tempK = WmiUtil.selectUint32From(this.wmiTempNamespace, this.wmiTempClass, this.wmiTempProperty, null);
            }
            if (tempK == 0L) {
                this.wmiTempNamespace = "root\\wmi";
                this.wmiTempClass = "MSAcpi_ThermalZoneTemperature";
                this.wmiTempProperty = "CurrentTemperature";
                tempK = WmiUtil.selectUint32From(this.wmiTempNamespace, this.wmiTempClass, this.wmiTempProperty, null);
            }
        } else {
            tempK = WmiUtil.selectUint32From(this.wmiTempNamespace, this.wmiTempClass, this.wmiTempProperty, null);
        }
        if (tempK > 2732L) {
            tempC = (double)tempK / 10.0 - 273.15;
        } else if (tempK > 274L) {
            tempC = (double)tempK - 273.0;
        }
        if (tempC <= 0.0) {
            tempC = 0.0;
        }
        return tempC;
    }

    @Override
    public int[] getFanSpeeds() {
        int[] fanSpeeds = new int[1];
        String cpuIdentifier = WmiUtil.selectStringFrom(OHM_NAMESPACE, HARDWARE_CLASS, IDENTIFIER_PROPERTY, CPU_FILTER);
        if (cpuIdentifier.length() > 0) {
            Map<String, List<Float>> vals = WmiUtil.selectFloatsFrom(OHM_NAMESPACE, SENSOR_CLASS, VALUE_PROPERTY, String.format(CPU_SENSOR_FILTER, cpuIdentifier, "Fan"));
            if (!vals.get(VALUE_PROPERTY).isEmpty()) {
                fanSpeeds = new int[vals.get(VALUE_PROPERTY).size()];
                for (int i = 0; i < vals.get(VALUE_PROPERTY).size(); ++i) {
                    fanSpeeds[i] = vals.get(VALUE_PROPERTY).get(i).intValue();
                }
            }
            return fanSpeeds;
        }
        int rpm = WmiUtil.selectUint32From(null, "Win32_Fan", "DesiredSpeed", null).intValue();
        if (rpm > 0) {
            fanSpeeds[0] = rpm;
        }
        return fanSpeeds;
    }

    @Override
    public double getCpuVoltage() {
        int decivolts;
        double volts = 0.0;
        Map<String, List<String>> voltIdentifiers = WmiUtil.selectStringsFrom(OHM_NAMESPACE, HARDWARE_CLASS, IDENTIFIER_PROPERTY, "WHERE SensorType=\"Voltage\"");
        String voltIdentifierStr = null;
        for (String id : voltIdentifiers.get(IDENTIFIER_PROPERTY)) {
            if (!id.toLowerCase().contains("cpu")) continue;
            voltIdentifierStr = id;
            break;
        }
        if (voltIdentifierStr == null && !voltIdentifiers.get(IDENTIFIER_PROPERTY).isEmpty()) {
            voltIdentifierStr = voltIdentifiers.get(IDENTIFIER_PROPERTY).get(0);
        }
        if (voltIdentifierStr != null) {
            return WmiUtil.selectFloatFrom(OHM_NAMESPACE, SENSOR_CLASS, VALUE_PROPERTY, "WHERE Parent=\"" + voltIdentifierStr + "\" AND SensorType=\"Voltage\"").floatValue();
        }
        if (this.wmiVoltClass == null) {
            this.wmiVoltNamespace = "root\\cimv2";
            this.wmiVoltClass = "Win32_Processor";
            this.wmiVoltProperty = "CurrentVoltage";
            decivolts = WmiUtil.selectUint32From(this.wmiVoltNamespace, this.wmiVoltClass, this.wmiVoltProperty, null).intValue();
            if ((decivolts & 0x80) == 0 && decivolts > 0) {
                this.wmiVoltProperty = "VoltageCaps";
                decivolts = WmiUtil.selectUint32From(this.wmiVoltNamespace, this.wmiVoltClass, this.wmiVoltProperty, null).intValue();
            }
        } else {
            decivolts = WmiUtil.selectUint32From(this.wmiVoltNamespace, this.wmiVoltClass, this.wmiVoltProperty, null).intValue();
        }
        if (decivolts > 0) {
            if ("VoltageCaps".equals(this.wmiVoltProperty)) {
                if ((decivolts & 1) > 0) {
                    volts = 5.0;
                } else if ((decivolts & 2) > 0) {
                    volts = 3.3;
                } else if ((decivolts & 4) > 0) {
                    volts = 2.9;
                }
            } else {
                volts = (double)(decivolts & 0x7F) / 10.0;
            }
        }
        return volts;
    }
}

