/*
 * Decompiled with CFR 0.152.
 */
package oshi.json.hardware.impl;

import java.util.Properties;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import oshi.json.hardware.CentralProcessor;
import oshi.json.json.AbstractOshiJsonObject;
import oshi.json.json.NullAwareJsonObjectBuilder;
import oshi.json.util.PropertiesUtil;

public class CentralProcessorImpl
extends AbstractOshiJsonObject
implements CentralProcessor {
    private static final long serialVersionUID = 1L;
    private transient JsonBuilderFactory jsonFactory = Json.createBuilderFactory(null);
    private oshi.hardware.CentralProcessor processor;

    public CentralProcessorImpl(oshi.hardware.CentralProcessor processor) {
        this.processor = processor;
    }

    @Override
    public String getVendor() {
        return this.processor.getVendor();
    }

    @Override
    public void setVendor(String vendor) {
        this.processor.setVendor(vendor);
    }

    @Override
    public String getName() {
        return this.processor.getName();
    }

    @Override
    public void setName(String name) {
        this.processor.setName(name);
    }

    @Override
    public String getProcessorID() {
        return this.processor.getProcessorID();
    }

    @Override
    public void setProcessorID(String processorID) {
        this.processor.setProcessorID(processorID);
    }

    @Override
    public long getVendorFreq() {
        return this.processor.getVendorFreq();
    }

    @Override
    public void setVendorFreq(long freq) {
        this.processor.setVendorFreq(freq);
    }

    @Override
    public String getIdentifier() {
        return this.processor.getIdentifier();
    }

    @Override
    public void setIdentifier(String identifier) {
        this.processor.setIdentifier(identifier);
    }

    @Override
    public boolean isCpu64bit() {
        return this.processor.isCpu64bit();
    }

    @Override
    public void setCpu64(boolean cpu64) {
        this.processor.setCpu64(cpu64);
    }

    @Override
    public String getStepping() {
        return this.processor.getStepping();
    }

    @Override
    public void setStepping(String stepping) {
        this.processor.setStepping(stepping);
    }

    @Override
    public String getModel() {
        return this.processor.getModel();
    }

    @Override
    public void setModel(String model) {
        this.processor.setModel(model);
    }

    @Override
    public String getFamily() {
        return this.processor.getFamily();
    }

    @Override
    public void setFamily(String family) {
        this.processor.setFamily(family);
    }

    @Override
    public double getSystemCpuLoadBetweenTicks() {
        return this.processor.getSystemCpuLoadBetweenTicks();
    }

    @Override
    public long[] getSystemCpuLoadTicks() {
        return this.processor.getSystemCpuLoadTicks();
    }

    @Override
    public double getSystemCpuLoad() {
        return this.processor.getSystemCpuLoad();
    }

    @Override
    public double getSystemLoadAverage() {
        return this.processor.getSystemLoadAverage();
    }

    @Override
    public double[] getSystemLoadAverage(int nelem) {
        return this.processor.getSystemLoadAverage(nelem);
    }

    @Override
    public double[] getProcessorCpuLoadBetweenTicks() {
        return this.processor.getProcessorCpuLoadBetweenTicks();
    }

    @Override
    public long[][] getProcessorCpuLoadTicks() {
        return this.processor.getProcessorCpuLoadTicks();
    }

    @Override
    public long getSystemUptime() {
        return this.processor.getSystemUptime();
    }

    @Override
    @Deprecated
    public String getSystemSerialNumber() {
        return this.processor.getSystemSerialNumber();
    }

    @Override
    public int getLogicalProcessorCount() {
        return this.processor.getLogicalProcessorCount();
    }

    @Override
    public int getPhysicalProcessorCount() {
        return this.processor.getPhysicalProcessorCount();
    }

    @Override
    public JsonObject toJSON(Properties properties) {
        JsonObjectBuilder json = NullAwareJsonObjectBuilder.wrap(this.jsonFactory.createObjectBuilder());
        if (PropertiesUtil.getBoolean(properties, "hardware.processor.name")) {
            json.add("name", this.getName());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.processor.physicalProcessorCount")) {
            json.add("physicalProcessorCount", this.getPhysicalProcessorCount());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.processor.logicalProcessorCount")) {
            json.add("logicalProcessorCount", this.getLogicalProcessorCount());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.processor.vendor")) {
            json.add("vendor", this.getVendor());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.processor.vendorFreq")) {
            json.add("vendorFreq", this.getVendorFreq());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.processor.processorID")) {
            json.add("processorID", this.getProcessorID());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.processor.identifier")) {
            json.add("identifier", this.getIdentifier());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.processor.cpu64bit")) {
            json.add("cpu64bit", this.isCpu64bit());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.processor.family")) {
            json.add("family", this.getFamily());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.processor.model")) {
            json.add("model", this.getModel());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.processor.stepping")) {
            json.add("stepping", this.getStepping());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.processor.systemCpuLoadBetweenTicks")) {
            json.add("systemCpuLoadBetweenTicks", this.getSystemCpuLoadBetweenTicks());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.processor.systemCpuLoadTicks")) {
            JsonArrayBuilder systemCpuLoadTicksArrayBuilder = this.jsonFactory.createArrayBuilder();
            for (long ticks : this.getSystemCpuLoadTicks()) {
                systemCpuLoadTicksArrayBuilder.add(ticks);
            }
            json.add("systemCpuLoadTicks", (JsonValue)systemCpuLoadTicksArrayBuilder.build());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.processor.systemCpuLoad")) {
            json.add("systemCpuLoad", this.getSystemCpuLoad());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.processor.systemLoadAverage")) {
            json.add("systemLoadAverage", this.getSystemLoadAverage());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.processor.systemLoadAverages")) {
            JsonArrayBuilder systemLoadAverageArrayBuilder = this.jsonFactory.createArrayBuilder();
            for (double avg : this.getSystemLoadAverage(3)) {
                systemLoadAverageArrayBuilder.add(avg);
            }
            json.add("systemLoadAverages", (JsonValue)systemLoadAverageArrayBuilder.build());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.processor.processorCpuLoadBetweenTicks")) {
            JsonArrayBuilder processorCpuLoadBetweenTicksArrayBuilder = this.jsonFactory.createArrayBuilder();
            for (double load : this.getProcessorCpuLoadBetweenTicks()) {
                processorCpuLoadBetweenTicksArrayBuilder.add(load);
            }
            json.add("processorCpuLoadBetweenTicks", (JsonValue)processorCpuLoadBetweenTicksArrayBuilder.build());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.processor.processorCpuLoadTicks")) {
            JsonArrayBuilder processorCpuLoadTicksArrayBuilder = this.jsonFactory.createArrayBuilder();
            for (long[] procTicks : this.getProcessorCpuLoadTicks()) {
                JsonArrayBuilder processorTicksArrayBuilder = this.jsonFactory.createArrayBuilder();
                for (long ticks : procTicks) {
                    processorTicksArrayBuilder.add(ticks);
                }
                processorCpuLoadTicksArrayBuilder.add((JsonValue)processorTicksArrayBuilder.build());
            }
            json.add("processorCpuLoadTicks", (JsonValue)processorCpuLoadTicksArrayBuilder.build());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.processor.systemUptime")) {
            json.add("systemUptime", this.getSystemUptime());
        }
        return json.build();
    }

    @Override
    public String toString() {
        return this.processor.toString();
    }
}

