/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.linux;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oshi.software.os.OSUser;
import oshi.util.ExecutingCommand;

public class LinuxUserGroupInfo {
    private static final long CACHE_REFRESH_TIME_MS = 180000L;
    private static final UsersCache usersCache = new UsersCache();
    private static final GroupsCache groupsCache = new GroupsCache();

    public OSUser getUser(String userId) {
        return usersCache.getUser(userId);
    }

    public String getGroupName(String groupId) {
        return groupsCache.getGroup(groupId);
    }

    private static class UsersCache {
        private Map<String, OSUser> usersIdMap = new HashMap<String, OSUser>();
        private long lastRefreshedTimestamp;

        private UsersCache() {
        }

        public OSUser getUser(String userId) {
            OSUser osUser;
            if (System.currentTimeMillis() - this.lastRefreshedTimestamp > 180000L) {
                this.refresh();
            }
            if ((osUser = this.usersIdMap.get(userId)) == null) {
                this.refresh();
                return this.usersIdMap.get(userId);
            }
            return osUser;
        }

        private void refresh() {
            this.usersIdMap.clear();
            List<String> passwd = ExecutingCommand.runNative("getent passwd");
            for (String entry : passwd) {
                String[] split = entry.split(":");
                if (split.length < 3) continue;
                String userName = split[0];
                String uid = split[2];
                if (this.usersIdMap.containsKey(uid)) continue;
                OSUser user = new OSUser();
                user.setUserId(uid);
                user.setUserName(userName);
                this.usersIdMap.put(uid, user);
            }
            this.lastRefreshedTimestamp = System.currentTimeMillis();
        }
    }

    private static class GroupsCache {
        private Map<String, String> groupsIdMap = new HashMap<String, String>();
        private long lastRefreshedTimestamp;

        private GroupsCache() {
        }

        public String getGroup(String groupId) {
            String groupName;
            if (System.currentTimeMillis() - this.lastRefreshedTimestamp > 180000L) {
                this.refresh();
            }
            if ((groupName = this.groupsIdMap.get(groupId)) == null) {
                this.refresh();
                return this.groupsIdMap.get(groupId);
            }
            return groupName;
        }

        private void refresh() {
            this.groupsIdMap.clear();
            List<String> group = ExecutingCommand.runNative("getent group");
            for (String entry : group) {
                String[] split = entry.split(":");
                if (split.length < 3) continue;
                String groupName = split[0];
                String gid = split[2];
                if (this.groupsIdMap.containsKey(gid)) continue;
                this.groupsIdMap.put(gid, groupName);
            }
            this.lastRefreshedTimestamp = System.currentTimeMillis();
        }
    }
}

