/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import com.sun.jna.platform.win32.COM.WbemcliUtil;
import com.sun.jna.platform.win32.Kernel32;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.data.windows.PerfCounterWildcardQuery;
import oshi.hardware.Disks;
import oshi.hardware.HWDiskStore;
import oshi.hardware.HWPartition;
import oshi.util.MapUtil;
import oshi.util.ParseUtil;
import oshi.util.platform.windows.WmiQueryHandler;
import oshi.util.platform.windows.WmiUtil;

public class WindowsDisks
implements Disks {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(WindowsDisks.class);
    private static final String PHYSICALDRIVE_PREFIX = "\\\\.\\PHYSICALDRIVE";
    private static final String PHYSICAL_DISK = "PhysicalDisk";
    private static final Pattern DEVICE_ID = Pattern.compile(".*\\.DeviceID=\"(.*)\"");
    private static final int BUFSIZE = 255;
    private final transient WbemcliUtil.WmiQuery<DiskDriveProperty> diskDriveQuery = new WbemcliUtil.WmiQuery("Win32_DiskDrive", DiskDriveProperty.class);
    private final transient WbemcliUtil.WmiQuery<DriveToPartitionProperty> driveToPartitionQuery = new WbemcliUtil.WmiQuery("Win32_DiskDriveToDiskPartition", DriveToPartitionProperty.class);
    private final transient WbemcliUtil.WmiQuery<DriveToPartitionProperty> diskToParitionQuery = new WbemcliUtil.WmiQuery("Win32_LogicalDiskToPartition", DriveToPartitionProperty.class);
    private final transient WbemcliUtil.WmiQuery<DiskPartitionProperty> partitionQuery = new WbemcliUtil.WmiQuery("Win32_DiskPartition", DiskPartitionProperty.class);
    private static final PerfCounterWildcardQuery<PhysicalDiskProperty> physicalDiskPerfCounters = new PerfCounterWildcardQuery<PhysicalDiskProperty>(PhysicalDiskProperty.class, "PhysicalDisk", "Win32_PerfRawData_PerfDisk_PhysicalDisk WHERE NOT Name=\"_Total\"");
    private final transient WmiQueryHandler wmiQueryHandler = WmiQueryHandler.createInstance();

    public static boolean updateDiskStats(HWDiskStore diskStore) {
        String index = null;
        HWPartition[] partitions = diskStore.getPartitions();
        if (partitions.length > 0) {
            index = Integer.toString(partitions[0].getMajor());
        } else if (diskStore.getName().startsWith(PHYSICALDRIVE_PREFIX)) {
            index = diskStore.getName().substring(PHYSICALDRIVE_PREFIX.length(), diskStore.getName().length());
        } else {
            LOG.warn("Couldn't match index for {}", (Object)diskStore.getName());
            return false;
        }
        DiskStats stats = WindowsDisks.queryReadWriteStats(index);
        if (stats.readMap.containsKey(index)) {
            diskStore.setReads(MapUtil.getOrDefault(stats.readMap, index, 0L));
            diskStore.setReadBytes(MapUtil.getOrDefault(stats.readByteMap, index, 0L));
            diskStore.setWrites(MapUtil.getOrDefault(stats.writeMap, index, 0L));
            diskStore.setWriteBytes(MapUtil.getOrDefault(stats.writeByteMap, index, 0L));
            diskStore.setCurrentQueueLength(MapUtil.getOrDefault(stats.queueLengthMap, index, 0L));
            diskStore.setTimeStamp(stats.timeStamp);
            diskStore.setTransferTime(diskStore.getTimeStamp() - MapUtil.getOrDefault(stats.idleTimeMap, index, diskStore.getTimeStamp()));
            return true;
        }
        return false;
    }

    @Override
    public HWDiskStore[] getDisks() {
        ArrayList<HWDiskStore> result = new ArrayList<HWDiskStore>();
        DiskStats stats = WindowsDisks.queryReadWriteStats(null);
        PartitionMaps maps = this.queryPartitionMaps();
        WbemcliUtil.WmiResult<DiskDriveProperty> vals = this.wmiQueryHandler.queryWMI(this.diskDriveQuery);
        for (int i = 0; i < vals.getResultCount(); ++i) {
            HWDiskStore ds = new HWDiskStore();
            ds.setName(WmiUtil.getString(vals, DiskDriveProperty.NAME, i));
            ds.setModel(String.format("%s %s", WmiUtil.getString(vals, DiskDriveProperty.MODEL, i), WmiUtil.getString(vals, DiskDriveProperty.MANUFACTURER, i)).trim());
            ds.setSerial(ParseUtil.hexStringToString(WmiUtil.getString(vals, DiskDriveProperty.SERIALNUMBER, i)));
            String index = Integer.toString(WmiUtil.getUint32(vals, DiskDriveProperty.INDEX, i));
            ds.setReads(MapUtil.getOrDefault(stats.readMap, index, 0L));
            ds.setReadBytes(MapUtil.getOrDefault(stats.readByteMap, index, 0L));
            ds.setWrites(MapUtil.getOrDefault(stats.writeMap, index, 0L));
            ds.setWriteBytes(MapUtil.getOrDefault(stats.writeByteMap, index, 0L));
            ds.setCurrentQueueLength(MapUtil.getOrDefault(stats.queueLengthMap, index, 0L));
            ds.setTimeStamp(stats.timeStamp);
            ds.setTransferTime(ds.getTimeStamp() - MapUtil.getOrDefault(stats.idleTimeMap, index, ds.getTimeStamp()));
            ds.setSize(WmiUtil.getUint64(vals, DiskDriveProperty.SIZE, i));
            ArrayList partitions = new ArrayList();
            List partList = (List)maps.driveToPartitionMap.get(ds.getName());
            if (partList != null && !partList.isEmpty()) {
                for (String part : partList) {
                    if (!maps.partitionMap.containsKey(part)) continue;
                    partitions.add(maps.partitionMap.get(part));
                }
            }
            ds.setPartitions(partitions.toArray(new HWPartition[partitions.size()]));
            result.add(ds);
        }
        return result.toArray(new HWDiskStore[result.size()]);
    }

    private static DiskStats queryReadWriteStats(String index) {
        WindowsDisks windowsDisks = new WindowsDisks();
        Objects.requireNonNull(windowsDisks);
        DiskStats stats = windowsDisks.new DiskStats();
        Map<PhysicalDiskProperty, List<Long>> valueMap = physicalDiskPerfCounters.queryValuesWildcard();
        stats.timeStamp = System.currentTimeMillis();
        List<String> instances = physicalDiskPerfCounters.getInstancesFromLastQuery();
        List<Long> readList = valueMap.get(PhysicalDiskProperty.DISKREADSPERSEC);
        List<Long> readByteList = valueMap.get(PhysicalDiskProperty.DISKREADBYTESPERSEC);
        List<Long> writeList = valueMap.get(PhysicalDiskProperty.DISKWRITESPERSEC);
        List<Long> writeByteList = valueMap.get(PhysicalDiskProperty.DISKWRITEBYTESPERSEC);
        List<Long> queueLengthList = valueMap.get(PhysicalDiskProperty.CURRENTDISKQUEUELENGTH);
        List<Long> idleTimeList = valueMap.get(PhysicalDiskProperty.PERCENTIDLETIME);
        if (instances.isEmpty() || readList == null || readByteList == null || writeList == null || writeByteList == null || queueLengthList == null || idleTimeList == null) {
            return stats;
        }
        for (int i = 0; i < instances.size(); ++i) {
            String name = WindowsDisks.getIndexFromName(instances.get(i));
            if (index != null && !index.equals(name)) continue;
            stats.readMap.put(name, readList.get(i));
            stats.readByteMap.put(name, readByteList.get(i));
            stats.writeMap.put(name, writeList.get(i));
            stats.writeByteMap.put(name, writeByteList.get(i));
            stats.queueLengthMap.put(name, queueLengthList.get(i));
            stats.idleTimeMap.put(name, idleTimeList.get(i) / 10000L);
        }
        return stats;
    }

    private PartitionMaps queryPartitionMaps() {
        Matcher mDep;
        Matcher mAnt;
        WindowsDisks windowsDisks = new WindowsDisks();
        Objects.requireNonNull(windowsDisks);
        PartitionMaps maps = windowsDisks.new PartitionMaps();
        WbemcliUtil.WmiResult<DriveToPartitionProperty> drivePartitionMap = this.wmiQueryHandler.queryWMI(this.driveToPartitionQuery);
        for (int i = 0; i < drivePartitionMap.getResultCount(); ++i) {
            mAnt = DEVICE_ID.matcher(WmiUtil.getRefString(drivePartitionMap, DriveToPartitionProperty.ANTECEDENT, i));
            mDep = DEVICE_ID.matcher(WmiUtil.getRefString(drivePartitionMap, DriveToPartitionProperty.DEPENDENT, i));
            if (!mAnt.matches() || !mDep.matches()) continue;
            MapUtil.createNewListIfAbsent(maps.driveToPartitionMap, mAnt.group(1).replaceAll("\\\\\\\\", "\\\\")).add(mDep.group(1));
        }
        WbemcliUtil.WmiResult<DriveToPartitionProperty> diskPartitionMap = this.wmiQueryHandler.queryWMI(this.diskToParitionQuery);
        for (int i = 0; i < diskPartitionMap.getResultCount(); ++i) {
            mAnt = DEVICE_ID.matcher(WmiUtil.getRefString(diskPartitionMap, DriveToPartitionProperty.ANTECEDENT, i));
            mDep = DEVICE_ID.matcher(WmiUtil.getRefString(diskPartitionMap, DriveToPartitionProperty.DEPENDENT, i));
            if (!mAnt.matches() || !mDep.matches()) continue;
            maps.partitionToLogicalDriveMap.put(mAnt.group(1), mDep.group(1) + "\\");
        }
        WbemcliUtil.WmiResult<DiskPartitionProperty> hwPartitionQueryMap = this.wmiQueryHandler.queryWMI(this.partitionQuery);
        for (int i = 0; i < hwPartitionQueryMap.getResultCount(); ++i) {
            String deviceID = WmiUtil.getString(hwPartitionQueryMap, DiskPartitionProperty.DEVICEID, i);
            String logicalDrive = MapUtil.getOrDefault(maps.partitionToLogicalDriveMap, deviceID, "");
            String uuid = "";
            if (!logicalDrive.isEmpty()) {
                char[] volumeChr = new char[255];
                Kernel32.INSTANCE.GetVolumeNameForVolumeMountPoint(logicalDrive, volumeChr, 255);
                uuid = ParseUtil.parseUuidOrDefault(new String(volumeChr).trim(), "");
            }
            maps.partitionMap.put(deviceID, new HWPartition(WmiUtil.getString(hwPartitionQueryMap, DiskPartitionProperty.NAME, i), WmiUtil.getString(hwPartitionQueryMap, DiskPartitionProperty.TYPE, i), WmiUtil.getString(hwPartitionQueryMap, DiskPartitionProperty.DESCRIPTION, i), uuid, WmiUtil.getUint64(hwPartitionQueryMap, DiskPartitionProperty.SIZE, i), WmiUtil.getUint32(hwPartitionQueryMap, DiskPartitionProperty.DISKINDEX, i), WmiUtil.getUint32(hwPartitionQueryMap, DiskPartitionProperty.INDEX, i), logicalDrive));
        }
        return maps;
    }

    private static String getIndexFromName(String s) {
        if (s.isEmpty()) {
            return s;
        }
        return s.split("\\s")[0];
    }

    static enum DiskDriveProperty {
        INDEX,
        MANUFACTURER,
        MODEL,
        NAME,
        SERIALNUMBER,
        SIZE;

    }

    static enum DriveToPartitionProperty {
        ANTECEDENT,
        DEPENDENT;

    }

    static enum DiskPartitionProperty {
        DESCRIPTION,
        DEVICEID,
        DISKINDEX,
        INDEX,
        NAME,
        SIZE,
        TYPE;

    }

    private final class DiskStats {
        private final Map<String, Long> readMap = new HashMap<String, Long>();
        private final Map<String, Long> readByteMap = new HashMap<String, Long>();
        private final Map<String, Long> writeMap = new HashMap<String, Long>();
        private final Map<String, Long> writeByteMap = new HashMap<String, Long>();
        private final Map<String, Long> queueLengthMap = new HashMap<String, Long>();
        private final Map<String, Long> idleTimeMap = new HashMap<String, Long>();
        private long timeStamp;

        private DiskStats() {
        }
    }

    private final class PartitionMaps {
        private final Map<String, List<String>> driveToPartitionMap = new HashMap<String, List<String>>();
        private final Map<String, String> partitionToLogicalDriveMap = new HashMap<String, String>();
        private final Map<String, HWPartition> partitionMap = new HashMap<String, HWPartition>();

        private PartitionMaps() {
        }
    }

    static enum PhysicalDiskProperty implements PerfCounterWildcardQuery.PdhCounterWildcardProperty
    {
        NAME("^_Total"),
        DISKREADSPERSEC("Disk Reads/sec"),
        DISKREADBYTESPERSEC("Disk Read Bytes/sec"),
        DISKWRITESPERSEC("Disk Writes/sec"),
        DISKWRITEBYTESPERSEC("Disk Write Bytes/sec"),
        CURRENTDISKQUEUELENGTH("Current Disk Queue Length"),
        PERCENTIDLETIME("% Idle Time");

        private final String counter;

        private PhysicalDiskProperty(String counter) {
            this.counter = counter;
        }

        @Override
        public String getCounter() {
            return this.counter;
        }
    }
}

