/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import com.sun.jna.platform.win32.COM.WbemcliUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oshi.hardware.common.AbstractSoundCard;
import oshi.util.platform.windows.WmiUtil;

public class WindowsSoundCard
extends AbstractSoundCard {
    private static final Map<String, String> NAME_MAP = new HashMap<String, String>();
    private static final String DRIVER_QUERY;

    public WindowsSoundCard(String kernelVersion, String name, String codec) {
        super(kernelVersion, name, codec);
    }

    private static String createClause() {
        StringBuilder sb = new StringBuilder("Win32_PnPSignedDriver");
        boolean first = true;
        for (String key : NAME_MAP.keySet()) {
            if (first) {
                sb.append(" WHERE");
                first = false;
            } else {
                sb.append(" OR");
            }
            sb.append(" DeviceName LIKE \"%").append(key).append("%\"");
        }
        return sb.toString();
    }

    private static String getAudioCardKernelVersion(int index, WbemcliUtil.WmiResult<SoundCardKernel> cardKernelQueryResult) {
        String audioCardKernel = WmiUtil.getString(cardKernelQueryResult, SoundCardKernel.DRIVERPROVIDERNAME, index) + " " + WmiUtil.getString(cardKernelQueryResult, SoundCardKernel.DEVICENAME, index) + " " + WmiUtil.getString(cardKernelQueryResult, SoundCardKernel.DRIVERNAME, index) + " " + WmiUtil.getString(cardKernelQueryResult, SoundCardKernel.DRIVERVERSION, index);
        return audioCardKernel;
    }

    public static List<WindowsSoundCard> getSoundCards() {
        WbemcliUtil.WmiQuery cardKernelQuery = new WbemcliUtil.WmiQuery(DRIVER_QUERY, SoundCardKernel.class);
        WbemcliUtil.WmiResult cardKernelQueryResult = WmiUtil.queryWMI(cardKernelQuery);
        ArrayList<WindowsSoundCard> soundCards = new ArrayList<WindowsSoundCard>();
        for (int i = 0; i < cardKernelQueryResult.getResultCount(); ++i) {
            if (!NAME_MAP.containsKey(WmiUtil.getString(cardKernelQueryResult, SoundCardKernel.DEVICENAME, i))) continue;
            soundCards.add(new WindowsSoundCard(WindowsSoundCard.getAudioCardKernelVersion(i, cardKernelQueryResult), WmiUtil.getString(cardKernelQueryResult, SoundCardKernel.DRIVERPROVIDERNAME, i) + " " + WmiUtil.getString(cardKernelQueryResult, SoundCardKernel.DEVICENAME, i), WmiUtil.getString(cardKernelQueryResult, SoundCardKernel.DEVICENAME, i)));
        }
        return soundCards;
    }

    static {
        WbemcliUtil.WmiQuery soundCardQuery = new WbemcliUtil.WmiQuery("Win32_SoundDevice", SoundCardName.class);
        WbemcliUtil.WmiResult soundCardResult = WmiUtil.queryWMI(soundCardQuery);
        for (int i = 0; i < soundCardResult.getResultCount(); ++i) {
            NAME_MAP.put(WmiUtil.getString(soundCardResult, SoundCardName.NAME, i), WmiUtil.getString(soundCardResult, SoundCardName.MANUFACTURER, i));
        }
        DRIVER_QUERY = WindowsSoundCard.createClause();
    }

    static enum SoundCardKernel {
        DRIVERPROVIDERNAME,
        DRIVERNAME,
        DRIVERVERSION,
        DEVICENAME;

    }

    static enum SoundCardName {
        MANUFACTURER,
        NAME;

    }
}

