/*
 * Decompiled with CFR 0.152.
 */
package oshi.demo.gui;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.time.Instant;
import java.util.List;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.Timer;
import oshi.SystemInfo;
import oshi.demo.gui.OshiJPanel;
import oshi.hardware.CentralProcessor;
import oshi.hardware.ComputerSystem;
import oshi.hardware.Display;
import oshi.software.os.OperatingSystem;
import oshi.util.EdidUtil;
import oshi.util.FormatUtil;

public class OsHwTextPanel
extends OshiJPanel {
    private static final long serialVersionUID = 1L;
    private static final String OPERATING_SYSTEM = "Operating System";
    private static final String HARDWARE_INFORMATION = "Hardware Information";
    private static final String PROCESSOR = "Processor";
    private static final String DISPLAYS = "Displays";
    private String osPrefix;

    public OsHwTextPanel(SystemInfo si) {
        this.init(si);
    }

    private void init(SystemInfo si) {
        this.osPrefix = OsHwTextPanel.getOsPrefix(si);
        GridBagConstraints osLabel = new GridBagConstraints();
        GridBagConstraints osConstraints = new GridBagConstraints();
        osConstraints.gridy = 1;
        osConstraints.fill = 1;
        osConstraints.insets = new Insets(0, 0, 15, 15);
        GridBagConstraints procLabel = (GridBagConstraints)osLabel.clone();
        procLabel.gridy = 2;
        GridBagConstraints procConstraints = (GridBagConstraints)osConstraints.clone();
        procConstraints.gridy = 3;
        GridBagConstraints displayLabel = (GridBagConstraints)procLabel.clone();
        displayLabel.gridy = 4;
        GridBagConstraints displayConstraints = (GridBagConstraints)osConstraints.clone();
        displayConstraints.gridy = 5;
        displayConstraints.insets = new Insets(0, 0, 0, 15);
        GridBagConstraints csLabel = (GridBagConstraints)osLabel.clone();
        csLabel.gridx = 1;
        GridBagConstraints csConstraints = new GridBagConstraints();
        csConstraints.gridx = 1;
        csConstraints.gridheight = 6;
        csConstraints.fill = 1;
        JPanel oshwPanel = new JPanel();
        oshwPanel.setLayout(new GridBagLayout());
        JTextArea osArea = new JTextArea(0, 0);
        osArea.setText(this.updateOsData(si));
        oshwPanel.add((Component)new JLabel(OPERATING_SYSTEM), osLabel);
        oshwPanel.add((Component)osArea, osConstraints);
        JTextArea procArea = new JTextArea(0, 0);
        procArea.setText(OsHwTextPanel.getProc(si));
        oshwPanel.add((Component)new JLabel(PROCESSOR), procLabel);
        oshwPanel.add((Component)procArea, procConstraints);
        JTextArea displayArea = new JTextArea(0, 0);
        displayArea.setText(OsHwTextPanel.getDisplay(si));
        oshwPanel.add((Component)new JLabel(DISPLAYS), displayLabel);
        oshwPanel.add((Component)displayArea, displayConstraints);
        JTextArea csArea = new JTextArea(0, 0);
        csArea.setText(OsHwTextPanel.getHw(si));
        oshwPanel.add((Component)new JLabel(HARDWARE_INFORMATION), csLabel);
        oshwPanel.add((Component)csArea, csConstraints);
        this.add((Component)oshwPanel, "Center");
        Timer timer = new Timer(1000, e -> osArea.setText(this.updateOsData(si)));
        timer.start();
    }

    private static String getOsPrefix(SystemInfo si) {
        StringBuilder sb = new StringBuilder(OPERATING_SYSTEM);
        OperatingSystem os = si.getOperatingSystem();
        sb.append(String.valueOf(os));
        sb.append("\n\n").append("Booted: ").append(Instant.ofEpochSecond(os.getSystemBootTime())).append('\n').append("Uptime: ");
        return sb.toString();
    }

    private static String getHw(SystemInfo si) {
        StringBuilder sb = new StringBuilder();
        ObjectMapper mapper = new ObjectMapper();
        ComputerSystem computerSystem = si.getHardware().getComputerSystem();
        try {
            sb.append(mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)computerSystem));
        }
        catch (JsonProcessingException e) {
            sb.append(e.getMessage());
        }
        return sb.toString();
    }

    private static String getProc(SystemInfo si) {
        StringBuilder sb = new StringBuilder();
        CentralProcessor proc = si.getHardware().getProcessor();
        sb.append(proc.toString());
        return sb.toString();
    }

    private static String getDisplay(SystemInfo si) {
        StringBuilder sb = new StringBuilder();
        List<Display> displays = si.getHardware().getDisplays();
        if (displays.isEmpty()) {
            sb.append("None detected.");
        } else {
            int i = 0;
            for (Display display : displays) {
                byte[] edid = display.getEdid();
                byte[][] desc = EdidUtil.getDescriptors(edid);
                String name = "Display " + i;
                for (byte[] b : desc) {
                    if (EdidUtil.getDescriptorType(b) != 252) continue;
                    name = EdidUtil.getDescriptorText(b);
                }
                if (i++ > 0) {
                    sb.append('\n');
                }
                sb.append(name).append(": ");
                int hSize = EdidUtil.getHcm(edid);
                int vSize = EdidUtil.getVcm(edid);
                sb.append(String.format(Locale.ROOT, "%d x %d cm (%.1f x %.1f in)", hSize, vSize, (double)hSize / 2.54, (double)vSize / 2.54));
            }
        }
        return sb.toString();
    }

    private String updateOsData(SystemInfo si) {
        return this.osPrefix + FormatUtil.formatElapsedSecs(si.getOperatingSystem().getSystemUptime());
    }
}

