/*
 * Decompiled with CFR 0.152.
 */
package oshi.demo.gui;

import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oshi.PlatformEnum;
import oshi.SystemInfo;
import oshi.demo.gui.OshiJPanel;
import oshi.software.os.OSProcess;
import oshi.software.os.OperatingSystem;
import oshi.util.FormatUtil;

public class ProcessPanel
extends OshiJPanel {
    private static final long serialVersionUID = 1L;
    private static final String PROCESSES = "Processes";
    private static final String[] COLUMNS = new String[]{"PID", "PPID", "Threads", "% CPU", "Cumulative", "VSZ", "RSS", "% Memory", "Process Name"};
    private static final double[] COLUMN_WIDTH_PERCENT = new double[]{0.07, 0.07, 0.07, 0.07, 0.09, 0.1, 0.1, 0.08, 0.35};
    private transient Map<Integer, OSProcess> priorSnapshotMap = new HashMap<Integer, OSProcess>();
    private transient ButtonGroup cpuOption = new ButtonGroup();
    private transient JRadioButton perProc = new JRadioButton("of one Processor");
    private transient JRadioButton perSystem = new JRadioButton("of System");
    private transient ButtonGroup sortOption = new ButtonGroup();
    private transient JRadioButton cpuButton = new JRadioButton("CPU %");
    private transient JRadioButton cumulativeCpuButton = new JRadioButton("Cumulative CPU");
    private transient JRadioButton memButton = new JRadioButton("Memory %");

    public ProcessPanel(SystemInfo si) {
        this.init(si);
    }

    private void init(SystemInfo si) {
        OperatingSystem os = si.getOperatingSystem();
        JLabel procLabel = new JLabel(PROCESSES);
        this.add((Component)procLabel, "North");
        JPanel settings = new JPanel();
        JLabel cpuChoice = new JLabel("          CPU %:");
        settings.add(cpuChoice);
        this.cpuOption.add(this.perProc);
        settings.add(this.perProc);
        this.cpuOption.add(this.perSystem);
        settings.add(this.perSystem);
        if (SystemInfo.getCurrentPlatform().equals((Object)PlatformEnum.WINDOWS)) {
            this.perSystem.setSelected(true);
        } else {
            this.perProc.setSelected(true);
        }
        JLabel sortChoice = new JLabel("          Sort by:");
        settings.add(sortChoice);
        this.sortOption.add(this.cpuButton);
        settings.add(this.cpuButton);
        this.sortOption.add(this.cumulativeCpuButton);
        settings.add(this.cumulativeCpuButton);
        this.sortOption.add(this.memButton);
        settings.add(this.memButton);
        this.cpuButton.setSelected(true);
        DefaultTableModel model = new DefaultTableModel(this.parseProcesses(os.getProcesses(null, null, 0), si), COLUMNS);
        JTable procTable = new JTable(model);
        JScrollPane scrollV = new JScrollPane(procTable);
        scrollV.setVerticalScrollBarPolicy(20);
        ProcessPanel.resizeColumns(procTable.getColumnModel());
        this.add((Component)scrollV, "Center");
        this.add((Component)settings, "South");
        Timer timer = new Timer(5000, e -> {
            int row;
            DefaultTableModel tableModel = (DefaultTableModel)procTable.getModel();
            Object[][] newData = this.parseProcesses(os.getProcesses(null, null, 0), si);
            int rowCount = tableModel.getRowCount();
            for (row = 0; row < newData.length; ++row) {
                if (row < rowCount) {
                    for (int col = 0; col < newData[row].length; ++col) {
                        tableModel.setValueAt(newData[row][col], row, col);
                    }
                    continue;
                }
                tableModel.addRow(newData[row]);
            }
            for (row = rowCount - 1; row >= newData.length; --row) {
                tableModel.removeRow(row);
            }
        });
        timer.start();
    }

    private Object[][] parseProcesses(List<OSProcess> list, SystemInfo si) {
        long totalMem = si.getHardware().getMemory().getTotal();
        int cpuCount = si.getHardware().getProcessor().getLogicalProcessorCount();
        HashMap<OSProcess, Double> processSortValueMap = new HashMap<OSProcess, Double>();
        for (OSProcess p : list) {
            int pid = p.getProcessID();
            if (pid <= 0 && SystemInfo.getCurrentPlatform().equals((Object)PlatformEnum.WINDOWS)) continue;
            if (this.cpuButton.isSelected()) {
                processSortValueMap.put(p, p.getProcessCpuLoadBetweenTicks(this.priorSnapshotMap.get(pid)));
                continue;
            }
            if (this.cumulativeCpuButton.isSelected()) {
                processSortValueMap.put(p, p.getProcessCpuLoadCumulative());
                continue;
            }
            processSortValueMap.put(p, Double.valueOf(p.getResidentSetSize()));
        }
        ArrayList procList = new ArrayList(processSortValueMap.entrySet());
        procList.sort(Map.Entry.comparingByValue());
        int i = procList.size();
        Object[][] procArr = new Object[i][COLUMNS.length];
        for (Map.Entry entry : procList) {
            OSProcess p = (OSProcess)entry.getKey();
            int pid = p.getProcessID();
            procArr[--i][0] = pid;
            procArr[i][1] = p.getParentProcessID();
            procArr[i][2] = p.getThreadCount();
            if (this.perProc.isSelected()) {
                procArr[i][3] = String.format(Locale.ROOT, "%.1f", 100.0 * p.getProcessCpuLoadBetweenTicks(this.priorSnapshotMap.get(pid)) * (double)cpuCount);
                procArr[i][4] = String.format(Locale.ROOT, "%.1f", 100.0 * p.getProcessCpuLoadCumulative() * (double)cpuCount);
            } else {
                procArr[i][3] = String.format(Locale.ROOT, "%.1f", 100.0 * p.getProcessCpuLoadBetweenTicks(this.priorSnapshotMap.get(pid)));
                procArr[i][4] = String.format(Locale.ROOT, "%.1f", 100.0 * p.getProcessCpuLoadCumulative());
            }
            procArr[i][5] = FormatUtil.formatBytes(p.getVirtualSize());
            procArr[i][6] = FormatUtil.formatBytes(p.getResidentSetSize());
            procArr[i][7] = String.format(Locale.ROOT, "%.1f", 100.0 * (double)p.getResidentSetSize() / (double)totalMem);
            procArr[i][8] = p.getName();
        }
        this.priorSnapshotMap.clear();
        for (OSProcess oSProcess : list) {
            this.priorSnapshotMap.put(oSProcess.getProcessID(), oSProcess);
        }
        return procArr;
    }

    private static void resizeColumns(TableColumnModel tableColumnModel) {
        int tW = tableColumnModel.getTotalColumnWidth();
        int cantCols = tableColumnModel.getColumnCount();
        for (int i = 0; i < cantCols; ++i) {
            TableColumn column = tableColumnModel.getColumn(i);
            int pWidth = (int)Math.round(COLUMN_WIDTH_PERCENT[i] * (double)tW);
            column.setPreferredWidth(pWidth);
        }
    }
}

