/*
 * Decompiled with CFR 0.152.
 */
package oshi.demo.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oshi.SystemInfo;
import oshi.demo.gui.OshiJPanel;
import oshi.hardware.NetworkIF;
import oshi.software.os.NetworkParams;
import oshi.software.os.OperatingSystem;

public class InterfacePanel
extends OshiJPanel {
    private static final long serialVersionUID = 1L;
    private static final int INIT_HASH_SIZE = 100;
    private static final String IP_ADDRESS_SEPARATOR = "; ";
    private static final String PARAMS = "Network Parameters";
    private static final String INTERFACES = "Network Interfaces";
    private static final String[] COLUMNS = new String[]{"Name", "Index", "Speed", "IPv4 Address", "IPv6 address", "MAC address"};
    private static final double[] COLUMN_WIDTH_PERCENT = new double[]{0.02, 0.02, 0.1, 0.25, 0.45, 0.15};

    public InterfacePanel(SystemInfo si) {
        this.init(si);
    }

    private void init(SystemInfo si) {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BoxLayout(this, 1));
        JLabel paramsLabel = new JLabel(PARAMS);
        paramsLabel.setAlignmentX(0.5f);
        this.add(paramsLabel);
        JTextArea paramsArea = new JTextArea(0, 0);
        paramsArea.setText(InterfacePanel.buildParamsText(si.getOperatingSystem()));
        this.add(paramsArea);
        JLabel interfaceLabel = new JLabel(INTERFACES);
        interfaceLabel.setAlignmentX(0.5f);
        this.add(interfaceLabel);
        List<NetworkIF> networkIfList = si.getHardware().getNetworkIFs(true);
        DefaultTableModel model = new DefaultTableModel(InterfacePanel.parseInterfaces(networkIfList), COLUMNS);
        JTable intfTable = new JTable(model);
        JScrollPane scrollV = new JScrollPane(intfTable);
        scrollV.setVerticalScrollBarPolicy(20);
        InterfacePanel.resizeColumns(intfTable.getColumnModel());
        this.add(scrollV);
    }

    private static String buildParamsText(OperatingSystem os) {
        NetworkParams params = os.getNetworkParams();
        StringBuilder sb = new StringBuilder("Host Name: ").append(params.getHostName());
        if (!params.getDomainName().isEmpty()) {
            sb.append("\nDomain Name: ").append(params.getDomainName());
        }
        sb.append("\nIPv4 Default Gateway: ").append(params.getIpv4DefaultGateway());
        if (!params.getIpv6DefaultGateway().isEmpty()) {
            sb.append("\nIPv6 Default Gateway: ").append(params.getIpv6DefaultGateway());
        }
        sb.append("\nDNS Servers: ").append(InterfacePanel.getIPAddressesString(params.getDnsServers()));
        return sb.toString();
    }

    private static Object[][] parseInterfaces(List<NetworkIF> list) {
        HashMap<NetworkIF, Integer> intfSortValueMap = new HashMap<NetworkIF, Integer>(100);
        for (NetworkIF intf : list) {
            intfSortValueMap.put(intf, intf.getIndex());
        }
        ArrayList intfList = new ArrayList(intfSortValueMap.entrySet());
        intfList.sort(Map.Entry.comparingByValue());
        int i = 0;
        Object[][] intfArr = new Object[intfList.size()][COLUMNS.length];
        for (Map.Entry entry : intfList) {
            NetworkIF intf = (NetworkIF)entry.getKey();
            intfArr[i][0] = intf.getName();
            intfArr[i][1] = intf.getIndex();
            intfArr[i][2] = intf.getSpeed();
            intfArr[i][3] = InterfacePanel.getIPAddressesString(intf.getIPv4addr());
            intfArr[i][4] = InterfacePanel.getIPAddressesString(intf.getIPv6addr());
            intfArr[i][5] = "unknown".equals(intf.getMacaddr()) ? "" : intf.getMacaddr();
            ++i;
        }
        return intfArr;
    }

    private static void resizeColumns(TableColumnModel tableColumnModel) {
        int tW = tableColumnModel.getTotalColumnWidth();
        int cantCols = tableColumnModel.getColumnCount();
        for (int i = 0; i < cantCols; ++i) {
            TableColumn column = tableColumnModel.getColumn(i);
            int pWidth = (int)Math.round(COLUMN_WIDTH_PERCENT[i] * (double)tW);
            column.setPreferredWidth(pWidth);
        }
    }

    private static String getIPAddressesString(String[] ipAddressArr) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String ipAddress : ipAddressArr) {
            if (first) {
                first = false;
            } else {
                sb.append(IP_ADDRESS_SEPARATOR);
            }
            sb.append(ipAddress);
        }
        return sb.toString();
    }
}

