/*
 * Decompiled with CFR 0.152.
 */
package oshi.demo;

import com.sun.jna.platform.win32.COM.COMException;
import com.sun.jna.platform.win32.COM.WbemcliUtil;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.util.platform.windows.WmiQueryHandler;
import oshi.util.platform.windows.WmiUtil;

public class WmiNoComInitQueryHandler
extends WmiQueryHandler {
    private static final Logger LOG = LoggerFactory.getLogger(WmiNoComInitQueryHandler.class);

    @Override
    public <T extends Enum<T>> WbemcliUtil.WmiResult<T> queryWMI(WbemcliUtil.WmiQuery<T> query) {
        WbemcliUtil wbemcliUtil = WbemcliUtil.INSTANCE;
        Objects.requireNonNull(wbemcliUtil);
        WbemcliUtil.WmiResult result = new WbemcliUtil.WmiResult(wbemcliUtil, query.getPropertyEnum());
        if (this.failedWmiClassNames.contains(query.getWmiClassName())) {
            return result;
        }
        try {
            result = query.execute(this.wmiTimeout);
        }
        catch (COMException e) {
            if (!"ROOT\\OpenHardwareMonitor".equals(query.getNameSpace())) {
                int hresult = e.getHresult() == null ? -1 : e.getHresult().intValue();
                switch (hresult) {
                    case -2147217394: {
                        LOG.warn("COM exception: Invalid Namespace {}", (Object)query.getNameSpace());
                        break;
                    }
                    case -2147217392: {
                        LOG.warn("COM exception: Invalid Class {}", (Object)query.getWmiClassName());
                        break;
                    }
                    case -2147217385: {
                        LOG.warn("COM exception: Invalid Query: {}", (Object)WmiUtil.queryToString(query));
                        break;
                    }
                    default: {
                        this.handleComException(query, e);
                    }
                }
                this.failedWmiClassNames.add(query.getWmiClassName());
            }
        }
        catch (TimeoutException e) {
            LOG.error("WMI query timed out after {} ms: {}", (Object)this.wmiTimeout, (Object)WmiUtil.queryToString(query));
        }
        return result;
    }
}

