/*
 * Decompiled with CFR 0.152.
 */
package oshi.demo.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import javax.swing.JPanel;
import javax.swing.Timer;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.data.time.DynamicTimeSeriesCollection;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.xy.XYDataset;
import oshi.SystemInfo;
import oshi.demo.gui.OshiJPanel;
import oshi.hardware.CentralProcessor;

public class ProcessorPanel
extends OshiJPanel {
    private static final long serialVersionUID = 1L;
    private long[] oldTicks;
    private long[][] oldProcTicks;

    public ProcessorPanel(SystemInfo si) {
        CentralProcessor cpu = si.getHardware().getProcessor();
        this.oldTicks = new long[CentralProcessor.TickType.values().length];
        this.oldProcTicks = new long[cpu.getLogicalProcessorCount()][CentralProcessor.TickType.values().length];
        this.init(cpu);
    }

    private void init(CentralProcessor processor) {
        GridBagConstraints sysConstraints = new GridBagConstraints();
        sysConstraints.weightx = 1.0;
        sysConstraints.weighty = 1.0;
        sysConstraints.fill = 1;
        GridBagConstraints procConstraints = (GridBagConstraints)sysConstraints.clone();
        procConstraints.gridx = 1;
        Date date = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
        DynamicTimeSeriesCollection sysData = new DynamicTimeSeriesCollection(1, 60, (RegularTimePeriod)new Second());
        sysData.setTimeBase((RegularTimePeriod)new Second(date));
        sysData.addSeries(ProcessorPanel.floatArrayPercent(this.cpuData(processor)), 0, (Comparable)((Object)"All cpus"));
        JFreeChart systemCpu = ChartFactory.createTimeSeriesChart((String)"System CPU Usage", (String)"Time", (String)"% CPU", (XYDataset)sysData, (boolean)true, (boolean)true, (boolean)false);
        double[] procUsage = this.procData(processor);
        DynamicTimeSeriesCollection procData = new DynamicTimeSeriesCollection(procUsage.length, 60, (RegularTimePeriod)new Second());
        procData.setTimeBase((RegularTimePeriod)new Second(date));
        for (int i = 0; i < procUsage.length; ++i) {
            procData.addSeries(ProcessorPanel.floatArrayPercent(procUsage[i]), i, (Comparable)((Object)("cpu" + i)));
        }
        JFreeChart procCpu = ChartFactory.createTimeSeriesChart((String)"Processor CPU Usage", (String)"Time", (String)"% CPU", (XYDataset)procData, (boolean)true, (boolean)true, (boolean)false);
        JPanel cpuPanel = new JPanel();
        cpuPanel.setLayout(new GridBagLayout());
        cpuPanel.add((Component)new ChartPanel(systemCpu), sysConstraints);
        cpuPanel.add((Component)new ChartPanel(procCpu), procConstraints);
        this.add((Component)cpuPanel, "Center");
        Timer timer = new Timer(1000, e -> {
            sysData.advanceTime();
            sysData.appendData(ProcessorPanel.floatArrayPercent(this.cpuData(processor)));
            procData.advanceTime();
            int newest = procData.getNewestIndex();
            double[] procUsageData = this.procData(processor);
            for (int i = 0; i < procUsageData.length; ++i) {
                procData.addValue(i, newest, (float)(100.0 * procUsageData[i]));
            }
        });
        timer.start();
    }

    private static float[] floatArrayPercent(double d) {
        float[] f = new float[]{(float)(100.0 * d)};
        return f;
    }

    private double cpuData(CentralProcessor proc) {
        double d = proc.getSystemCpuLoadBetweenTicks(this.oldTicks);
        this.oldTicks = proc.getSystemCpuLoadTicks();
        return d;
    }

    private double[] procData(CentralProcessor proc) {
        double[] p = proc.getProcessorCpuLoadBetweenTicks(this.oldProcTicks);
        this.oldProcTicks = proc.getProcessorCpuLoadTicks();
        return p;
    }
}

