/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.windows;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.BaseTSD;
import com.sun.jna.platform.win32.COM.WbemcliUtil;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.Psapi;
import com.sun.jna.platform.win32.Tlhelp32;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.VersionHelpers;
import com.sun.jna.platform.win32.W32ServiceManager;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.platform.win32.Winsvc;
import com.sun.jna.platform.win32.Wtsapi32;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.driver.windows.perfmon.ProcessInformation;
import oshi.driver.windows.registry.ProcessPerformanceData;
import oshi.driver.windows.wmi.Win32OperatingSystem;
import oshi.driver.windows.wmi.Win32Process;
import oshi.driver.windows.wmi.Win32Processor;
import oshi.jna.platform.windows.Kernel32;
import oshi.software.common.AbstractOperatingSystem;
import oshi.software.os.FileSystem;
import oshi.software.os.InternetProtocolStats;
import oshi.software.os.NetworkParams;
import oshi.software.os.OSProcess;
import oshi.software.os.OSService;
import oshi.software.os.OperatingSystem;
import oshi.software.os.windows.WindowsFileSystem;
import oshi.software.os.windows.WindowsInternetProtocolStats;
import oshi.software.os.windows.WindowsNetworkParams;
import oshi.software.os.windows.WindowsOSVersionInfoEx;
import oshi.util.GlobalConfig;
import oshi.util.Memoizer;
import oshi.util.ParseUtil;
import oshi.util.platform.windows.WmiUtil;
import oshi.util.tuples.Pair;

@ThreadSafe
public class WindowsOperatingSystem
extends AbstractOperatingSystem {
    private static final Logger LOG = LoggerFactory.getLogger(WindowsOperatingSystem.class);
    private static final boolean IS_VISTA_OR_GREATER = VersionHelpers.IsWindowsVistaOrGreater();
    private static final boolean IS_WINDOWS7_OR_GREATER = VersionHelpers.IsWindows7OrGreater();
    private static Supplier<String> systemLog = Memoizer.memoize(WindowsOperatingSystem::querySystemLog, TimeUnit.HOURS.toNanos(1L));
    private static final long BOOTTIME = WindowsOperatingSystem.querySystemBootTime();
    private Supplier<Map<Integer, OSProcess>> processMapFromRegistry = Memoizer.memoize(this::queryProcessMapFromRegistry, Memoizer.defaultExpiration());
    private Supplier<Map<Integer, OSProcess>> processMapFromPerfCounters = Memoizer.memoize(this::queryProcessMapFromPerfCounters, Memoizer.defaultExpiration());

    public WindowsOperatingSystem() {
        this.version = new WindowsOSVersionInfoEx();
    }

    @Override
    public String queryManufacturer() {
        return "Microsoft";
    }

    @Override
    public AbstractOperatingSystem.FamilyVersionInfo queryFamilyVersionInfo() {
        WbemcliUtil.WmiResult<Win32OperatingSystem.OSVersionProperty> versionInfo = Win32OperatingSystem.queryOsVersion();
        if (versionInfo.getResultCount() < 1) {
            return new AbstractOperatingSystem.FamilyVersionInfo("Windows", new OperatingSystem.OSVersionInfo(System.getProperty("os.version"), null, null));
        }
        int suiteMask = WmiUtil.getUint32(versionInfo, Win32OperatingSystem.OSVersionProperty.SUITEMASK, 0);
        String buildNumber = WmiUtil.getString(versionInfo, Win32OperatingSystem.OSVersionProperty.BUILDNUMBER, 0);
        String version = WindowsOperatingSystem.parseVersion(versionInfo, suiteMask, buildNumber);
        String codeName = WindowsOperatingSystem.parseCodeName(suiteMask);
        return new AbstractOperatingSystem.FamilyVersionInfo("Windows", new OperatingSystem.OSVersionInfo(version, codeName, buildNumber));
    }

    private static String parseVersion(WbemcliUtil.WmiResult<Win32OperatingSystem.OSVersionProperty> versionInfo, int suiteMask, String buildNumber) {
        String version = System.getProperty("os.version");
        String[] verSplit = WmiUtil.getString(versionInfo, Win32OperatingSystem.OSVersionProperty.VERSION, 0).split("\\D");
        int major = verSplit.length > 0 ? ParseUtil.parseIntOrDefault(verSplit[0], 0) : 0;
        int minor = verSplit.length > 1 ? ParseUtil.parseIntOrDefault(verSplit[1], 0) : 0;
        boolean ntWorkstation = WmiUtil.getUint32(versionInfo, Win32OperatingSystem.OSVersionProperty.PRODUCTTYPE, 0) == 1;
        switch (major) {
            case 10: {
                if (minor != 0) break;
                if (ntWorkstation) {
                    version = "10";
                    break;
                }
                version = ParseUtil.parseLongOrDefault(buildNumber, 0L) > 17762L ? "Server 2019" : "Server 2016";
                break;
            }
            case 6: {
                if (minor == 3) {
                    version = ntWorkstation ? "8.1" : "Server 2012 R2";
                    break;
                }
                if (minor == 2) {
                    version = ntWorkstation ? "8" : "Server 2012";
                    break;
                }
                if (minor == 1) {
                    version = ntWorkstation ? "7" : "Server 2008 R2";
                    break;
                }
                if (minor != 0) break;
                version = ntWorkstation ? "Vista" : "Server 2008";
                break;
            }
            case 5: {
                if (minor == 2) {
                    if ((suiteMask & 0x8000) != 0) {
                        version = "Home Server";
                        break;
                    }
                    if (ntWorkstation) {
                        version = "XP";
                        break;
                    }
                    version = User32.INSTANCE.GetSystemMetrics(89) != 0 ? "Server 2003" : "Server 2003 R2";
                    break;
                }
                if (minor == 1) {
                    version = "XP";
                    break;
                }
                if (minor != 0) break;
                version = "2000";
                break;
            }
        }
        String sp = WmiUtil.getString(versionInfo, Win32OperatingSystem.OSVersionProperty.CSDVERSION, 0);
        if (!sp.isEmpty() && !"unknown".equals(sp)) {
            version = version + " " + sp.replace("Service Pack ", "SP");
        }
        return version;
    }

    private static String parseCodeName(int suiteMask) {
        ArrayList<String> suites = new ArrayList<String>();
        if ((suiteMask & 2) != 0) {
            suites.add("Enterprise");
        }
        if ((suiteMask & 4) != 0) {
            suites.add("BackOffice");
        }
        if ((suiteMask & 8) != 0) {
            suites.add("Communication Server");
        }
        if ((suiteMask & 0x80) != 0) {
            suites.add("Datacenter");
        }
        if ((suiteMask & 0x200) != 0) {
            suites.add("Home");
        }
        if ((suiteMask & 0x400) != 0) {
            suites.add("Web Server");
        }
        if ((suiteMask & 0x2000) != 0) {
            suites.add("Storage Server");
        }
        if ((suiteMask & 0x4000) != 0) {
            suites.add("Compute Cluster");
        }
        return String.join((CharSequence)",", suites);
    }

    @Override
    protected int queryBitness(int jvmBitness) {
        WbemcliUtil.WmiResult<Win32Processor.BitnessProperty> bitnessMap;
        if (jvmBitness < 64 && System.getenv("ProgramFiles(x86)") != null && IS_VISTA_OR_GREATER && (bitnessMap = Win32Processor.queryBitness()).getResultCount() > 0) {
            return WmiUtil.getUint16(bitnessMap, Win32Processor.BitnessProperty.ADDRESSWIDTH, 0);
        }
        return jvmBitness;
    }

    @Override
    public boolean queryElevated() {
        try {
            File dir = new File(System.getenv("windir") + "\\system32\\config\\systemprofile");
            return dir.isDirectory();
        }
        catch (SecurityException e) {
            return false;
        }
    }

    @Override
    public FileSystem getFileSystem() {
        return new WindowsFileSystem();
    }

    @Override
    public InternetProtocolStats getInternetProtocolStats() {
        return new WindowsInternetProtocolStats();
    }

    @Override
    public OSProcess[] getProcesses(int limit, OperatingSystem.ProcessSort sort, boolean slowFields) {
        List<OSProcess> procList = this.processMapToList(null, slowFields);
        List<OSProcess> sorted = this.processSort(procList, limit, sort);
        return sorted.toArray(new OSProcess[0]);
    }

    @Override
    public List<OSProcess> getProcesses(Collection<Integer> pids) {
        return this.processMapToList(pids, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OSProcess[] getChildProcesses(int parentPid, int limit, OperatingSystem.ProcessSort sort) {
        HashSet<Integer> childPids = new HashSet<Integer>();
        Tlhelp32.PROCESSENTRY32.ByReference processEntry = new Tlhelp32.PROCESSENTRY32.ByReference();
        WinNT.HANDLE snapshot = Kernel32.INSTANCE.CreateToolhelp32Snapshot(Tlhelp32.TH32CS_SNAPPROCESS, new WinDef.DWORD(0L));
        try {
            while (Kernel32.INSTANCE.Process32Next(snapshot, (Tlhelp32.PROCESSENTRY32)processEntry)) {
                if (processEntry.th32ParentProcessID.intValue() != parentPid) continue;
                childPids.add(processEntry.th32ProcessID.intValue());
            }
        }
        finally {
            Kernel32.INSTANCE.CloseHandle(snapshot);
        }
        List<OSProcess> procList = this.getProcesses(childPids);
        List<OSProcess> sorted = this.processSort(procList, limit, sort);
        return sorted.toArray(new OSProcess[0]);
    }

    @Override
    public OSProcess getProcess(int pid, boolean slowFields) {
        List<OSProcess> procList = this.processMapToList(Arrays.asList(pid), slowFields);
        return procList.isEmpty() ? null : procList.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<OSProcess> processMapToList(Collection<Integer> pids, boolean slowFields) {
        Map<Integer, OSProcess> processMap = this.processMapFromRegistry.get();
        if (processMap == null) {
            processMap = pids == null ? this.processMapFromPerfCounters.get() : this.buildProcessMapFromPerfCounters(pids);
        }
        int myPid = this.getProcessId();
        Pointer pProcessInfo = null;
        Wtsapi32.WTS_PROCESS_INFO_EX[] processInfo = null;
        IntByReference pCount = new IntByReference(0);
        WbemcliUtil.WmiResult<Win32Process.ProcessXPProperty> processWmiResult = null;
        if (IS_WINDOWS7_OR_GREATER) {
            PointerByReference ppProcessInfo = new PointerByReference();
            if (!Wtsapi32.INSTANCE.WTSEnumerateProcessesEx(Wtsapi32.WTS_CURRENT_SERVER_HANDLE, new IntByReference(1), -2, ppProcessInfo, pCount)) {
                LOG.error("Failed to enumerate Processes. Error code: {}", (Object)Kernel32.INSTANCE.GetLastError());
                return new ArrayList<OSProcess>(0);
            }
            pProcessInfo = ppProcessInfo.getValue();
            Wtsapi32.WTS_PROCESS_INFO_EX processInfoRef = new Wtsapi32.WTS_PROCESS_INFO_EX(pProcessInfo);
            processInfo = (Wtsapi32.WTS_PROCESS_INFO_EX[])processInfoRef.toArray(pCount.getValue());
        } else {
            processWmiResult = Win32Process.queryProcesses(pids);
        }
        ArrayList<OSProcess> processList = new ArrayList<OSProcess>();
        int procCount = IS_WINDOWS7_OR_GREATER ? processInfo.length : processWmiResult.getResultCount();
        for (int i = 0; i < procCount; ++i) {
            OSProcess proc;
            int pid;
            int n = pid = IS_WINDOWS7_OR_GREATER ? processInfo[i].ProcessId : WmiUtil.getUint32(processWmiResult, Win32Process.ProcessXPProperty.PROCESSID, i);
            if (processMap.isEmpty()) {
                if (pids != null && !pids.contains(pid)) continue;
                proc = new OSProcess(this);
                proc.setProcessID(pid);
                proc.setName(IS_WINDOWS7_OR_GREATER ? processInfo[i].pProcessName : WmiUtil.getString(processWmiResult, Win32Process.ProcessXPProperty.NAME, i));
            } else {
                proc = processMap.get(pid);
                if (proc == null || pids != null && !pids.contains(pid)) continue;
            }
            if (pid == myPid) {
                String cwd = new File(".").getAbsolutePath();
                proc.setCurrentWorkingDirectory(cwd.isEmpty() ? "" : cwd.substring(0, cwd.length() - 1));
            }
            if (IS_WINDOWS7_OR_GREATER) {
                Wtsapi32.WTS_PROCESS_INFO_EX procInfo = processInfo[i];
                proc.setKernelTime(procInfo.KernelTime.getValue() / 10000L);
                proc.setUserTime(procInfo.UserTime.getValue() / 10000L);
                proc.setThreadCount(procInfo.NumberOfThreads);
                proc.setVirtualSize((long)procInfo.PagefileUsage & 0xFFFFFFFFL);
                proc.setOpenFiles(procInfo.HandleCount);
            } else {
                proc.setKernelTime(WmiUtil.getUint64(processWmiResult, Win32Process.ProcessXPProperty.KERNELMODETIME, i) / 10000L);
                proc.setUserTime(WmiUtil.getUint64(processWmiResult, Win32Process.ProcessXPProperty.USERMODETIME, i) / 10000L);
                proc.setThreadCount(WmiUtil.getUint32(processWmiResult, Win32Process.ProcessXPProperty.THREADCOUNT, i));
                proc.setVirtualSize(1024L * ((long)WmiUtil.getUint32(processWmiResult, Win32Process.ProcessXPProperty.PAGEFILEUSAGE, i) & 0xFFFFFFFFL));
                proc.setOpenFiles(WmiUtil.getUint32(processWmiResult, Win32Process.ProcessXPProperty.HANDLECOUNT, i));
            }
            WinNT.HANDLE pHandle = Kernel32.INSTANCE.OpenProcess(1024, false, proc.getProcessID());
            if (pHandle != null) {
                IntByReference wow64;
                proc.setBitness(this.getBitness());
                if (IS_VISTA_OR_GREATER && this.getBitness() == 64 && Kernel32.INSTANCE.IsWow64Process(pHandle, wow64 = new IntByReference(0))) {
                    proc.setBitness(wow64.getValue() > 0 ? 32 : 64);
                }
                WinNT.HANDLEByReference phToken = new WinNT.HANDLEByReference();
                try {
                    proc.setPath(IS_WINDOWS7_OR_GREATER ? Kernel32Util.QueryFullProcessImageName((WinNT.HANDLE)pHandle, (int)0) : WmiUtil.getString(processWmiResult, Win32Process.ProcessXPProperty.EXECUTABLEPATH, i));
                    if (Advapi32.INSTANCE.OpenProcessToken(pHandle, 10, phToken)) {
                        Advapi32Util.Account account = Advapi32Util.getTokenAccount((WinNT.HANDLE)phToken.getValue());
                        proc.setUser(account.name);
                        proc.setUserID(account.sidString);
                        if (slowFields) {
                            Advapi32Util.Account a = oshi.jna.platform.windows.Advapi32Util.getTokenPrimaryGroup(phToken.getValue());
                            proc.setGroup(a.name);
                            proc.setGroupID(a.sidString);
                        }
                    } else {
                        int error = Kernel32.INSTANCE.GetLastError();
                        if (error != 5) {
                            LOG.error("Failed to get process token for process {}: {}", (Object)proc.getProcessID(), (Object)Kernel32.INSTANCE.GetLastError());
                        }
                    }
                }
                catch (Win32Exception e) {
                    this.handleWin32ExceptionOnGetProcessInfo(proc, e);
                }
                finally {
                    WinNT.HANDLE token = phToken.getValue();
                    if (token != null) {
                        Kernel32.INSTANCE.CloseHandle(token);
                    }
                }
                Kernel32.INSTANCE.CloseHandle(pHandle);
            }
            proc.setState(OSProcess.State.RUNNING);
            proc.setCommandLine("");
            processList.add(proc);
        }
        if (pProcessInfo != null && !Wtsapi32.INSTANCE.WTSFreeMemoryEx(1, pProcessInfo, pCount.getValue())) {
            LOG.error("Failed to Free Memory for Processes. Error code: {}", (Object)Kernel32.INSTANCE.GetLastError());
            return new ArrayList<OSProcess>(0);
        }
        if (slowFields) {
            HashSet<Integer> pidsToQuery = new HashSet<Integer>();
            if (pids != null) {
                for (OSProcess process : processList) {
                    pidsToQuery.add(process.getProcessID());
                }
            }
            WbemcliUtil.WmiResult<Win32Process.CommandLineProperty> commandLineProcs = Win32Process.queryCommandLines(pidsToQuery);
            for (int p = 0; p < commandLineProcs.getResultCount(); ++p) {
                int pid = WmiUtil.getUint32(commandLineProcs, Win32Process.CommandLineProperty.PROCESSID, p);
                if (!processMap.containsKey(pid)) continue;
                OSProcess proc = processMap.get(pid);
                proc.setCommandLine(WmiUtil.getString(commandLineProcs, Win32Process.CommandLineProperty.COMMANDLINE, p));
            }
        }
        return processList;
    }

    protected void handleWin32ExceptionOnGetProcessInfo(OSProcess proc, Win32Exception ex) {
        LOG.warn("Failed to set path or get user/group on PID {}. It may have terminated. {}", (Object)proc.getProcessID(), (Object)ex.getMessage());
    }

    private Map<Integer, OSProcess> queryProcessMapFromRegistry() {
        return ProcessPerformanceData.buildProcessMapFromRegistry(this, null);
    }

    private Map<Integer, OSProcess> queryProcessMapFromPerfCounters() {
        return this.buildProcessMapFromPerfCounters(null);
    }

    private Map<Integer, OSProcess> buildProcessMapFromPerfCounters(Collection<Integer> pids) {
        HashMap<Integer, OSProcess> processMap = new HashMap<Integer, OSProcess>();
        Pair<List<String>, Map<ProcessInformation.ProcessPerformanceProperty, List<Long>>> instanceValues = ProcessInformation.queryProcessCounters();
        long now = System.currentTimeMillis();
        List<String> instances = instanceValues.getA();
        Map<ProcessInformation.ProcessPerformanceProperty, List<Long>> valueMap = instanceValues.getB();
        List<Long> pidList = valueMap.get(ProcessInformation.ProcessPerformanceProperty.PROCESSID);
        List<Long> ppidList = valueMap.get(ProcessInformation.ProcessPerformanceProperty.PARENTPROCESSID);
        List<Long> priorityList = valueMap.get(ProcessInformation.ProcessPerformanceProperty.PRIORITY);
        List<Long> ioReadList = valueMap.get(ProcessInformation.ProcessPerformanceProperty.READTRANSFERCOUNT);
        List<Long> ioWriteList = valueMap.get(ProcessInformation.ProcessPerformanceProperty.WRITETRANSFERCOUNT);
        List<Long> workingSetSizeList = valueMap.get(ProcessInformation.ProcessPerformanceProperty.PRIVATEPAGECOUNT);
        List<Long> creationTimeList = valueMap.get(ProcessInformation.ProcessPerformanceProperty.CREATIONDATE);
        for (int inst = 0; inst < instances.size(); ++inst) {
            int pid = pidList.get(inst).intValue();
            if (pids != null && !pids.contains(pid)) continue;
            OSProcess proc = new OSProcess(this);
            processMap.put(pid, proc);
            proc.setProcessID(pid);
            proc.setName(instances.get(inst));
            proc.setParentProcessID(ppidList.get(inst).intValue());
            proc.setPriority(priorityList.get(inst).intValue());
            long ctime = creationTimeList.get(inst);
            if (ctime > now) {
                ctime = WinBase.FILETIME.filetimeToDate((int)((int)(ctime >> 32)), (int)((int)(ctime & 0xFFFFFFFFL))).getTime();
            }
            proc.setUpTime(now - ctime);
            proc.setStartTime(ctime);
            proc.setBytesRead(ioReadList.get(inst));
            proc.setBytesWritten(ioWriteList.get(inst));
            proc.setResidentSetSize(workingSetSizeList.get(inst));
        }
        return processMap;
    }

    @Override
    public long getProcessAffinityMask(int processId) {
        BaseTSD.ULONG_PTRByReference systemAffinity;
        BaseTSD.ULONG_PTRByReference processAffinity;
        WinNT.HANDLE pHandle = Kernel32.INSTANCE.OpenProcess(1024, false, processId);
        if (pHandle != null && Kernel32.INSTANCE.GetProcessAffinityMask(pHandle, processAffinity = new BaseTSD.ULONG_PTRByReference(), systemAffinity = new BaseTSD.ULONG_PTRByReference())) {
            return Pointer.nativeValue((Pointer)processAffinity.getValue().toPointer());
        }
        return 0L;
    }

    @Override
    public int getProcessId() {
        return Kernel32.INSTANCE.GetCurrentProcessId();
    }

    @Override
    public int getProcessCount() {
        Psapi.PERFORMANCE_INFORMATION perfInfo = new Psapi.PERFORMANCE_INFORMATION();
        if (!Psapi.INSTANCE.GetPerformanceInfo(perfInfo, perfInfo.size())) {
            LOG.error("Failed to get Performance Info. Error code: {}", (Object)Kernel32.INSTANCE.GetLastError());
            return 0;
        }
        return perfInfo.ProcessCount.intValue();
    }

    @Override
    public int getThreadCount() {
        Psapi.PERFORMANCE_INFORMATION perfInfo = new Psapi.PERFORMANCE_INFORMATION();
        if (!Psapi.INSTANCE.GetPerformanceInfo(perfInfo, perfInfo.size())) {
            LOG.error("Failed to get Performance Info. Error code: {}", (Object)Kernel32.INSTANCE.GetLastError());
            return 0;
        }
        return perfInfo.ThreadCount.intValue();
    }

    @Override
    public long getSystemUptime() {
        return WindowsOperatingSystem.querySystemUptime();
    }

    private static long querySystemUptime() {
        if (IS_VISTA_OR_GREATER) {
            return Kernel32.INSTANCE.GetTickCount64() / 1000L;
        }
        return (long)Kernel32.INSTANCE.GetTickCount() / 1000L;
    }

    @Override
    public long getSystemBootTime() {
        return BOOTTIME;
    }

    private static long querySystemBootTime() {
        String eventLog = systemLog.get();
        if (eventLog != null) {
            try {
                Advapi32Util.EventLogIterator iter = new Advapi32Util.EventLogIterator(null, eventLog, 8);
                long event6005Time = 0L;
                while (iter.hasNext()) {
                    Advapi32Util.EventLogRecord record = iter.next();
                    if (record.getStatusCode() == 12) {
                        return record.getRecord().TimeGenerated.longValue();
                    }
                    if (record.getStatusCode() != 6005) continue;
                    if (event6005Time > 0L) {
                        return event6005Time;
                    }
                    event6005Time = record.getRecord().TimeGenerated.longValue();
                }
                if (event6005Time > 0L) {
                    return event6005Time;
                }
            }
            catch (Win32Exception e) {
                LOG.warn("Can't open event log \"{}\".", (Object)eventLog);
            }
        }
        return System.currentTimeMillis() / 1000L - WindowsOperatingSystem.querySystemUptime();
    }

    @Override
    public NetworkParams getNetworkParams() {
        return new WindowsNetworkParams();
    }

    private static void enableDebugPrivilege() {
        WinNT.HANDLEByReference hToken = new WinNT.HANDLEByReference();
        boolean success = Advapi32.INSTANCE.OpenProcessToken(Kernel32.INSTANCE.GetCurrentProcess(), 40, hToken);
        if (!success) {
            LOG.error("OpenProcessToken failed. Error: {}", (Object)Native.getLastError());
            return;
        }
        WinNT.LUID luid = new WinNT.LUID();
        success = Advapi32.INSTANCE.LookupPrivilegeValue(null, "SeDebugPrivilege", luid);
        if (!success) {
            LOG.error("LookupprivilegeValue failed. Error: {}", (Object)Native.getLastError());
            Kernel32.INSTANCE.CloseHandle(hToken.getValue());
            return;
        }
        WinNT.TOKEN_PRIVILEGES tkp = new WinNT.TOKEN_PRIVILEGES(1);
        tkp.Privileges[0] = new WinNT.LUID_AND_ATTRIBUTES(luid, new WinDef.DWORD(2L));
        success = Advapi32.INSTANCE.AdjustTokenPrivileges(hToken.getValue(), false, tkp, 0, null, null);
        if (!success) {
            LOG.error("AdjustTokenPrivileges failed. Error: {}", (Object)Native.getLastError());
        }
        Kernel32.INSTANCE.CloseHandle(hToken.getValue());
    }

    @Override
    public OSService[] getServices() {
        OSService[] oSServiceArray;
        W32ServiceManager sm = new W32ServiceManager();
        try {
            sm.open(4);
            Winsvc.ENUM_SERVICE_STATUS_PROCESS[] services = sm.enumServicesStatusExProcess(48, 3, null);
            OSService[] svcArray = new OSService[services.length];
            for (int i = 0; i < services.length; ++i) {
                OSService.State state;
                switch (services[i].ServiceStatusProcess.dwCurrentState) {
                    case 1: {
                        state = OSService.State.STOPPED;
                        break;
                    }
                    case 4: {
                        state = OSService.State.RUNNING;
                        break;
                    }
                    default: {
                        state = OSService.State.OTHER;
                    }
                }
                svcArray[i] = new OSService(services[i].lpDisplayName, services[i].ServiceStatusProcess.dwProcessId, state);
            }
            oSServiceArray = svcArray;
        }
        catch (Throwable throwable) {
            try {
                try {
                    sm.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Win32Exception ex) {
                LOG.error("Win32Exception: {}", (Object)ex.getMessage());
                return new OSService[0];
            }
        }
        sm.close();
        return oSServiceArray;
    }

    private static String querySystemLog() {
        String systemLog = GlobalConfig.get("oshi.os.windows.eventlog", "System");
        if (systemLog.isEmpty()) {
            return null;
        }
        WinNT.HANDLE h = Advapi32.INSTANCE.OpenEventLog(null, systemLog);
        if (h == null) {
            LOG.warn("Unable to open configured system Event log \"{}\". Calculating boot time from uptime.", (Object)systemLog);
            return null;
        }
        return systemLog;
    }

    static {
        WindowsOperatingSystem.enableDebugPrivilege();
    }
}

