/*
 * Decompiled with CFR 0.152.
 */
package oshi.demo;

import java.awt.BorderLayout;
import java.awt.Container;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.SwingUtilities;
import oshi.SystemInfo;
import oshi.demo.gui.FileStorePanel;
import oshi.demo.gui.MemoryPanel;
import oshi.demo.gui.OsHwTextPanel;
import oshi.demo.gui.OshiJPanel;
import oshi.demo.gui.ProcessPanel;
import oshi.demo.gui.ProcessorPanel;
import oshi.demo.gui.UsbPanel;

public class OshiGui {
    private JFrame mainFrame;
    private JButton jMenu;
    private JMenuBar menuBar;
    private SystemInfo si = new SystemInfo();

    public static void main(String[] args) {
        OshiGui gui = new OshiGui();
        gui.init();
        SwingUtilities.invokeLater(gui::setVisible);
    }

    private void setVisible() {
        this.mainFrame.setVisible(true);
        this.jMenu.doClick();
    }

    private void init() {
        this.mainFrame = new JFrame("Operating System & Hardware Information");
        this.mainFrame.setSize(800, 500);
        this.mainFrame.setDefaultCloseOperation(3);
        this.mainFrame.setResizable(true);
        this.mainFrame.setLocationByPlatform(true);
        this.mainFrame.setLayout(new BorderLayout());
        this.menuBar = new JMenuBar();
        this.mainFrame.setJMenuBar(this.menuBar);
        this.jMenu = this.getJMenu("OS & HW Info", 'O', "Hardware & OS Summary", new OsHwTextPanel(this.si));
        this.menuBar.add(this.jMenu);
        new Thread(new AddMenuBarTask("Memory", 'M', "Memory Summary", new MemoryPanel(this.si))).start();
        new Thread(new AddMenuBarTask("CPU", 'C', "CPU Usage", new ProcessorPanel(this.si))).start();
        new Thread(new AddMenuBarTask("FileStores", 'F', "FileStore Usage", new FileStorePanel(this.si))).start();
        new Thread(new AddMenuBarTask("Processes", 'P', "Processes", new ProcessPanel(this.si))).start();
        new Thread(new AddMenuBarTask("USB Devices", 'U', "USB Device list", new UsbPanel(this.si))).start();
    }

    private JButton getJMenu(String title, char mnemonic, String toolTip, OshiJPanel panel) {
        JButton button = new JButton(title);
        button.setMnemonic(mnemonic);
        button.setToolTipText(toolTip);
        button.addActionListener(e -> {
            Container contentPane = this.mainFrame.getContentPane();
            if (contentPane.getComponents().length <= 0 || contentPane.getComponent(0) != panel) {
                this.resetMainGui();
                this.mainFrame.getContentPane().add(panel);
                this.refreshMainGui();
            }
        });
        return button;
    }

    private void resetMainGui() {
        this.mainFrame.getContentPane().removeAll();
    }

    private void refreshMainGui() {
        this.mainFrame.revalidate();
        this.mainFrame.repaint();
    }

    private final class AddMenuBarTask
    implements Runnable {
        private String title;
        private char mnemonic;
        private String toolTip;
        private OshiJPanel panel;

        private AddMenuBarTask(String title, char mnemonic, String toolTip, OshiJPanel panel) {
            this.title = title;
            this.mnemonic = mnemonic;
            this.toolTip = toolTip;
            this.panel = panel;
        }

        @Override
        public void run() {
            OshiGui.this.menuBar.add(OshiGui.this.getJMenu(this.title, this.mnemonic, this.toolTip, this.panel));
        }
    }
}

