/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.mac;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.platform.mac.SystemB;
import com.sun.jna.ptr.IntByReference;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.NetworkIF;
import oshi.hardware.common.AbstractNetworks;
import oshi.util.Memoizer;

public class MacNetworks
extends AbstractNetworks {
    private static final Logger LOG = LoggerFactory.getLogger(MacNetworks.class);
    private static final int CTL_NET = 4;
    private static final int PF_ROUTE = 17;
    private static final int NET_RT_IFLIST2 = 6;
    private static final int RTM_IFINFO2 = 18;
    private static final Supplier<Map<Integer, IFdata>> ifDataMap = Memoizer.memoize(MacNetworks::queryIFdata, Memoizer.defaultExpiration());

    private static Map<Integer, IFdata> queryIFdata() {
        SystemB.IFmsgHdr ifm;
        HashMap<Integer, IFdata> data = new HashMap<Integer, IFdata>();
        int[] mib = new int[]{4, 17, 0, 0, 6, 0};
        IntByReference len = new IntByReference();
        if (0 != SystemB.INSTANCE.sysctl(mib, 6, null, len, null, 0)) {
            LOG.error("Didn't get buffer length for IFLIST2");
            return null;
        }
        Memory buf = new Memory((long)len.getValue());
        if (0 != SystemB.INSTANCE.sysctl(mib, 6, (Pointer)buf, len, null, 0)) {
            LOG.error("Didn't get buffer for IFLIST2");
            return null;
        }
        int lim = len.getValue();
        for (int next = 0; next < lim; next += ifm.ifm_msglen) {
            Pointer p = new Pointer(Pointer.nativeValue((Pointer)buf) + (long)next);
            ifm = new SystemB.IFmsgHdr(p);
            ifm.read();
            if (ifm.ifm_type != 18) continue;
            SystemB.IFmsgHdr2 if2m = new SystemB.IFmsgHdr2(p);
            if2m.read();
            data.put(Integer.valueOf(if2m.ifm_index), new IFdata(if2m.ifm_data.ifi_opackets, if2m.ifm_data.ifi_ipackets, if2m.ifm_data.ifi_obytes, if2m.ifm_data.ifi_ibytes, if2m.ifm_data.ifi_oerrors, if2m.ifm_data.ifi_ierrors, if2m.ifm_data.ifi_collisions, if2m.ifm_data.ifi_iqdrops, if2m.ifm_data.ifi_baudrate, System.currentTimeMillis()));
        }
        return data;
    }

    public static boolean updateNetworkStats(NetworkIF netIF) {
        Map<Integer, IFdata> data = ifDataMap.get();
        IFdata ifData = data.getOrDefault(netIF.queryNetworkInterface().getIndex(), null);
        if (ifData != null) {
            netIF.setBytesSent(ifData.oBytes);
            netIF.setBytesRecv(ifData.iBytes);
            netIF.setPacketsSent(ifData.oPackets);
            netIF.setPacketsRecv(ifData.iPackets);
            netIF.setOutErrors(ifData.oErrors);
            netIF.setInErrors(ifData.iErrors);
            netIF.setCollisions(ifData.collisions);
            netIF.setInDrops(ifData.iDrops);
            netIF.setSpeed(ifData.speed);
            netIF.setTimeStamp(ifData.timeStamp);
            return true;
        }
        return false;
    }

    private static class IFdata {
        private long oPackets;
        private long iPackets;
        private long oBytes;
        private long iBytes;
        private long oErrors;
        private long iErrors;
        private long collisions;
        private long iDrops;
        private long speed;
        private long timeStamp;

        IFdata(long oPackets, long iPackets, long oBytes, long iBytes, long oErrors, long iErrors, long collisions, long iDrops, long speed, long timeStamp) {
            this.oPackets = oPackets;
            this.iPackets = iPackets;
            this.oBytes = oBytes;
            this.iBytes = iBytes;
            this.oErrors = oErrors;
            this.iErrors = iErrors;
            this.collisions = collisions;
            this.iDrops = iDrops;
            this.speed = speed;
            this.timeStamp = timeStamp;
        }
    }
}

