/*
 * Decompiled with CFR 0.152.
 */
package oshi.demo;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import oshi.SystemInfo;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.NetworkIF;

public class DetectVM {
    private static final Map<String, String> vmMacAddressOUI = new HashMap<String, String>();
    private static final String[] vmModelArray;

    public static void main(String[] args) {
        String vmString = DetectVM.identifyVM();
        if (vmString.isEmpty()) {
            System.out.println("You do not appear to be on a Virtual Machine.");
        } else {
            System.out.println("You appear to be on a VM: " + vmString);
        }
    }

    public static String identifyVM() {
        NetworkIF[] nifs;
        SystemInfo si = new SystemInfo();
        HardwareAbstractionLayer hw = si.getHardware();
        for (NetworkIF nif : nifs = hw.getNetworkIFs()) {
            String mac = nif.getMacaddr().toUpperCase();
            String oui = DetectVM.findOuiByMacAddressIfPossible(mac);
            if (oui == null || oui.isEmpty()) continue;
            return oui;
        }
        String model = hw.getComputerSystem().getModel();
        for (String vm : vmModelArray) {
            if (!model.contains(vm)) continue;
            return vm;
        }
        String manufacturer = hw.getComputerSystem().getManufacturer();
        if ("Microsoft Corporation".equals(manufacturer) && "Virtual Machine".equals(model)) {
            return "Microsoft Hyper-V";
        }
        return "";
    }

    public static String findOuiByMacAddressIfPossible(String mac) {
        return vmMacAddressOUI.entrySet().stream().filter(entry -> mac.startsWith((String)entry.getKey())).map(Map.Entry::getValue).collect(Collectors.joining());
    }

    static {
        vmMacAddressOUI.put("00:50:56", "VMware ESX 3");
        vmMacAddressOUI.put("00:0C:29", "VMware ESX 3");
        vmMacAddressOUI.put("00:05:69", "VMware ESX 3");
        vmMacAddressOUI.put("00:03:FF", "Microsoft Hyper-V");
        vmMacAddressOUI.put("00:1C:42", "Parallels Desktop");
        vmMacAddressOUI.put("00:0F:4B", "Virtual Iron 4");
        vmMacAddressOUI.put("00:16:3E", "Xen or Oracle VM");
        vmMacAddressOUI.put("08:00:27", "VirtualBox");
        vmMacAddressOUI.put("02:42:AC", "Docker Container");
        vmModelArray = new String[]{"Linux KVM", "Linux lguest", "OpenVZ", "Qemu", "Microsoft Virtual PC", "VMWare", "linux-vserver", "Xen", "FreeBSD Jail", "VirtualBox", "Parallels", "Linux Containers", "LXC"};
    }
}

