/*
 * Decompiled with CFR 0.152.
 */
package oshi.demo;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.SystemInfo;

public class OshiHTTPServer
implements Runnable {
    private static final int PORT = 8080;
    private static final Logger logger = LoggerFactory.getLogger(OshiHTTPServer.class);
    private Socket connect;

    public OshiHTTPServer(Socket c) {
        this.connect = c;
        logger.debug("Connecton opened.");
    }

    public static void main(String[] args) {
        try {
            ServerSocket serverConnect = new ServerSocket(8080);
            Throwable throwable = null;
            try {
                try {
                    logger.info("Server started. Listening for connections on port {}", (Object)8080);
                    while (true) {
                        OshiHTTPServer myServer = new OshiHTTPServer(serverConnect.accept());
                        Thread thread = new Thread(myServer);
                        thread.start();
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (serverConnect != null) {
                    if (throwable != null) {
                        try {
                            serverConnect.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        serverConnect.close();
                    }
                }
                throw throwable3;
            }
        }
        catch (IOException e) {
            logger.error("Server Connection error: {}", (Object)e.getMessage());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try (BufferedReader in = new BufferedReader(new InputStreamReader(this.connect.getInputStream()));
             PrintWriter out = new PrintWriter(this.connect.getOutputStream());
             BufferedOutputStream dataOut = new BufferedOutputStream(this.connect.getOutputStream());){
            String input = in.readLine();
            if (input == null) {
                throw new IOException("No characters read from input stream.");
            }
            StringTokenizer parse = new StringTokenizer(input);
            String method = parse.nextToken().toUpperCase();
            String fileRequested = parse.nextToken().toLowerCase();
            if (!method.equals("GET") && !method.equals("HEAD")) {
                logger.debug("501 Not Implemented: {}", (Object)method);
                String contentMimeType = "text/html";
                out.println("HTTP/1.1 501 Not Implemented");
                out.println("Server: OSHI HTTP Server");
                out.println("Date: " + Instant.now());
                out.println("Content-type: " + contentMimeType);
                out.println("Content-length: 0");
                out.println();
                out.flush();
            } else {
                SystemInfo si = new SystemInfo();
                ObjectMapper mapper = new ObjectMapper();
                byte[] content = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)si).getBytes(StandardCharsets.UTF_8);
                if (method.equals("GET")) {
                    out.println("HTTP/1.1 200 OK");
                    out.println("Server: OSHI HTTP Server");
                    out.println("Date: " + Instant.now());
                    out.println("Content-type: application/json");
                    out.println("Content-length: " + content.length);
                    out.println();
                    out.flush();
                    dataOut.write(content, 0, content.length);
                    dataOut.flush();
                }
                logger.debug("Data {} returned", (Object)fileRequested);
            }
        }
        catch (IOException ioe) {
            logger.error("Server error: {}", (Throwable)ioe);
        }
        finally {
            try {
                this.connect.close();
            }
            catch (Exception e) {
                logger.error("Error closing connection: {}", (Object)e.getMessage());
            }
            logger.debug("Connection closed.");
        }
    }
}

