/*
 * Decompiled with CFR 0.152.
 */
package oshi.util.platform.mac;

import com.sun.jna.platform.mac.SystemB;
import com.sun.jna.ptr.IntByReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.jna.platform.mac.IOKit;
import oshi.util.ParseUtil;
import oshi.util.Util;
import oshi.util.platform.mac.IOKitUtil;

public class SmcUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SmcUtil.class);
    private static IOKit.IOConnect conn = new IOKit.IOConnect();
    private static Map<Integer, IOKit.SMCKeyDataKeyInfo> keyInfoCache = new ConcurrentHashMap<Integer, IOKit.SMCKeyDataKeyInfo>();
    private static final byte[] DATATYPE_SP78 = ParseUtil.stringToByteArray("sp78", 5);
    private static final byte[] DATATYPE_FPE2 = ParseUtil.stringToByteArray("fpe2", 5);
    private static final byte[] DATATYPE_FLT = ParseUtil.stringToByteArray("flt ", 5);

    private SmcUtil() {
    }

    public static int smcOpen() {
        int service = IOKitUtil.getMatchingService("AppleSMC");
        if (service == 0) {
            LOG.error("Error: no SMC found");
            return 1;
        }
        int result = IOKit.INSTANCE.IOServiceOpen(service, SystemB.INSTANCE.mach_task_self(), 0, conn);
        IOKit.INSTANCE.IOObjectRelease(service);
        if (result != 0) {
            if (LOG.isErrorEnabled()) {
                LOG.error(String.format("Error: IOServiceOpen() = 0x%08x", result));
            }
            return result;
        }
        Util.sleep(5L);
        return 0;
    }

    public static int smcClose() {
        return IOKit.INSTANCE.IOServiceClose(conn.getValue());
    }

    public static double smcGetFloat(String key, int retries) {
        IOKit.SMCVal val = new IOKit.SMCVal();
        int result = SmcUtil.smcReadKey(key, val, retries);
        if (result == 0 && val.dataSize > 0) {
            if (Arrays.equals(val.dataType, DATATYPE_SP78) && val.dataSize == 2) {
                return (double)val.bytes[0] + (double)val.bytes[1] / 256.0;
            }
            if (Arrays.equals(val.dataType, DATATYPE_FPE2) && val.dataSize == 2) {
                return ParseUtil.byteArrayToFloat(val.bytes, val.dataSize, 2);
            }
            if (Arrays.equals(val.dataType, DATATYPE_FLT) && val.dataSize == 4) {
                return ByteBuffer.wrap(val.bytes).order(ByteOrder.LITTLE_ENDIAN).getFloat();
            }
        }
        return 0.0;
    }

    public static long smcGetLong(String key, int retries) {
        IOKit.SMCVal val = new IOKit.SMCVal();
        int result = SmcUtil.smcReadKey(key, val, retries);
        if (result == 0) {
            return ParseUtil.byteArrayToLong(val.bytes, val.dataSize);
        }
        return 0L;
    }

    public static int smcGetKeyInfo(IOKit.SMCKeyData inputStructure, IOKit.SMCKeyData outputStructure) {
        if (keyInfoCache.containsKey(inputStructure.key)) {
            IOKit.SMCKeyDataKeyInfo keyInfo = keyInfoCache.get(inputStructure.key);
            outputStructure.keyInfo.dataSize = keyInfo.dataSize;
            outputStructure.keyInfo.dataType = keyInfo.dataType;
            outputStructure.keyInfo.dataAttributes = keyInfo.dataAttributes;
        } else {
            inputStructure.data8 = (byte)9;
            Util.sleep(4L);
            int result = SmcUtil.smcCall(2, inputStructure, outputStructure);
            if (result != 0) {
                return result;
            }
            IOKit.SMCKeyDataKeyInfo keyInfo = new IOKit.SMCKeyDataKeyInfo();
            keyInfo.dataSize = outputStructure.keyInfo.dataSize;
            keyInfo.dataType = outputStructure.keyInfo.dataType;
            keyInfo.dataAttributes = outputStructure.keyInfo.dataAttributes;
            keyInfoCache.put(inputStructure.key, keyInfo);
        }
        return 0;
    }

    public static int smcReadKey(String key, IOKit.SMCVal val, int retries) {
        int result;
        IOKit.SMCKeyData inputStructure = new IOKit.SMCKeyData();
        IOKit.SMCKeyData outputStructure = new IOKit.SMCKeyData();
        inputStructure.key = (int)ParseUtil.strToLong(key, 4);
        int retry = 0;
        do {
            if ((result = SmcUtil.smcGetKeyInfo(inputStructure, outputStructure)) != 0) continue;
            val.dataSize = outputStructure.keyInfo.dataSize;
            val.dataType = ParseUtil.longToByteArray(outputStructure.keyInfo.dataType, 4, 5);
            inputStructure.keyInfo.dataSize = val.dataSize;
            inputStructure.data8 = (byte)5;
            Util.sleep(4L);
            result = SmcUtil.smcCall(2, inputStructure, outputStructure);
            if (result == 0) break;
        } while (++retry < retries);
        if (result != 0) {
            return result;
        }
        System.arraycopy(outputStructure.bytes, 0, val.bytes, 0, val.bytes.length);
        return 0;
    }

    public static int smcCall(int index, IOKit.SMCKeyData inputStructure, IOKit.SMCKeyData outputStructure) {
        return IOKit.INSTANCE.IOConnectCallStructMethod(conn.getValue(), index, inputStructure, inputStructure.size(), outputStructure, new IntByReference(outputStructure.size()));
    }
}

