/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.mac;

import com.sun.jna.Pointer;
import com.sun.jna.platform.mac.SystemB;
import com.sun.jna.ptr.IntByReference;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.jna.platform.mac.CoreFoundation;
import oshi.jna.platform.mac.DiskArbitration;
import oshi.jna.platform.mac.IOKit;
import oshi.software.os.FileSystem;
import oshi.software.os.OSFileStore;
import oshi.util.platform.mac.CfUtil;
import oshi.util.platform.mac.IOKitUtil;
import oshi.util.platform.mac.SysctlUtil;

public class MacFileSystem
implements FileSystem {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(MacFileSystem.class);
    private static final Pattern LOCAL_DISK = Pattern.compile("/dev/disk\\d");

    @Override
    public OSFileStore[] getFileStores() {
        List<OSFileStore> fsList = this.getFileStoreMatching(null);
        return fsList.toArray(new OSFileStore[0]);
    }

    private List<OSFileStore> getFileStoreMatching(String nameToMatch) {
        ArrayList<OSFileStore> fsList = new ArrayList<OSFileStore>();
        int numfs = SystemB.INSTANCE.getfsstat64(null, 0, 0);
        if (numfs > 0) {
            DiskArbitration.DASessionRef session = DiskArbitration.INSTANCE.DASessionCreate(CfUtil.ALLOCATOR);
            if (session == null) {
                LOG.error("Unable to open session to DiskArbitration framework.");
            }
            CoreFoundation.CFStringRef daVolumeNameKey = CoreFoundation.CFStringRef.toCFString("DAVolumeName");
            SystemB.Statfs[] fs = new SystemB.Statfs[numfs];
            numfs = SystemB.INSTANCE.getfsstat64(fs, numfs * new SystemB.Statfs().size(), 16);
            for (int f = 0; f < numfs; ++f) {
                String volume = new String(fs[f].f_mntfromname).trim();
                if (volume.equals("devfs") || volume.startsWith("map ")) continue;
                String description = "Volume";
                if (LOCAL_DISK.matcher(volume).matches()) {
                    description = "Local Disk";
                }
                if (volume.startsWith("localhost:") || volume.startsWith("//")) {
                    description = "Network Drive";
                }
                String type = new String(fs[f].f_fstypename).trim();
                String path = new String(fs[f].f_mntonname).trim();
                String name = "";
                File file = new File(path);
                if (name.isEmpty() && (name = file.getName()).isEmpty()) {
                    name = file.getPath();
                }
                if (nameToMatch != null && !nameToMatch.equals(name)) continue;
                String uuid = "";
                String bsdName = volume.replace("/dev/disk", "disk");
                if (bsdName.startsWith("disk")) {
                    CoreFoundation.CFMutableDictionaryRef matchingDict;
                    DiskArbitration.DADiskRef disk = DiskArbitration.INSTANCE.DADiskCreateFromBSDName(CfUtil.ALLOCATOR, session, volume);
                    if (disk != null) {
                        CoreFoundation.CFDictionaryRef diskInfo = DiskArbitration.INSTANCE.DADiskCopyDescription(disk);
                        if (diskInfo != null) {
                            Pointer volumePtr = CoreFoundation.INSTANCE.CFDictionaryGetValue(diskInfo, daVolumeNameKey);
                            name = CfUtil.cfPointerToString(volumePtr);
                            CfUtil.release(diskInfo);
                        }
                        CfUtil.release(disk);
                    }
                    if ((matchingDict = IOKitUtil.getBSDNameMatchingDict(bsdName)) != null) {
                        IntByReference fsIter = new IntByReference();
                        IOKitUtil.getMatchingServices(matchingDict, fsIter);
                        int fsEntry = IOKit.INSTANCE.IOIteratorNext(fsIter.getValue());
                        if (fsEntry != 0 && IOKit.INSTANCE.IOObjectConformsTo(fsEntry, "IOMedia")) {
                            uuid = IOKitUtil.getIORegistryStringProperty(fsEntry, "UUID");
                            uuid = uuid == null ? "" : uuid.toLowerCase();
                            IOKit.INSTANCE.IOObjectRelease(fsEntry);
                        }
                        IOKit.INSTANCE.IOObjectRelease(fsIter.getValue());
                    }
                }
                OSFileStore osStore = new OSFileStore();
                osStore.setName(name);
                osStore.setVolume(volume);
                osStore.setMount(path);
                osStore.setDescription(description);
                osStore.setType(type);
                osStore.setUUID(uuid);
                osStore.setFreeSpace(file.getFreeSpace());
                osStore.setUsableSpace(file.getUsableSpace());
                osStore.setTotalSpace(file.getTotalSpace());
                osStore.setFreeInodes(fs[f].f_ffree);
                osStore.setTotalInodes(fs[f].f_files);
                fsList.add(osStore);
            }
            CfUtil.release(session);
            CfUtil.release(daVolumeNameKey);
        }
        return fsList;
    }

    @Override
    public long getOpenFileDescriptors() {
        return SysctlUtil.sysctl("kern.num_files", 0);
    }

    @Override
    public long getMaxFileDescriptors() {
        return SysctlUtil.sysctl("kern.maxfiles", 0);
    }

    public static boolean updateFileStoreStats(OSFileStore osFileStore) {
        for (OSFileStore fileStore : new MacFileSystem().getFileStoreMatching(osFileStore.getName())) {
            if (!osFileStore.getVolume().equals(fileStore.getVolume()) || !osFileStore.getMount().equals(fileStore.getMount())) continue;
            osFileStore.setLogicalVolume(fileStore.getLogicalVolume());
            osFileStore.setDescription(fileStore.getDescription());
            osFileStore.setType(fileStore.getType());
            osFileStore.setFreeSpace(fileStore.getFreeSpace());
            osFileStore.setUsableSpace(fileStore.getUsableSpace());
            osFileStore.setTotalSpace(fileStore.getTotalSpace());
            osFileStore.setFreeInodes(fileStore.getFreeInodes());
            osFileStore.setTotalInodes(fileStore.getTotalInodes());
            return true;
        }
        return false;
    }
}

