/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.freebsd;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import oshi.hardware.common.AbstractSensors;
import oshi.jna.platform.unix.freebsd.Libc;

public class FreeBsdSensors
extends AbstractSensors {
    private static final long serialVersionUID = 1L;

    @Override
    public double getCpuTemperature() {
        return this.queryKldloadCoretemp();
    }

    private double queryKldloadCoretemp() {
        String name = "dev.cpu.%d.temperature";
        IntByReference size = new IntByReference(Libc.INT_SIZE);
        Memory p = new Memory((long)size.getValue());
        int cpu = 0;
        double sumTemp = 0.0;
        while (0 == Libc.INSTANCE.sysctlbyname(String.format(name, cpu), (Pointer)p, size, null, 0)) {
            sumTemp += (double)p.getInt(0L) / 10.0 - 273.15;
            ++cpu;
        }
        return cpu > 0 ? sumTemp / (double)cpu : Double.NaN;
    }

    @Override
    public int[] getFanSpeeds() {
        return new int[0];
    }

    @Override
    public double getCpuVoltage() {
        return 0.0;
    }
}

