/*
 * Decompiled with CFR 0.152.
 */
package com.github.ornolfr.ratingview;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import com.github.ornolfr.ratingview.R;

public class RatingView
extends View
implements View.OnTouchListener {
    private static final boolean DEFAULT_IS_INDICATOR = false;
    private static final float DEFAULT_RATING = 3.5f;
    private static final int DEFAULT_MAX_COUNT = 5;
    private static final int DEFAULT_DRAWABLE_SIZE_IN_DP = 32;
    private static final int DEFAULT_DRAWABLE_MARGIN_IN_DP = 4;
    private OnRatingChangedListener mListener;
    private Bitmap mDrawableEmpty;
    private Bitmap mDrawableHalf;
    private Bitmap mDrawableFilled;
    private Rect mRect = new Rect();
    private boolean mIsIndicator;
    private float mRating;
    private int mMaxCount;
    private int mDrawableSize;
    private int mDrawableMargin;

    public RatingView(Context context) {
        super(context);
        this.init(null, 0, 0);
    }

    public RatingView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, 0, 0);
    }

    public RatingView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs, defStyleAttr, 0);
    }

    @TargetApi(value=21)
    public RatingView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(attrs, defStyleAttr, defStyleRes);
    }

    private void init(AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.RatingView, defStyleAttr, defStyleRes);
        this.mDrawableMargin = (int)a.getDimension(R.styleable.RatingView_drawable_margin, TypedValue.applyDimension((int)1, (float)4.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
        this.mDrawableSize = (int)a.getDimension(R.styleable.RatingView_drawable_size, TypedValue.applyDimension((int)1, (float)32.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
        if (this.mDrawableSize < 0) {
            throw new IllegalArgumentException("Drawable size < 0");
        }
        this.mMaxCount = a.getInteger(R.styleable.RatingView_max_count, 5);
        if (this.mMaxCount < 1) {
            throw new IllegalArgumentException("Max count < 1");
        }
        this.mRating = a.getFloat(R.styleable.RatingView_rating, 3.5f);
        this.mIsIndicator = a.getBoolean(R.styleable.RatingView_is_indicator, false);
        this.mDrawableEmpty = BitmapFactory.decodeResource((Resources)this.getContext().getResources(), (int)a.getResourceId(R.styleable.RatingView_drawable_empty, R.drawable.ic_star_empty));
        this.mDrawableHalf = BitmapFactory.decodeResource((Resources)this.getContext().getResources(), (int)a.getResourceId(R.styleable.RatingView_drawable_half, R.drawable.ic_star_half));
        this.mDrawableFilled = BitmapFactory.decodeResource((Resources)this.getContext().getResources(), (int)a.getResourceId(R.styleable.RatingView_drawable_filled, R.drawable.ic_star_filled));
        a.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(RatingView.resolveSize((int)(this.mDrawableSize * this.mMaxCount + this.mDrawableMargin * (this.mMaxCount - 1)), (int)widthMeasureSpec), RatingView.resolveSize((int)this.mDrawableSize, (int)heightMeasureSpec));
    }

    protected void onDraw(Canvas canvas) {
        if (!this.mIsIndicator) {
            this.setOnTouchListener(this);
        }
        if (this.mDrawableFilled != null && this.mDrawableHalf != null && this.mDrawableEmpty != null) {
            int i;
            this.mRect.set(0, 0, this.mDrawableSize, this.mDrawableSize);
            int fullDrawablesCount = (int)this.mRating;
            int emptyDrawablesCount = this.mMaxCount - Math.round(this.mRating);
            if (this.mRating - (float)fullDrawablesCount >= 0.75f) {
                ++fullDrawablesCount;
            }
            for (i = 0; i < fullDrawablesCount; ++i) {
                canvas.drawBitmap(this.mDrawableFilled, null, this.mRect, null);
                this.mRect.offset(this.mDrawableSize + this.mDrawableMargin, 0);
            }
            if (this.mRating - (float)fullDrawablesCount >= 0.25f && this.mRating - (float)fullDrawablesCount < 0.75f) {
                canvas.drawBitmap(this.mDrawableHalf, null, this.mRect, null);
                this.mRect.offset(this.mDrawableSize + this.mDrawableMargin, 0);
            }
            for (i = 0; i < emptyDrawablesCount; ++i) {
                canvas.drawBitmap(this.mDrawableEmpty, null, this.mRect, null);
                this.mRect.offset(this.mDrawableSize + this.mDrawableMargin, 0);
            }
        }
    }

    public boolean onTouch(View v, MotionEvent event) {
        switch (event.getActionMasked()) {
            case 0: {
                return true;
            }
            case 1: {
                this.setRating(Math.round((double)(event.getX() / (float)this.getWidth() * (float)this.mMaxCount) + 0.5));
                return false;
            }
        }
        return super.onTouchEvent(event);
    }

    public void setOnRatingChangedListener(OnRatingChangedListener listener) {
        this.mListener = listener;
    }

    public void setIsIndicator(boolean isIndicator) {
        this.mIsIndicator = isIndicator;
        this.setOnTouchListener(this.mIsIndicator ? null : this);
    }

    public void setRating(float rating) {
        float newRating = rating;
        if (newRating < 0.0f) {
            newRating = 0.0f;
        } else if (newRating > (float)this.mMaxCount) {
            newRating = this.mMaxCount;
        }
        if (this.mListener != null) {
            this.mListener.onRatingChange(this.mRating, newRating);
        }
        this.mRating = newRating;
        this.invalidate();
    }

    public void setDrawableEmpty(Bitmap drawableEmpty) {
        this.mDrawableEmpty = drawableEmpty;
        this.invalidate();
    }

    public void setDrawableHalf(Bitmap drawableHalf) {
        this.mDrawableHalf = drawableHalf;
        this.invalidate();
    }

    public void setDrawableFilled(Bitmap drawableFilled) {
        this.mDrawableFilled = drawableFilled;
        this.invalidate();
    }

    public boolean isIndicator() {
        return this.mIsIndicator;
    }

    public float getRating() {
        return this.mRating;
    }

    public int getMaxCount() {
        return this.mMaxCount;
    }

    public int getDrawableSize() {
        return this.mDrawableSize;
    }

    public int getDrawableMargin() {
        return this.mDrawableMargin;
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState savedState = new SavedState(superState);
        savedState.mRating = this.mRating;
        savedState.mIndicator = this.mIsIndicator;
        return savedState;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state instanceof SavedState) {
            SavedState savedState = (SavedState)state;
            super.onRestoreInstanceState(savedState.getSuperState());
            this.mRating = savedState.mRating;
            this.mIsIndicator = savedState.mIndicator;
        } else {
            super.onRestoreInstanceState(state);
        }
    }

    static class SavedState
    extends View.BaseSavedState {
        float mRating;
        boolean mIndicator;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.mRating = in.readFloat();
            this.mIndicator = in.readInt() == 0;
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeFloat(this.mRating);
            out.writeInt(this.mIndicator ? 1 : 0);
        }
    }

    public static interface OnRatingChangedListener {
        public void onRatingChange(float var1, float var2);
    }
}

