/*
 * Decompiled with CFR 0.152.
 */
package mf.org.apache.xerces.dom;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.WeakHashMap;
import mf.org.apache.xerces.dom.AttrImpl;
import mf.org.apache.xerces.dom.AttrNSImpl;
import mf.org.apache.xerces.dom.CDATASectionImpl;
import mf.org.apache.xerces.dom.CharacterDataImpl;
import mf.org.apache.xerces.dom.ChildNode;
import mf.org.apache.xerces.dom.CommentImpl;
import mf.org.apache.xerces.dom.CoreDOMImplementationImpl;
import mf.org.apache.xerces.dom.DOMConfigurationImpl;
import mf.org.apache.xerces.dom.DOMImplementationImpl;
import mf.org.apache.xerces.dom.DOMMessageFormatter;
import mf.org.apache.xerces.dom.DOMNormalizer;
import mf.org.apache.xerces.dom.DeepNodeListImpl;
import mf.org.apache.xerces.dom.DeferredDOMImplementationImpl;
import mf.org.apache.xerces.dom.DocumentFragmentImpl;
import mf.org.apache.xerces.dom.DocumentTypeImpl;
import mf.org.apache.xerces.dom.ElementDefinitionImpl;
import mf.org.apache.xerces.dom.ElementImpl;
import mf.org.apache.xerces.dom.ElementNSImpl;
import mf.org.apache.xerces.dom.EntityImpl;
import mf.org.apache.xerces.dom.EntityReferenceImpl;
import mf.org.apache.xerces.dom.NodeImpl;
import mf.org.apache.xerces.dom.NodeListCache;
import mf.org.apache.xerces.dom.NotationImpl;
import mf.org.apache.xerces.dom.ObjectFactory;
import mf.org.apache.xerces.dom.ParentNode;
import mf.org.apache.xerces.dom.ProcessingInstructionImpl;
import mf.org.apache.xerces.dom.TextImpl;
import mf.org.apache.xerces.util.URI;
import mf.org.apache.xerces.util.XML11Char;
import mf.org.apache.xerces.util.XMLChar;
import mf.org.apache.xerces.xni.NamespaceContext;
import mf.org.w3c.dom.Attr;
import mf.org.w3c.dom.CDATASection;
import mf.org.w3c.dom.Comment;
import mf.org.w3c.dom.DOMConfiguration;
import mf.org.w3c.dom.DOMException;
import mf.org.w3c.dom.DOMImplementation;
import mf.org.w3c.dom.Document;
import mf.org.w3c.dom.DocumentFragment;
import mf.org.w3c.dom.DocumentType;
import mf.org.w3c.dom.Element;
import mf.org.w3c.dom.Entity;
import mf.org.w3c.dom.EntityReference;
import mf.org.w3c.dom.NamedNodeMap;
import mf.org.w3c.dom.Node;
import mf.org.w3c.dom.NodeList;
import mf.org.w3c.dom.Notation;
import mf.org.w3c.dom.ProcessingInstruction;
import mf.org.w3c.dom.Text;
import mf.org.w3c.dom.UserDataHandler;
import mf.org.w3c.dom.events.Event;
import mf.org.w3c.dom.events.EventListener;
import mf.org.w3c.dom.ls.DOMImplementationLS;
import mf.org.w3c.dom.ls.LSSerializer;

public class CoreDocumentImpl
extends ParentNode
implements Document {
    static final long serialVersionUID = 0L;
    protected DocumentTypeImpl docType;
    protected ElementImpl docElement;
    transient NodeListCache fFreeNLCache;
    protected String encoding;
    protected String actualEncoding;
    protected String version;
    protected boolean standalone;
    protected String fDocumentURI;
    protected Map userData;
    protected Hashtable identifiers;
    transient DOMNormalizer domNormalizer = null;
    transient DOMConfigurationImpl fConfiguration = null;
    transient Object fXPathEvaluator = null;
    private static final int[] kidOK = new int[13];
    protected int changes = 0;
    protected boolean allowGrammarAccess;
    protected boolean errorChecking = true;
    protected boolean xmlVersionChanged = false;
    private int documentNumber = 0;
    private int nodeCounter = 0;
    private Map nodeTable;
    private boolean xml11Version = false;

    public CoreDocumentImpl() {
        this(false);
    }

    public CoreDocumentImpl(boolean grammarAccess) {
        super(null);
        this.ownerDocument = this;
        this.allowGrammarAccess = grammarAccess;
    }

    public CoreDocumentImpl(DocumentType doctype) {
        this(doctype, false);
    }

    public CoreDocumentImpl(DocumentType doctype, boolean grammarAccess) {
        this(grammarAccess);
        if (doctype != null) {
            try {
                DocumentTypeImpl doctypeImpl = (DocumentTypeImpl)doctype;
            }
            catch (ClassCastException e) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null);
                throw new DOMException(4, msg);
            }
            doctypeImpl.ownerDocument = this;
            this.appendChild(doctype);
        }
    }

    public final Document getOwnerDocument() {
        return null;
    }

    public short getNodeType() {
        return 9;
    }

    public String getNodeName() {
        return "#document";
    }

    public Node cloneNode(boolean deep) {
        CoreDocumentImpl newdoc = new CoreDocumentImpl();
        this.callUserDataHandlers(this, newdoc, (short)1);
        this.cloneNode(newdoc, deep);
        return newdoc;
    }

    protected void cloneNode(CoreDocumentImpl newdoc, boolean deep) {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        if (deep) {
            HashMap reversedIdentifiers = null;
            if (this.identifiers != null) {
                reversedIdentifiers = new HashMap();
                for (Map.Entry entry : this.identifiers.entrySet()) {
                    Object elementId = entry.getKey();
                    Object elementNode = entry.getValue();
                    reversedIdentifiers.put(elementNode, elementId);
                }
            }
            ChildNode kid = this.firstChild;
            while (kid != null) {
                newdoc.appendChild(newdoc.importNode(kid, true, true, reversedIdentifiers));
                kid = kid.nextSibling;
            }
        }
        newdoc.allowGrammarAccess = this.allowGrammarAccess;
        newdoc.errorChecking = this.errorChecking;
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        short type = newChild.getNodeType();
        if (this.errorChecking) {
            if (this.needsSyncChildren()) {
                this.synchronizeChildren();
            }
            if (type == 1 && this.docElement != null || type == 10 && this.docType != null) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "HIERARCHY_REQUEST_ERR", null);
                throw new DOMException(3, msg);
            }
        }
        if (newChild.getOwnerDocument() == null && newChild instanceof DocumentTypeImpl) {
            ((DocumentTypeImpl)newChild).ownerDocument = this;
        }
        super.insertBefore(newChild, refChild);
        if (type == 1) {
            this.docElement = (ElementImpl)newChild;
        } else if (type == 10) {
            this.docType = (DocumentTypeImpl)newChild;
        }
        return newChild;
    }

    public Node removeChild(Node oldChild) throws DOMException {
        super.removeChild(oldChild);
        short type = oldChild.getNodeType();
        if (type == 1) {
            this.docElement = null;
        } else if (type == 10) {
            this.docType = null;
        }
        return oldChild;
    }

    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        if (newChild.getOwnerDocument() == null && newChild instanceof DocumentTypeImpl) {
            ((DocumentTypeImpl)newChild).ownerDocument = this;
        }
        if (this.errorChecking && (this.docType != null && oldChild.getNodeType() != 10 && newChild.getNodeType() == 10 || this.docElement != null && oldChild.getNodeType() != 1 && newChild.getNodeType() == 1)) {
            throw new DOMException(3, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "HIERARCHY_REQUEST_ERR", null));
        }
        super.replaceChild(newChild, oldChild);
        short type = oldChild.getNodeType();
        if (type == 1) {
            this.docElement = (ElementImpl)newChild;
        } else if (type == 10) {
            this.docType = (DocumentTypeImpl)newChild;
        }
        return oldChild;
    }

    public String getTextContent() throws DOMException {
        return null;
    }

    public void setTextContent(String textContent) throws DOMException {
    }

    public Object getFeature(String feature, String version) {
        boolean anyVersion;
        boolean bl = anyVersion = version == null || version.length() == 0;
        if (feature.equalsIgnoreCase("+XPath") && (anyVersion || version.equals("3.0"))) {
            if (this.fXPathEvaluator != null) {
                return this.fXPathEvaluator;
            }
            try {
                Class xpathClass = ObjectFactory.findProviderClass("org.apache.xpath.domapi.XPathEvaluatorImpl", ObjectFactory.findClassLoader(), true);
                Constructor xpathClassConstr = xpathClass.getConstructor(Document.class);
                Class<?>[] interfaces = xpathClass.getInterfaces();
                for (int i = 0; i < interfaces.length; ++i) {
                    if (!interfaces[i].getName().equals("org.w3c.dom.xpath.XPathEvaluator")) continue;
                    this.fXPathEvaluator = xpathClassConstr.newInstance(this);
                    return this.fXPathEvaluator;
                }
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }
        return super.getFeature(feature, version);
    }

    public Attr createAttribute(String name) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(name, this.xml11Version)) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null);
            throw new DOMException(5, msg);
        }
        return new AttrImpl(this, name);
    }

    public CDATASection createCDATASection(String data) throws DOMException {
        return new CDATASectionImpl(this, data);
    }

    public Comment createComment(String data) {
        return new CommentImpl(this, data);
    }

    public DocumentFragment createDocumentFragment() {
        return new DocumentFragmentImpl(this);
    }

    public Element createElement(String tagName) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(tagName, this.xml11Version)) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null);
            throw new DOMException(5, msg);
        }
        return new ElementImpl(this, tagName);
    }

    public EntityReference createEntityReference(String name) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(name, this.xml11Version)) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null);
            throw new DOMException(5, msg);
        }
        return new EntityReferenceImpl(this, name);
    }

    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(target, this.xml11Version)) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null);
            throw new DOMException(5, msg);
        }
        return new ProcessingInstructionImpl(this, target, data);
    }

    public Text createTextNode(String data) {
        return new TextImpl(this, data);
    }

    public DocumentType getDoctype() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        return this.docType;
    }

    public Element getDocumentElement() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        return this.docElement;
    }

    public NodeList getElementsByTagName(String tagname) {
        return new DeepNodeListImpl(this, tagname);
    }

    public DOMImplementation getImplementation() {
        return CoreDOMImplementationImpl.getDOMImplementation();
    }

    public void setErrorChecking(boolean check) {
        this.errorChecking = check;
    }

    public void setStrictErrorChecking(boolean check) {
        this.errorChecking = check;
    }

    public boolean getErrorChecking() {
        return this.errorChecking;
    }

    public boolean getStrictErrorChecking() {
        return this.errorChecking;
    }

    public String getInputEncoding() {
        return this.actualEncoding;
    }

    public void setInputEncoding(String value) {
        this.actualEncoding = value;
    }

    public void setXmlEncoding(String value) {
        this.encoding = value;
    }

    public void setEncoding(String value) {
        this.setXmlEncoding(value);
    }

    public String getXmlEncoding() {
        return this.encoding;
    }

    public String getEncoding() {
        return this.getXmlEncoding();
    }

    public void setXmlVersion(String value) {
        if (value.equals("1.0") || value.equals("1.1")) {
            if (!this.getXmlVersion().equals(value)) {
                this.xmlVersionChanged = true;
                this.isNormalized(false);
                this.version = value;
            }
        } else {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_SUPPORTED_ERR", null);
            throw new DOMException(9, msg);
        }
        this.xml11Version = this.getXmlVersion().equals("1.1");
    }

    public void setVersion(String value) {
        this.setXmlVersion(value);
    }

    public String getXmlVersion() {
        return this.version == null ? "1.0" : this.version;
    }

    public String getVersion() {
        return this.getXmlVersion();
    }

    public void setXmlStandalone(boolean value) throws DOMException {
        this.standalone = value;
    }

    public void setStandalone(boolean value) {
        this.setXmlStandalone(value);
    }

    public boolean getXmlStandalone() {
        return this.standalone;
    }

    public boolean getStandalone() {
        return this.getXmlStandalone();
    }

    public String getDocumentURI() {
        return this.fDocumentURI;
    }

    protected boolean canRenameElements(String newNamespaceURI, String newNodeName, ElementImpl el) {
        return true;
    }

    public Node renameNode(Node n, String namespaceURI, String name) throws DOMException {
        if (this.errorChecking && n.getOwnerDocument() != this && n != this) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null);
            throw new DOMException(4, msg);
        }
        switch (n.getNodeType()) {
            case 1: {
                ElementImpl el = (ElementImpl)n;
                if (el instanceof ElementNSImpl) {
                    if (this.canRenameElements(namespaceURI, name, el)) {
                        ((ElementNSImpl)el).rename(namespaceURI, name);
                        this.callUserDataHandlers(el, null, (short)4);
                    } else {
                        el = this.replaceRenameElement(el, namespaceURI, name);
                    }
                } else if (namespaceURI == null && this.canRenameElements(null, name, el)) {
                    el.rename(name);
                    this.callUserDataHandlers(el, null, (short)4);
                } else {
                    el = this.replaceRenameElement(el, namespaceURI, name);
                }
                this.renamedElement((Element)n, el);
                return el;
            }
            case 2: {
                AttrImpl at = (AttrImpl)n;
                Element el = at.getOwnerElement();
                if (el != null) {
                    el.removeAttributeNode(at);
                }
                if (n instanceof AttrNSImpl) {
                    ((AttrNSImpl)at).rename(namespaceURI, name);
                    if (el != null) {
                        el.setAttributeNodeNS(at);
                    }
                    this.callUserDataHandlers(at, null, (short)4);
                } else if (namespaceURI == null) {
                    at.rename(name);
                    if (el != null) {
                        el.setAttributeNode(at);
                    }
                    this.callUserDataHandlers(at, null, (short)4);
                } else {
                    AttrNSImpl nat = (AttrNSImpl)this.createAttributeNS(namespaceURI, name);
                    this.copyEventListeners(at, nat);
                    Hashtable data = this.removeUserDataTable(at);
                    Node child = at.getFirstChild();
                    while (child != null) {
                        at.removeChild(child);
                        nat.appendChild(child);
                        child = at.getFirstChild();
                    }
                    this.setUserDataTable(nat, data);
                    this.callUserDataHandlers(at, nat, (short)4);
                    if (el != null) {
                        el.setAttributeNode(nat);
                    }
                    at = nat;
                }
                this.renamedAttrNode((Attr)n, at);
                return at;
            }
        }
        String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_SUPPORTED_ERR", null);
        throw new DOMException(9, msg);
    }

    private ElementImpl replaceRenameElement(ElementImpl el, String namespaceURI, String name) {
        ElementNSImpl nel = (ElementNSImpl)this.createElementNS(namespaceURI, name);
        this.copyEventListeners(el, nel);
        Hashtable data = this.removeUserDataTable(el);
        Node parent = el.getParentNode();
        Node nextSib = el.getNextSibling();
        if (parent != null) {
            parent.removeChild(el);
        }
        Node child = el.getFirstChild();
        while (child != null) {
            el.removeChild(child);
            nel.appendChild(child);
            child = el.getFirstChild();
        }
        nel.moveSpecifiedAttributes(el);
        this.setUserDataTable(nel, data);
        this.callUserDataHandlers(el, nel, (short)4);
        if (parent != null) {
            parent.insertBefore(nel, nextSib);
        }
        return nel;
    }

    public void normalizeDocument() {
        if (this.isNormalized() && !this.isNormalizeDocRequired()) {
            return;
        }
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        if (this.domNormalizer == null) {
            this.domNormalizer = new DOMNormalizer();
        }
        if (this.fConfiguration == null) {
            this.fConfiguration = new DOMConfigurationImpl();
        } else {
            this.fConfiguration.reset();
        }
        this.domNormalizer.normalizeDocument(this, this.fConfiguration);
        this.isNormalized(true);
        this.xmlVersionChanged = false;
    }

    public DOMConfiguration getDomConfig() {
        if (this.fConfiguration == null) {
            this.fConfiguration = new DOMConfigurationImpl();
        }
        return this.fConfiguration;
    }

    public String getBaseURI() {
        if (this.fDocumentURI != null && this.fDocumentURI.length() != 0) {
            try {
                return new URI(this.fDocumentURI).toString();
            }
            catch (URI.MalformedURIException e) {
                return null;
            }
        }
        return this.fDocumentURI;
    }

    public void setDocumentURI(String documentURI) {
        this.fDocumentURI = documentURI;
    }

    public boolean getAsync() {
        return false;
    }

    public void setAsync(boolean async) {
        if (async) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_SUPPORTED_ERR", null);
            throw new DOMException(9, msg);
        }
    }

    public void abort() {
    }

    public boolean load(String uri) {
        return false;
    }

    public boolean loadXML(String source) {
        return false;
    }

    public String saveXML(Node node) throws DOMException {
        if (this.errorChecking && node != null && this != node.getOwnerDocument()) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null);
            throw new DOMException(4, msg);
        }
        DOMImplementationLS domImplLS = (DOMImplementationLS)((Object)DOMImplementationImpl.getDOMImplementation());
        LSSerializer xmlWriter = domImplLS.createLSSerializer();
        if (node == null) {
            node = this;
        }
        return xmlWriter.writeToString(node);
    }

    void setMutationEvents(boolean set) {
    }

    boolean getMutationEvents() {
        return false;
    }

    public DocumentType createDocumentType(String qualifiedName, String publicID, String systemID) throws DOMException {
        return new DocumentTypeImpl(this, qualifiedName, publicID, systemID);
    }

    public Entity createEntity(String name) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(name, this.xml11Version)) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null);
            throw new DOMException(5, msg);
        }
        return new EntityImpl(this, name);
    }

    public Notation createNotation(String name) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(name, this.xml11Version)) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null);
            throw new DOMException(5, msg);
        }
        return new NotationImpl(this, name);
    }

    public ElementDefinitionImpl createElementDefinition(String name) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(name, this.xml11Version)) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null);
            throw new DOMException(5, msg);
        }
        return new ElementDefinitionImpl(this, name);
    }

    protected int getNodeNumber() {
        if (this.documentNumber == 0) {
            CoreDOMImplementationImpl cd = (CoreDOMImplementationImpl)CoreDOMImplementationImpl.getDOMImplementation();
            this.documentNumber = cd.assignDocumentNumber();
        }
        return this.documentNumber;
    }

    protected int getNodeNumber(Node node) {
        int num;
        if (this.nodeTable == null) {
            this.nodeTable = new WeakHashMap();
            num = --this.nodeCounter;
            this.nodeTable.put(node, new Integer(num));
        } else {
            Integer n = (Integer)this.nodeTable.get(node);
            if (n == null) {
                num = --this.nodeCounter;
                this.nodeTable.put(node, new Integer(num));
            } else {
                num = n;
            }
        }
        return num;
    }

    public Node importNode(Node source, boolean deep) throws DOMException {
        return this.importNode(source, deep, false, null);
    }

    private Node importNode(Node source, boolean deep, boolean cloningDoc, HashMap reversedIdentifiers) throws DOMException {
        Node newnode = null;
        Hashtable userData = null;
        if (source instanceof NodeImpl) {
            userData = ((NodeImpl)source).getUserDataRecord();
        }
        short type = source.getNodeType();
        switch (type) {
            case 1: {
                Object elementId;
                boolean domLevel20 = source.getOwnerDocument().getImplementation().hasFeature("XML", "2.0");
                Element newElement = !domLevel20 || source.getLocalName() == null ? this.createElement(source.getNodeName()) : this.createElementNS(source.getNamespaceURI(), source.getNodeName());
                NamedNodeMap sourceAttrs = source.getAttributes();
                if (sourceAttrs != null) {
                    int length = sourceAttrs.getLength();
                    for (int index = 0; index < length; ++index) {
                        Attr attr = (Attr)sourceAttrs.item(index);
                        if (!attr.getSpecified() && !cloningDoc) continue;
                        Attr newAttr = (Attr)this.importNode(attr, true, cloningDoc, reversedIdentifiers);
                        if (!domLevel20 || attr.getLocalName() == null) {
                            newElement.setAttributeNode(newAttr);
                            continue;
                        }
                        newElement.setAttributeNodeNS(newAttr);
                    }
                }
                if (reversedIdentifiers != null && (elementId = reversedIdentifiers.get(source)) != null) {
                    if (this.identifiers == null) {
                        this.identifiers = new Hashtable();
                    }
                    this.identifiers.put(elementId, newElement);
                }
                newnode = newElement;
                break;
            }
            case 2: {
                newnode = source.getOwnerDocument().getImplementation().hasFeature("XML", "2.0") ? (source.getLocalName() == null ? this.createAttribute(source.getNodeName()) : this.createAttributeNS(source.getNamespaceURI(), source.getNodeName())) : this.createAttribute(source.getNodeName());
                if (source instanceof AttrImpl) {
                    AttrImpl attr = (AttrImpl)source;
                    if (attr.hasStringValue()) {
                        AttrImpl newattr = (AttrImpl)newnode;
                        newattr.setValue(attr.getValue());
                        deep = false;
                        break;
                    }
                    deep = true;
                    break;
                }
                if (source.getFirstChild() == null) {
                    newnode.setNodeValue(source.getNodeValue());
                    deep = false;
                    break;
                }
                deep = true;
                break;
            }
            case 3: {
                newnode = this.createTextNode(source.getNodeValue());
                break;
            }
            case 4: {
                newnode = this.createCDATASection(source.getNodeValue());
                break;
            }
            case 5: {
                newnode = this.createEntityReference(source.getNodeName());
                deep = false;
                break;
            }
            case 6: {
                Entity srcentity = (Entity)source;
                EntityImpl newentity = (EntityImpl)this.createEntity(source.getNodeName());
                newentity.setPublicId(srcentity.getPublicId());
                newentity.setSystemId(srcentity.getSystemId());
                newentity.setNotationName(srcentity.getNotationName());
                newentity.isReadOnly(false);
                newnode = newentity;
                break;
            }
            case 7: {
                newnode = this.createProcessingInstruction(source.getNodeName(), source.getNodeValue());
                break;
            }
            case 8: {
                newnode = this.createComment(source.getNodeValue());
                break;
            }
            case 10: {
                int i;
                if (!cloningDoc) {
                    String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_SUPPORTED_ERR", null);
                    throw new DOMException(9, msg);
                }
                DocumentType srcdoctype = (DocumentType)source;
                DocumentTypeImpl newdoctype = (DocumentTypeImpl)this.createDocumentType(srcdoctype.getNodeName(), srcdoctype.getPublicId(), srcdoctype.getSystemId());
                newdoctype.setInternalSubset(srcdoctype.getInternalSubset());
                NamedNodeMap smap = srcdoctype.getEntities();
                NamedNodeMap tmap = newdoctype.getEntities();
                if (smap != null) {
                    for (i = 0; i < smap.getLength(); ++i) {
                        tmap.setNamedItem(this.importNode(smap.item(i), true, true, reversedIdentifiers));
                    }
                }
                smap = srcdoctype.getNotations();
                tmap = newdoctype.getNotations();
                if (smap != null) {
                    for (i = 0; i < smap.getLength(); ++i) {
                        tmap.setNamedItem(this.importNode(smap.item(i), true, true, reversedIdentifiers));
                    }
                }
                newnode = newdoctype;
                break;
            }
            case 11: {
                newnode = this.createDocumentFragment();
                break;
            }
            case 12: {
                Notation srcnotation = (Notation)source;
                NotationImpl newnotation = (NotationImpl)this.createNotation(source.getNodeName());
                newnotation.setPublicId(srcnotation.getPublicId());
                newnotation.setSystemId(srcnotation.getSystemId());
                newnode = newnotation;
                break;
            }
            default: {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_SUPPORTED_ERR", null);
                throw new DOMException(9, msg);
            }
        }
        if (userData != null) {
            this.callUserDataHandlers(source, newnode, (short)2, userData);
        }
        if (deep) {
            for (Node srckid = source.getFirstChild(); srckid != null; srckid = srckid.getNextSibling()) {
                newnode.appendChild(this.importNode(srckid, true, cloningDoc, reversedIdentifiers));
            }
        }
        if (newnode.getNodeType() == 6) {
            ((NodeImpl)newnode).setReadOnly(true, true);
        }
        return newnode;
    }

    public Node adoptNode(Node source) {
        NodeImpl node;
        Hashtable userData = null;
        try {
            node = (NodeImpl)source;
        }
        catch (ClassCastException e) {
            return null;
        }
        if (source == null) {
            return null;
        }
        if (source != null && source.getOwnerDocument() != null) {
            DOMImplementation otherImpl;
            DOMImplementation thisImpl = this.getImplementation();
            if (thisImpl != (otherImpl = source.getOwnerDocument().getImplementation())) {
                if (thisImpl instanceof DOMImplementationImpl && otherImpl instanceof DeferredDOMImplementationImpl) {
                    this.undeferChildren(node);
                } else if (!(thisImpl instanceof DeferredDOMImplementationImpl) || !(otherImpl instanceof DOMImplementationImpl)) {
                    return null;
                }
            } else if (otherImpl instanceof DeferredDOMImplementationImpl) {
                this.undeferChildren(node);
            }
        }
        switch (node.getNodeType()) {
            case 2: {
                AttrImpl attr = (AttrImpl)node;
                if (attr.getOwnerElement() != null) {
                    attr.getOwnerElement().removeAttributeNode(attr);
                }
                attr.isSpecified(true);
                userData = node.getUserDataRecord();
                attr.setOwnerDocument(this);
                if (userData == null) break;
                this.setUserDataTable(node, userData);
                break;
            }
            case 6: 
            case 12: {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
                throw new DOMException(7, msg);
            }
            case 9: 
            case 10: {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_SUPPORTED_ERR", null);
                throw new DOMException(9, msg);
            }
            case 5: {
                NamedNodeMap entities;
                Node entityNode;
                Node child;
                userData = node.getUserDataRecord();
                Node parent = node.getParentNode();
                if (parent != null) {
                    parent.removeChild(source);
                }
                while ((child = node.getFirstChild()) != null) {
                    node.removeChild(child);
                }
                node.setOwnerDocument(this);
                if (userData != null) {
                    this.setUserDataTable(node, userData);
                }
                if (this.docType == null || (entityNode = (entities = this.docType.getEntities()).getNamedItem(node.getNodeName())) == null) break;
                for (child = entityNode.getFirstChild(); child != null; child = child.getNextSibling()) {
                    Node childClone = child.cloneNode(true);
                    node.appendChild(childClone);
                }
                break;
            }
            case 1: {
                userData = node.getUserDataRecord();
                Node parent = node.getParentNode();
                if (parent != null) {
                    parent.removeChild(source);
                }
                node.setOwnerDocument(this);
                if (userData != null) {
                    this.setUserDataTable(node, userData);
                }
                ((ElementImpl)node).reconcileDefaultAttributes();
                break;
            }
            default: {
                userData = node.getUserDataRecord();
                Node parent = node.getParentNode();
                if (parent != null) {
                    parent.removeChild(source);
                }
                node.setOwnerDocument(this);
                if (userData == null) break;
                this.setUserDataTable(node, userData);
            }
        }
        if (userData != null) {
            this.callUserDataHandlers(source, null, (short)5, userData);
        }
        return node;
    }

    protected void undeferChildren(Node node) {
        Node top = node;
        while (null != node) {
            NamedNodeMap attributes;
            if (((NodeImpl)node).needsSyncData()) {
                ((NodeImpl)node).synchronizeData();
            }
            if ((attributes = node.getAttributes()) != null) {
                int length = attributes.getLength();
                for (int i = 0; i < length; ++i) {
                    this.undeferChildren(attributes.item(i));
                }
            }
            Node nextNode = null;
            nextNode = node.getFirstChild();
            while (null == nextNode && !top.equals(node)) {
                nextNode = node.getNextSibling();
                if (null != nextNode || null != (node = node.getParentNode()) && !top.equals(node)) continue;
                nextNode = null;
                break;
            }
            node = nextNode;
        }
    }

    public Element getElementById(String elementId) {
        return this.getIdentifier(elementId);
    }

    protected final void clearIdentifiers() {
        if (this.identifiers != null) {
            this.identifiers.clear();
        }
    }

    public void putIdentifier(String idName, Element element) {
        if (element == null) {
            this.removeIdentifier(idName);
            return;
        }
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.identifiers == null) {
            this.identifiers = new Hashtable();
        }
        this.identifiers.put(idName, element);
    }

    public Element getIdentifier(String idName) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.identifiers == null) {
            return null;
        }
        Element elem = (Element)this.identifiers.get(idName);
        if (elem != null) {
            for (Node parent = elem.getParentNode(); parent != null; parent = parent.getParentNode()) {
                if (parent != this) continue;
                return elem;
            }
        }
        return null;
    }

    public void removeIdentifier(String idName) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.identifiers == null) {
            return;
        }
        this.identifiers.remove(idName);
    }

    public Enumeration getIdentifiers() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.identifiers == null) {
            this.identifiers = new Hashtable();
        }
        return this.identifiers.keys();
    }

    public Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        return new ElementNSImpl(this, namespaceURI, qualifiedName);
    }

    public Element createElementNS(String namespaceURI, String qualifiedName, String localpart) throws DOMException {
        return new ElementNSImpl(this, namespaceURI, qualifiedName, localpart);
    }

    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        return new AttrNSImpl(this, namespaceURI, qualifiedName);
    }

    public Attr createAttributeNS(String namespaceURI, String qualifiedName, String localpart) throws DOMException {
        return new AttrNSImpl(this, namespaceURI, qualifiedName, localpart);
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return new DeepNodeListImpl(this, namespaceURI, localName);
    }

    public Object clone() throws CloneNotSupportedException {
        CoreDocumentImpl newdoc = (CoreDocumentImpl)super.clone();
        newdoc.docType = null;
        newdoc.docElement = null;
        return newdoc;
    }

    public static final boolean isXMLName(String s, boolean xml11Version) {
        if (s == null) {
            return false;
        }
        if (!xml11Version) {
            return XMLChar.isValidName(s);
        }
        return XML11Char.isXML11ValidName(s);
    }

    public static final boolean isValidQName(String prefix, String local, boolean xml11Version) {
        if (local == null) {
            return false;
        }
        boolean validNCName = false;
        validNCName = !xml11Version ? (prefix == null || XMLChar.isValidNCName(prefix)) && XMLChar.isValidNCName(local) : (prefix == null || XML11Char.isXML11ValidNCName(prefix)) && XML11Char.isXML11ValidNCName(local);
        return validNCName;
    }

    protected boolean isKidOK(Node parent, Node child) {
        if (this.allowGrammarAccess && parent.getNodeType() == 10) {
            return child.getNodeType() == 1;
        }
        return 0 != (kidOK[parent.getNodeType()] & 1 << child.getNodeType());
    }

    protected void changed() {
        ++this.changes;
    }

    protected int changes() {
        return this.changes;
    }

    NodeListCache getNodeListCache(ParentNode owner) {
        if (this.fFreeNLCache == null) {
            return new NodeListCache(owner);
        }
        NodeListCache c = this.fFreeNLCache;
        this.fFreeNLCache = this.fFreeNLCache.next;
        c.fChild = null;
        c.fChildIndex = -1;
        c.fLength = -1;
        if (c.fOwner != null) {
            c.fOwner.fNodeListCache = null;
        }
        c.fOwner = owner;
        return c;
    }

    void freeNodeListCache(NodeListCache c) {
        c.next = this.fFreeNLCache;
        this.fFreeNLCache = c;
    }

    public Object setUserData(Node n, String key, Object data, UserDataHandler handler) {
        Hashtable<String, ParentNode.UserDataRecord> t;
        if (data == null) {
            Object o;
            Hashtable t2;
            if (this.userData != null && (t2 = (Hashtable)this.userData.get(n)) != null && (o = t2.remove(key)) != null) {
                ParentNode.UserDataRecord r = (ParentNode.UserDataRecord)o;
                return r.fData;
            }
            return null;
        }
        if (this.userData == null) {
            this.userData = new WeakHashMap();
            t = new Hashtable<String, ParentNode.UserDataRecord>();
            this.userData.put(n, t);
        } else {
            t = (Hashtable<String, ParentNode.UserDataRecord>)this.userData.get(n);
            if (t == null) {
                t = new Hashtable();
                this.userData.put(n, t);
            }
        }
        ParentNode.UserDataRecord o = t.put(key, new ParentNode.UserDataRecord(this, data, handler));
        if (o != null) {
            ParentNode.UserDataRecord r = o;
            return r.fData;
        }
        return null;
    }

    public Object getUserData(Node n, String key) {
        if (this.userData == null) {
            return null;
        }
        Hashtable t = (Hashtable)this.userData.get(n);
        if (t == null) {
            return null;
        }
        Object o = t.get(key);
        if (o != null) {
            ParentNode.UserDataRecord r = (ParentNode.UserDataRecord)o;
            return r.fData;
        }
        return null;
    }

    protected Hashtable getUserDataRecord(Node n) {
        if (this.userData == null) {
            return null;
        }
        Hashtable t = (Hashtable)this.userData.get(n);
        if (t == null) {
            return null;
        }
        return t;
    }

    Hashtable removeUserDataTable(Node n) {
        if (this.userData == null) {
            return null;
        }
        return (Hashtable)this.userData.get(n);
    }

    void setUserDataTable(Node n, Hashtable data) {
        if (this.userData == null) {
            this.userData = new WeakHashMap();
        }
        if (data != null) {
            this.userData.put(n, data);
        }
    }

    protected void callUserDataHandlers(Node n, Node c, short operation) {
        if (this.userData == null) {
            return;
        }
        if (n instanceof NodeImpl) {
            Hashtable t = ((NodeImpl)n).getUserDataRecord();
            if (t == null || t.isEmpty()) {
                return;
            }
            this.callUserDataHandlers(n, c, operation, t);
        }
    }

    void callUserDataHandlers(Node n, Node c, short operation, Hashtable userData) {
        if (userData == null || userData.isEmpty()) {
            return;
        }
        for (Map.Entry entry : userData.entrySet()) {
            String key = (String)entry.getKey();
            ParentNode.UserDataRecord r = (ParentNode.UserDataRecord)entry.getValue();
            if (r.fHandler == null) continue;
            r.fHandler.handle(operation, key, r.fData, n, c);
        }
    }

    protected final void checkNamespaceWF(String qname, int colon1, int colon2) {
        if (!this.errorChecking) {
            return;
        }
        if (colon1 == 0 || colon1 == qname.length() - 1 || colon2 != colon1) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NAMESPACE_ERR", null);
            throw new DOMException(14, msg);
        }
    }

    protected final void checkDOMNSErr(String prefix, String namespace) {
        if (this.errorChecking) {
            if (namespace == null) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NAMESPACE_ERR", null);
                throw new DOMException(14, msg);
            }
            if (prefix.equals("xml") && !namespace.equals(NamespaceContext.XML_URI)) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NAMESPACE_ERR", null);
                throw new DOMException(14, msg);
            }
            if (prefix.equals("xmlns") && !namespace.equals(NamespaceContext.XMLNS_URI) || !prefix.equals("xmlns") && namespace.equals(NamespaceContext.XMLNS_URI)) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NAMESPACE_ERR", null);
                throw new DOMException(14, msg);
            }
        }
    }

    protected final void checkQName(String prefix, String local) {
        if (!this.errorChecking) {
            return;
        }
        boolean validNCName = false;
        if (!this.xml11Version) {
            validNCName = (prefix == null || XMLChar.isValidNCName(prefix)) && XMLChar.isValidNCName(local);
        } else {
            boolean bl = validNCName = (prefix == null || XML11Char.isXML11ValidNCName(prefix)) && XML11Char.isXML11ValidNCName(local);
        }
        if (!validNCName) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null);
            throw new DOMException(5, msg);
        }
    }

    boolean isXML11Version() {
        return this.xml11Version;
    }

    boolean isNormalizeDocRequired() {
        return true;
    }

    boolean isXMLVersionChanged() {
        return this.xmlVersionChanged;
    }

    protected void setUserData(NodeImpl n, Object data) {
        this.setUserData(n, "XERCES1DOMUSERDATA", data, null);
    }

    protected Object getUserData(NodeImpl n) {
        return this.getUserData(n, "XERCES1DOMUSERDATA");
    }

    protected void addEventListener(NodeImpl node, String type, EventListener listener, boolean useCapture) {
    }

    protected void removeEventListener(NodeImpl node, String type, EventListener listener, boolean useCapture) {
    }

    protected void copyEventListeners(NodeImpl src, NodeImpl tgt) {
    }

    protected boolean dispatchEvent(NodeImpl node, Event event) {
        return false;
    }

    void replacedText(CharacterDataImpl node) {
    }

    void deletedText(CharacterDataImpl node, int offset, int count) {
    }

    void insertedText(CharacterDataImpl node, int offset, int count) {
    }

    void modifyingCharacterData(NodeImpl node, boolean replace) {
    }

    void modifiedCharacterData(NodeImpl node, String oldvalue, String value, boolean replace) {
    }

    void insertingNode(NodeImpl node, boolean replace) {
    }

    void insertedNode(NodeImpl node, NodeImpl newInternal, boolean replace) {
    }

    void removingNode(NodeImpl node, NodeImpl oldChild, boolean replace) {
    }

    void removedNode(NodeImpl node, boolean replace) {
    }

    void replacingNode(NodeImpl node) {
    }

    void replacedNode(NodeImpl node) {
    }

    void replacingData(NodeImpl node) {
    }

    void replacedCharacterData(NodeImpl node, String oldvalue, String value) {
    }

    void modifiedAttrValue(AttrImpl attr, String oldvalue) {
    }

    void setAttrNode(AttrImpl attr, AttrImpl previous) {
    }

    void removedAttrNode(AttrImpl attr, NodeImpl oldOwner, String name) {
    }

    void renamedAttrNode(Attr oldAt, Attr newAt) {
    }

    void renamedElement(Element oldEl, Element newEl) {
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.userData != null) {
            this.userData = new WeakHashMap(this.userData);
        }
        if (this.nodeTable != null) {
            this.nodeTable = new WeakHashMap(this.nodeTable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        Map oldUserData = this.userData;
        Map oldNodeTable = this.nodeTable;
        try {
            if (oldUserData != null) {
                this.userData = new Hashtable(oldUserData);
            }
            if (oldNodeTable != null) {
                this.nodeTable = new Hashtable(oldNodeTable);
            }
            out.defaultWriteObject();
        }
        finally {
            this.userData = oldUserData;
            this.nodeTable = oldNodeTable;
        }
    }

    static {
        CoreDocumentImpl.kidOK[9] = 1410;
        CoreDocumentImpl.kidOK[1] = 442;
        CoreDocumentImpl.kidOK[5] = 442;
        CoreDocumentImpl.kidOK[6] = 442;
        CoreDocumentImpl.kidOK[11] = 442;
        CoreDocumentImpl.kidOK[2] = 40;
        CoreDocumentImpl.kidOK[12] = 0;
        CoreDocumentImpl.kidOK[4] = 0;
        CoreDocumentImpl.kidOK[3] = 0;
        CoreDocumentImpl.kidOK[8] = 0;
        CoreDocumentImpl.kidOK[7] = 0;
        CoreDocumentImpl.kidOK[10] = 0;
    }
}

