/*
 * Decompiled with CFR 0.152.
 */
package com.orhanobut.hawk;

import android.content.Context;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Pair;
import com.orhanobut.hawk.HawkUtils;
import com.orhanobut.hawk.Storage;
import java.util.List;

class SqliteStorage
implements Storage {
    private static final String DB_NAME = "Hawk";
    private final SqliteHelper helper;

    SqliteStorage(Context context) {
        HawkUtils.checkNull("Context", context);
        this.helper = new SqliteHelper(context, DB_NAME);
    }

    SqliteStorage(SqliteHelper sqliteHelper) {
        this.helper = sqliteHelper;
    }

    @Override
    public <T> boolean put(String key, T value) {
        HawkUtils.checkNullOrEmpty("key", key);
        return this.helper.put(key, String.valueOf(value));
    }

    @Override
    public boolean put(List<Pair<String, ?>> items) {
        return this.helper.put(items);
    }

    @Override
    public <T> T get(String key) {
        HawkUtils.checkNullOrEmpty("key", key);
        return (T)this.helper.get(key);
    }

    @Override
    public boolean remove(String key) {
        if (HawkUtils.isEmpty(key)) {
            return true;
        }
        return this.helper.delete(key);
    }

    @Override
    public boolean remove(String ... keys) {
        return this.helper.delete(keys);
    }

    @Override
    public boolean clear() {
        return this.helper.clearAll();
    }

    @Override
    public long count() {
        return this.helper.count();
    }

    @Override
    public boolean contains(String key) {
        if (key == null) {
            return false;
        }
        return this.helper.contains(key);
    }

    static class SqliteHelper
    extends SQLiteOpenHelper {
        private static final String TABLE_NAME = "hawk";
        private static final String COL_KEY = "hawk_key";
        private static final String COL_VALUE = "hawk_value";
        private static final int VERSION = 1;

        public SqliteHelper(Context context, String dbName) {
            super(context, dbName, null, 1);
        }

        public void onCreate(SQLiteDatabase db) {
            db.execSQL("CREATE TABLE hawk ( hawk_key text primary key not null, hawk_value text null);");
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized boolean put(String key, String value) {
            try (SQLiteDatabase db = this.getWritableDatabase();){
                db.execSQL("INSERT OR REPLACE INTO hawk (hawk_key, hawk_value)  VALUES('" + key + "', '" + value + "')");
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized boolean put(List<Pair<String, ?>> list) {
            SQLiteDatabase db = this.getWritableDatabase();
            boolean result = true;
            try {
                db.beginTransaction();
                for (Pair<String, ?> pair : list) {
                    db.execSQL("INSERT OR REPLACE INTO hawk (hawk_key, hawk_value)  VALUES('" + (String)pair.first + "', '" + String.valueOf(pair.second) + "')");
                }
                db.setTransactionSuccessful();
            }
            catch (Exception e) {
                result = false;
            }
            finally {
                db.endTransaction();
                db.close();
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized boolean delete(String key) {
            int count = 0;
            try (SQLiteDatabase db = this.getWritableDatabase();){
                count = db.delete(TABLE_NAME, "hawk_key='" + key + "'", null);
            }
            return count != 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized boolean delete(String ... keys) {
            SQLiteDatabase db = this.getWritableDatabase();
            boolean result = true;
            try {
                db.beginTransaction();
                for (String key : keys) {
                    if (key == null) continue;
                    db.delete(TABLE_NAME, "hawk_key='" + key + "'", null);
                }
                db.setTransactionSuccessful();
            }
            catch (Exception e) {
                result = false;
            }
            finally {
                db.endTransaction();
                db.close();
            }
            return result;
        }

        public synchronized boolean contains(String key) {
            return this.get(key) != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized String get(String key) {
            SQLiteDatabase db = this.getReadableDatabase();
            Cursor cursor = null;
            String value = null;
            try {
                cursor = db.rawQuery("SELECT * FROM hawk WHERE hawk_key = '" + key + "'", null);
                if (cursor == null) {
                    String string = null;
                    return string;
                }
                if (!cursor.moveToFirst()) {
                    String string = null;
                    return string;
                }
                value = cursor.getString(1);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
                db.close();
            }
            return value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized boolean clearAll() {
            try (SQLiteDatabase db = this.getWritableDatabase();){
                db.execSQL("DELETE FROM hawk");
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized long count() {
            long count = 0L;
            try (SQLiteDatabase db = this.getWritableDatabase();){
                count = DatabaseUtils.queryNumEntries((SQLiteDatabase)db, (String)TABLE_NAME);
            }
            return count;
        }
    }
}

