/*
 * Decompiled with CFR 0.152.
 */
package com.orhanobut.hawk;

import android.content.Context;
import android.util.Log;
import android.util.Pair;
import com.orhanobut.hawk.DataHelper;
import com.orhanobut.hawk.DataInfo;
import com.orhanobut.hawk.Encoder;
import com.orhanobut.hawk.Encryption;
import com.orhanobut.hawk.HawkBuilder;
import com.orhanobut.hawk.HawkUtils;
import com.orhanobut.hawk.LogLevel;
import com.orhanobut.hawk.Logger;
import com.orhanobut.hawk.Storage;
import java.util.ArrayList;
import java.util.List;
import rx.Observable;
import rx.Subscriber;

public final class Hawk {
    static Hawk HAWK;
    private final Storage storage;
    private final Encoder encoder;
    private final Encryption encryption;
    private final LogLevel logLevel;

    private Hawk(HawkBuilder builder) {
        this.storage = builder.getStorage();
        this.encoder = builder.getEncoder();
        this.encryption = builder.getEncryption();
        this.logLevel = builder.getLogLevel();
    }

    public static HawkBuilder init(Context context) {
        HawkUtils.checkNull("Context", context);
        HAWK = null;
        return new HawkBuilder(context);
    }

    static void build(HawkBuilder hawkBuilder) {
        HAWK = new Hawk(hawkBuilder);
    }

    public static <T> boolean put(String key, T value) {
        HawkUtils.checkNull("Key", key);
        HawkUtils.validateBuild();
        if (value == null) {
            return Hawk.remove(key);
        }
        String encodedText = Hawk.zip(value);
        return encodedText != null && Hawk.HAWK.storage.put(key, encodedText);
    }

    public static <T> Observable<Boolean> putObservable(final String key, final T value) {
        HawkUtils.checkRx();
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<Boolean>(){

            public void call(Subscriber<? super Boolean> subscriber) {
                block3: {
                    try {
                        boolean result = Hawk.put(key, value);
                        if (!subscriber.isUnsubscribed()) {
                            subscriber.onNext((Object)result);
                            subscriber.onCompleted();
                        }
                    }
                    catch (Exception e) {
                        if (subscriber.isUnsubscribed()) break block3;
                        subscriber.onError((Throwable)e);
                    }
                }
            }
        });
    }

    public static <T> T get(String key) {
        HawkUtils.checkNull("Key", key);
        HawkUtils.validateBuild();
        String fullText = (String)Hawk.HAWK.storage.get(key);
        if (fullText == null) {
            return null;
        }
        DataInfo dataInfo = DataHelper.getDataInfo(fullText);
        byte[] bytes = Hawk.HAWK.encryption.decrypt(dataInfo.cipherText);
        if (bytes == null) {
            return null;
        }
        try {
            return Hawk.HAWK.encoder.decode(bytes, dataInfo);
        }
        catch (Exception e) {
            Logger.d(e.getMessage());
            return null;
        }
    }

    public static <T> T get(String key, T defaultValue) {
        T t = Hawk.get(key);
        if (t == null) {
            return defaultValue;
        }
        return t;
    }

    public static <T> Observable<T> getObservable(String key) {
        HawkUtils.checkRx();
        return Hawk.getObservable(key, null);
    }

    public static <T> Observable<T> getObservable(final String key, final T defaultValue) {
        HawkUtils.checkRx();
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<T>(){

            public void call(Subscriber<? super T> subscriber) {
                block3: {
                    try {
                        Object t = Hawk.get(key, defaultValue);
                        if (!subscriber.isUnsubscribed()) {
                            subscriber.onNext(t);
                            subscriber.onCompleted();
                        }
                    }
                    catch (Exception e) {
                        if (subscriber.isUnsubscribed()) break block3;
                        subscriber.onError((Throwable)e);
                    }
                }
            }
        });
    }

    public static Chain chain() {
        return new Chain();
    }

    public static Chain chain(int capacity) {
        return new Chain(capacity);
    }

    public static long count() {
        HawkUtils.validateBuild();
        return Hawk.HAWK.storage.count();
    }

    public static boolean clear() {
        HawkUtils.validateBuild();
        return Hawk.HAWK.storage.clear();
    }

    public static boolean remove(String key) {
        HawkUtils.validateBuild();
        return Hawk.HAWK.storage.remove(key);
    }

    public static boolean remove(String ... keys) {
        HawkUtils.validateBuild();
        return Hawk.HAWK.storage.remove(keys);
    }

    public static boolean contains(String key) {
        HawkUtils.validateBuild();
        return Hawk.HAWK.storage.contains(key);
    }

    public static boolean resetCrypto() {
        HawkUtils.validateBuild();
        return Hawk.HAWK.encryption.reset();
    }

    public static LogLevel getLogLevel() {
        if (HAWK == null) {
            return LogLevel.NONE;
        }
        return Hawk.HAWK.logLevel;
    }

    public static boolean isBuilt() {
        return HAWK != null;
    }

    private static <T> String zip(T value) {
        HawkUtils.checkNull("Value", value);
        byte[] encodedValue = Hawk.HAWK.encoder.encode(value);
        if (encodedValue == null || encodedValue.length == 0) {
            return null;
        }
        String cipherText = Hawk.HAWK.encryption.encrypt(encodedValue);
        if (cipherText == null) {
            return null;
        }
        return DataHelper.addType(cipherText, value);
    }

    public static void destroy() {
        HAWK = null;
    }

    public static class Chain {
        private final List<Pair<String, ?>> items;

        public Chain() {
            this(10);
        }

        public Chain(int capacity) {
            this.items = new ArrayList(capacity);
        }

        public <T> Chain put(String key, T value) {
            HawkUtils.checkNullOrEmpty("Key", key);
            HawkUtils.validateBuild();
            String encodedText = Hawk.zip(value);
            if (encodedText == null) {
                Log.d((String)"HAWK", (String)("Key : " + key + " is not added, encryption failed"));
                return this;
            }
            this.items.add(new Pair((Object)key, (Object)encodedText));
            return this;
        }

        public boolean commit() {
            return HAWK.storage.put(this.items);
        }
    }
}

