/*
 * Decompiled with CFR 0.152.
 */
package com.orhanobut.hawk;

import android.util.Log;
import com.orhanobut.hawk.Hawk;
import com.orhanobut.hawk.LogLevel;

final class Logger {
    private static final int CHUNK_SIZE = 4000;
    private static final String TAG = "Hawk";

    static void d(String message) {
        Logger.log(3, message, null);
    }

    static void e(String message) {
        Logger.log(6, message, null);
    }

    static void e(String message, Throwable throwable) {
        Logger.log(6, message, throwable);
    }

    static void w(String message) {
        Logger.log(5, message, null);
    }

    static void i(String message) {
        Logger.log(4, message, null);
    }

    static void v(String message) {
        Logger.log(2, message, null);
    }

    static void wtf(String message) {
        Logger.log(7, message, null);
    }

    private Logger() {
    }

    private static void log(int logType, String message, Throwable throwable) {
        LogLevel logLevel = Hawk.getLogLevel();
        if (logLevel == LogLevel.NONE) {
            return;
        }
        int length = message.length();
        if (length <= 4000) {
            Logger.logChunk(logType, message, throwable);
            return;
        }
        for (int i = 0; i < length; i += 4000) {
            int end = Math.min(length, i + 4000);
            Logger.logChunk(logType, message.substring(i, end), throwable);
        }
    }

    private static void logChunk(int logType, String chunk, Throwable throwable) {
        switch (logType) {
            case 6: {
                Log.e((String)TAG, (String)chunk, (Throwable)throwable);
                break;
            }
            case 4: {
                Log.i((String)TAG, (String)chunk);
                break;
            }
            case 2: {
                Log.v((String)TAG, (String)chunk);
                break;
            }
            case 5: {
                Log.w((String)TAG, (String)chunk);
                break;
            }
            case 7: {
                Log.wtf((String)TAG, (String)chunk);
                break;
            }
            default: {
                Log.d((String)TAG, (String)chunk);
            }
        }
    }
}

