/*
 * Decompiled with CFR 0.152.
 */
package com.orhanobut.hawk;

import android.text.TextUtils;
import android.util.Base64;
import com.orhanobut.hawk.DataInfo;
import com.orhanobut.hawk.DataType;
import com.orhanobut.hawk.Logger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class DataHelper {
    private static final String DELIMITER = "@";
    private static final String INFO_DELIMITER = "#";
    private static final char NEW_VERSION = 'V';
    @Deprecated
    private static final char FLAG_SERIALIZABLE = '1';
    private static final Map<Character, DataType> typeMap = new HashMap<Character, DataType>();

    private DataHelper() {
    }

    static DataInfo getDataInfo(String storedText) {
        if (TextUtils.isEmpty((CharSequence)storedText)) {
            throw new NullPointerException("Text should not be null or empty");
        }
        int index = storedText.indexOf(DELIMITER);
        if (index == -1) {
            throw new IllegalArgumentException("Text should contain delimiter");
        }
        String text = storedText.substring(0, index);
        String cipherText = storedText.substring(index + 1);
        if (TextUtils.isEmpty((CharSequence)text) || TextUtils.isEmpty((CharSequence)cipherText)) {
            throw new IllegalArgumentException("Invalid stored text");
        }
        char firstChar = text.charAt(text.length() - 1);
        if (firstChar == 'V') {
            return DataHelper.getNewDataInfo(text, cipherText);
        }
        return DataHelper.getOldDataInfo(text, cipherText);
    }

    static DataInfo getNewDataInfo(String text, String cipherText) {
        String[] infos = text.split(INFO_DELIMITER);
        char type = infos[2].charAt(0);
        DataType dataType = typeMap.get(Character.valueOf(type));
        Class<?> keyClazz = null;
        if (!TextUtils.isEmpty((CharSequence)infos[0])) {
            try {
                keyClazz = Class.forName(infos[0]);
            }
            catch (ClassNotFoundException e) {
                Logger.d(e.getMessage());
            }
        }
        Class<?> valueClazz = null;
        if (!TextUtils.isEmpty((CharSequence)infos[1])) {
            try {
                valueClazz = Class.forName(infos[1]);
            }
            catch (ClassNotFoundException e) {
                Logger.d(e.getMessage());
            }
        }
        return new DataInfo(dataType, cipherText, keyClazz, valueClazz);
    }

    @Deprecated
    static DataInfo getOldDataInfo(String text, String cipherText) {
        boolean serializable = text.charAt(text.length() - 1) == '1';
        char type = text.charAt(text.length() - 2);
        DataType dataType = typeMap.get(Character.valueOf(type));
        String className = text.substring(0, text.length() - 2);
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            Logger.d(e.getMessage());
        }
        return new DataInfo(dataType, serializable, cipherText, clazz);
    }

    static <T> String addType(String cipherText, T t) {
        DataType dataType;
        if (TextUtils.isEmpty((CharSequence)cipherText)) {
            throw new NullPointerException("Cipher text should not be null or empty");
        }
        if (t == null) {
            throw new NullPointerException("Value should not be null");
        }
        String keyClassName = "";
        String valueClassName = "";
        if (List.class.isAssignableFrom(t.getClass())) {
            List list = (List)t;
            if (!list.isEmpty()) {
                keyClassName = list.get(0).getClass().getName();
            }
            dataType = DataType.LIST;
        } else if (Map.class.isAssignableFrom(t.getClass())) {
            Iterator iterator;
            dataType = DataType.MAP;
            Map map = (Map)t;
            if (!map.isEmpty() && (iterator = map.entrySet().iterator()).hasNext()) {
                Map.Entry entry = iterator.next();
                keyClassName = entry.getKey().getClass().getName();
                valueClassName = entry.getValue().getClass().getName();
            }
        } else if (Set.class.isAssignableFrom(t.getClass())) {
            Iterator iterator;
            Set set = (Set)t;
            if (!set.isEmpty() && (iterator = set.iterator()).hasNext()) {
                keyClassName = iterator.next().getClass().getName();
            }
            dataType = DataType.SET;
        } else {
            dataType = DataType.OBJECT;
            keyClassName = t.getClass().getName();
        }
        return keyClassName + INFO_DELIMITER + valueClassName + INFO_DELIMITER + dataType.getType() + 'V' + DELIMITER + cipherText;
    }

    static String encodeBase64(byte[] bytes) {
        try {
            return Base64.encodeToString((byte[])bytes, (int)0);
        }
        catch (Exception e) {
            Logger.w(e.getMessage());
            return null;
        }
    }

    static byte[] decodeBase64(String value) {
        try {
            return Base64.decode((String)value, (int)0);
        }
        catch (Exception e) {
            Logger.w(e.getMessage());
            return null;
        }
    }

    static {
        typeMap.put(Character.valueOf(DataType.OBJECT.getType()), DataType.OBJECT);
        typeMap.put(Character.valueOf(DataType.LIST.getType()), DataType.LIST);
        typeMap.put(Character.valueOf(DataType.MAP.getType()), DataType.MAP);
        typeMap.put(Character.valueOf(DataType.SET.getType()), DataType.SET);
    }
}

