/*
 * Decompiled with CFR 0.152.
 */
package com.orhanobut.hawk;

import android.text.TextUtils;
import com.orhanobut.hawk.AesCbcWithIntegrity;
import com.orhanobut.hawk.Encryption;
import com.orhanobut.hawk.Logger;
import com.orhanobut.hawk.Storage;
import java.security.GeneralSecurityException;

final class AesEncryption
implements Encryption {
    private static final String KEY_STORAGE_SALT = "asdf3242klj";
    private static final String KEY_GENERATED_SECRET_KEYS = "adsfjlkj234234dasfgenasdfas";
    private final String password;
    private final Storage storage;
    private AesCbcWithIntegrity.SecretKeys key;
    private String saltKey;

    AesEncryption(Storage storage, String password) {
        this.storage = storage;
        this.password = password;
    }

    @Override
    public boolean init() {
        this.saltKey = (String)this.storage.get(KEY_STORAGE_SALT);
        this.key = this.generateSecretKey(this.password);
        return this.key != null;
    }

    @Override
    public String encrypt(byte[] value) {
        if (value == null) {
            return null;
        }
        String result = null;
        try {
            AesCbcWithIntegrity.CipherTextIvMac civ = AesCbcWithIntegrity.encrypt(value, this.key);
            result = civ.toString();
        }
        catch (GeneralSecurityException e) {
            Logger.d(e.getMessage());
        }
        return result;
    }

    @Override
    public byte[] decrypt(String value) {
        if (value == null) {
            return null;
        }
        byte[] result = null;
        try {
            AesCbcWithIntegrity.CipherTextIvMac civ = this.getCipherTextIvMac(value);
            result = AesCbcWithIntegrity.decrypt(civ, this.key);
        }
        catch (GeneralSecurityException e) {
            Logger.d(e.getMessage());
        }
        return result;
    }

    @Override
    public boolean reset() {
        return this.storage.clear();
    }

    private AesCbcWithIntegrity.CipherTextIvMac getCipherTextIvMac(String cipherText) {
        return new AesCbcWithIntegrity.CipherTextIvMac(cipherText);
    }

    private AesCbcWithIntegrity.SecretKeys generateSecretKey(String password) {
        if (password == null || this.storage.contains(KEY_GENERATED_SECRET_KEYS)) {
            return this.getSecretKeysWithoutPassword();
        }
        AesCbcWithIntegrity.SecretKeys key = this.generateSecretKeyFromPassword(password);
        if (key == null) {
            key = this.getSecretKeysWithoutPassword();
        } else {
            Logger.w("key is generated from password");
        }
        return key;
    }

    private AesCbcWithIntegrity.SecretKeys getSecretKeysWithoutPassword() {
        Logger.w("key is generating without password");
        try {
            AesCbcWithIntegrity.SecretKeys key = null;
            String keys = (String)this.storage.get(KEY_GENERATED_SECRET_KEYS);
            if (keys != null) {
                try {
                    key = AesCbcWithIntegrity.keys(keys);
                }
                catch (Exception e) {
                    key = null;
                    Logger.i("keys was not correct value, it is reset");
                }
            }
            if (key == null) {
                key = AesCbcWithIntegrity.generateKey();
                String parsed = key.toString();
                this.storage.put(KEY_GENERATED_SECRET_KEYS, parsed);
            }
            Logger.w("key is generated without password");
            return key;
        }
        catch (GeneralSecurityException e) {
            Logger.e(e.getMessage());
            return null;
        }
        catch (Exception e) {
            Logger.e(e.getMessage());
            return null;
        }
    }

    private AesCbcWithIntegrity.SecretKeys generateSecretKeyFromPassword(String password) {
        try {
            if (TextUtils.isEmpty((CharSequence)this.saltKey)) {
                this.saltKey = AesCbcWithIntegrity.saltString(AesCbcWithIntegrity.generateSalt());
                this.storage.put(KEY_STORAGE_SALT, this.saltKey);
            }
            return AesCbcWithIntegrity.generateKeyFromPassword(password, this.saltKey);
        }
        catch (GeneralSecurityException e) {
            Logger.e(e.getMessage());
            return null;
        }
    }
}

