/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.query;

import com.google.common.base.Joiner;
import com.nedap.archie.adlparser.antlr.XPathLexer;
import com.nedap.archie.adlparser.antlr.XPathParser;
import com.nedap.archie.paths.PathSegment;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;

public class APathQuery {
    private List<PathSegment> pathSegments = new ArrayList<PathSegment>();

    public APathQuery(String query) {
        if (!query.equals("/")) {
            XPathLexer lexer = new XPathLexer((CharStream)new ANTLRInputStream(query));
            XPathParser parser = new XPathParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
            XPathParser.LocationPathContext locationPathContext = parser.locationPath();
            XPathParser.AbsoluteLocationPathNorootContext absoluteLocationPathNorootContext = locationPathContext.absoluteLocationPathNoroot();
            if (absoluteLocationPathNorootContext == null) {
                throw new UnsupportedOperationException("relative xpath expressions not yet supported: " + query);
            }
            if (!absoluteLocationPathNorootContext.getTokens(16).isEmpty()) {
                throw new UnsupportedOperationException("absolute path starting with // not yet supported");
            }
            XPathParser.RelativeLocationPathContext relativeLocationPathContext = absoluteLocationPathNorootContext.relativeLocationPath();
            if (!relativeLocationPathContext.getTokens(16).isEmpty()) {
                throw new UnsupportedOperationException("relative path with // between steps not yet supported");
            }
            Pattern isDigit = Pattern.compile("\\d+");
            List stepContexts = relativeLocationPathContext.step();
            for (XPathParser.StepContext stepContext : stepContexts) {
                String nodeName = stepContext.nodeTest().getText();
                List predicateContexts = stepContext.predicate();
                PathSegment pathSegment = new PathSegment(nodeName);
                for (XPathParser.PredicateContext predicateContext : predicateContexts) {
                    XPathParser.AndExprContext andExpressionContext = predicateContext.expr().orExpr().andExpr(0);
                    for (XPathParser.EqualityExprContext equalityExprContext : andExpressionContext.equalityExpr()) {
                        if (equalityExprContext.relationalExpr().size() != 1) continue;
                        String expression = equalityExprContext.getText();
                        if (isDigit.matcher(expression).matches()) {
                            pathSegment.setIndex(Integer.parseInt(expression));
                            continue;
                        }
                        if (expression.matches("\".*\"") || expression.matches("'.*'")) {
                            pathSegment.setNodeId(expression.substring(1, expression.length() - 1));
                            continue;
                        }
                        pathSegment.setNodeId(expression);
                    }
                }
                this.pathSegments.add(pathSegment);
            }
        }
    }

    public List<PathSegment> getPathSegments() {
        return this.pathSegments;
    }

    public String toString() {
        if (this.pathSegments.size() == 0) {
            return "/";
        }
        return Joiner.on((String)"").join(this.pathSegments);
    }
}

