/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rules.evaluation.evaluators;

import com.google.common.collect.Lists;
import com.nedap.archie.rules.Expression;
import com.nedap.archie.rules.OperatorKind;
import com.nedap.archie.rules.PrimitiveType;
import com.nedap.archie.rules.RuleElement;
import com.nedap.archie.rules.UnaryOperator;
import com.nedap.archie.rules.evaluation.Evaluator;
import com.nedap.archie.rules.evaluation.RuleEvaluation;
import com.nedap.archie.rules.evaluation.Value;
import com.nedap.archie.rules.evaluation.ValueList;
import java.util.List;

public class UnaryOperatorEvaluator
implements Evaluator<UnaryOperator> {
    @Override
    public ValueList evaluate(RuleEvaluation evaluation, UnaryOperator statement) {
        OperatorKind operator = statement.getOperator();
        Expression operand = statement.getOperand();
        switch (operator) {
            case not: {
                return this.handleNot(evaluation, statement);
            }
            case exists: {
                return this.handleExists(evaluation, statement);
            }
            case minus: {
                return this.handleMinus(evaluation, statement);
            }
        }
        throw new UnsupportedOperationException("not yet supported " + operator);
    }

    private ValueList handleMinus(RuleEvaluation evaluation, UnaryOperator statement) {
        ValueList valueList = evaluation.evaluate((RuleElement)statement.getOperand());
        if (valueList.getType() == PrimitiveType.Integer || valueList.getType() == PrimitiveType.Real) {
            ValueList result = new ValueList();
            for (Value value : valueList.getValues()) {
                Value<Number> negatedValue = null;
                if (value.getValue() instanceof Integer) {
                    negatedValue = new Value<Integer>(-((Integer)value.getValue()).intValue(), value.getPaths());
                } else if (value.getValue() instanceof Long) {
                    negatedValue = new Value<Long>(-((Long)value.getValue()).longValue(), value.getPaths());
                } else if (value.getValue() instanceof Double) {
                    negatedValue = new Value<Double>(-((Double)value.getValue()).doubleValue(), value.getPaths());
                } else if (value.getValue() instanceof Float) {
                    negatedValue = new Value<Float>(Float.valueOf(-((Float)value.getValue()).floatValue()), value.getPaths());
                }
                result.addValue(negatedValue);
            }
            return result;
        }
        throw new IllegalArgumentException("Unary Minus Operator only works on arithmetic expression, but " + valueList + " was supplied");
    }

    private ValueList handleExists(RuleEvaluation evaluation, UnaryOperator statement) {
        ValueList value = evaluation.evaluate((RuleElement)statement.getOperand());
        if (value.isEmpty() || value.containsOnlyNullValues()) {
            return new ValueList((Object)false, value.getAllPaths());
        }
        return new ValueList((Object)true, value.getAllPaths());
    }

    public ValueList handleNot(RuleEvaluation evaluation, UnaryOperator statement) {
        Expression operand = statement.getOperand();
        ValueList input = evaluation.evaluate((RuleElement)operand);
        List<Value> values = input.getValues();
        ValueList result = new ValueList();
        result.setType(PrimitiveType.Boolean);
        for (Value value : values) {
            if (value == null) {
                values.add(null);
                continue;
            }
            if (value.getValue() instanceof Boolean) {
                result.addValue((Boolean)value.getValue() == false, value.getPaths());
                continue;
            }
            throw new IllegalStateException("Not operator only works on boolean, but " + value + " was supplied");
        }
        return result;
    }

    @Override
    public List<Class> getSupportedClasses() {
        return Lists.newArrayList((Object[])new Class[]{UnaryOperator.class});
    }
}

