/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.query;

import com.google.common.collect.ImmutableSet;
import com.nedap.archie.adlparser.antlr.XPathLexer;
import com.nedap.archie.adlparser.antlr.XPathParser;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

public class APathToXPathConverter {
    private static Pattern idCodePattern = Pattern.compile("id(\\d|\\.\\d)+");
    private static Pattern numberPattern = Pattern.compile("\\d+");
    private static Set<String> literalsThatShouldHaveSpacing = new ImmutableSet.Builder().add(new Object[]{"and", "or", ",", "-", "+", "*", "|", "<", ">", "<=", ">="}).build();

    public static String convertQueryToXPath(String query, String firstNodeName) {
        String convertedQuery = APathToXPathConverter.convertWithAntlr(query);
        if (convertedQuery.equals("/")) {
            return "/" + firstNodeName;
        }
        if (query.startsWith("//")) {
            return convertedQuery;
        }
        if (query.startsWith("/")) {
            return "/" + firstNodeName + convertedQuery;
        }
        return convertedQuery;
    }

    public static String convertWithAntlr(String query) {
        XPathLexer lexer = new XPathLexer((CharStream)CharStreams.fromString((String)query));
        XPathParser parser = new XPathParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        XPathParser.MainContext mainCtx = parser.main();
        StringBuilder output = new StringBuilder();
        APathToXPathConverter.writeTree(output, (ParseTree)mainCtx, false);
        return output.toString();
    }

    private static void writeTree(StringBuilder output, ParseTree tree, boolean inPredicate) {
        for (int i = 0; i < tree.getChildCount(); ++i) {
            ParseTree child = tree.getChild(i);
            if (child instanceof TerminalNode) {
                boolean shouldAppendSpace = literalsThatShouldHaveSpacing.contains(child.getText().toLowerCase());
                if (shouldAppendSpace) {
                    output.append(" ");
                }
                output.append(child.getText());
                if (!shouldAppendSpace) continue;
                output.append(" ");
                continue;
            }
            if (child instanceof XPathParser.AndExprContext) {
                for (int j = 0; j < child.getChildCount(); ++j) {
                    ParseTree andChild = child.getChild(j);
                    if (andChild instanceof TerminalNode) {
                        output.append(" and ");
                        continue;
                    }
                    APathToXPathConverter.writeTree(output, andChild, inPredicate);
                }
                continue;
            }
            if (child instanceof XPathParser.PredicateContext) {
                APathToXPathConverter.writeTree(output, child, true);
                continue;
            }
            if (inPredicate && child instanceof XPathParser.RelativeLocationPathContext) {
                Matcher idCodeMatcher = idCodePattern.matcher(child.getText());
                if (idCodeMatcher.matches()) {
                    output.append("@archetype_node_id = '");
                    output.append(child.getText());
                    output.append("'");
                    continue;
                }
                APathToXPathConverter.writeTree(output, child, inPredicate);
                continue;
            }
            if (inPredicate && child instanceof XPathParser.FilterExprContext) {
                XPathParser.FilterExprContext filterExprContext = (XPathParser.FilterExprContext)child;
                Matcher numberMatcher = numberPattern.matcher(child.getText());
                if (numberMatcher.matches()) {
                    output.append("position() = ");
                    output.append(child.getText());
                    continue;
                }
                if (filterExprContext.primaryExpr().Literal() != null) {
                    output.append("name/value = ");
                    output.append(child.getText());
                    continue;
                }
                APathToXPathConverter.writeTree(output, child, inPredicate);
                continue;
            }
            APathToXPathConverter.writeTree(output, child, inPredicate);
        }
    }
}

