/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.json.flat;

import com.nedap.archie.base.OpenEHRBase;
import com.nedap.archie.datetime.DateTimeSerializerFormatters;
import com.nedap.archie.json.flat.DuplicateKeyException;
import com.nedap.archie.json.flat.FlatJsonFormatConfiguration;
import com.nedap.archie.json.flat.IndexNotation;
import com.nedap.archie.rminfo.ModelInfoLookup;
import com.nedap.archie.rminfo.RMAttributeInfo;
import com.nedap.archie.rminfo.RMTypeInfo;
import java.lang.reflect.InvocationTargetException;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAmount;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class FlatJsonGenerator {
    private final ModelInfoLookup modelInfoLookup;
    private final List<IgnoredAttribute> ignoredAttributes;
    private final boolean writePipesForPrimitiveTypes;
    private final boolean humanReadableFormat;
    private final IndexNotation indexNotation;
    private final String typeIdPropertyName;

    public FlatJsonGenerator(ModelInfoLookup modelInfoLookup, FlatJsonFormatConfiguration config) {
        this.modelInfoLookup = modelInfoLookup;
        this.writePipesForPrimitiveTypes = config.isWritePipesForPrimitiveTypes();
        this.humanReadableFormat = false;
        this.indexNotation = config.getIndexNotation();
        this.typeIdPropertyName = config.getTypeIdPropertyName();
        this.ignoredAttributes = config.getIgnoredAttributes().stream().map(a -> new IgnoredAttribute(modelInfoLookup.getTypeInfo(a.getTypeName()), a.getAttributeName())).collect(Collectors.toList());
    }

    public Map<String, Object> buildPathsAndValues(OpenEHRBase rmObject) throws DuplicateKeyException {
        String rootName;
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        this.buildPathsAndValuesInner(result, null, "/", rmObject);
        if (this.humanReadableFormat && (rootName = this.modelInfoLookup.getNameFromRMObject((Object)rmObject)) != null) {
            LinkedHashMap<String, Object> humanReadableResult = new LinkedHashMap<String, Object>();
            result.forEach((key, value) -> humanReadableResult.put(this.addUnderScores(rootName) + key, value));
            return humanReadableResult;
        }
        return result;
    }

    private void buildPathsAndValuesInner(Map<String, Object> result, RMTypeInfo rmAttributeTypeInfo, String pathSoFar, OpenEHRBase rmObject) throws DuplicateKeyException {
        if (rmObject == null) {
            return;
        }
        RMTypeInfo typeInfo = this.modelInfoLookup.getTypeInfo(rmObject.getClass());
        if (pathSoFar.equalsIgnoreCase("/") || this.typeHasDescendants(rmAttributeTypeInfo) && !this.sameType(rmAttributeTypeInfo, rmObject)) {
            this.storeValue(result, this.joinPath(pathSoFar, this.typeIdPropertyName, null, null, "/"), this.getTypeIdFromValue(rmObject));
        }
        for (String attributeName : typeInfo.getAttributes().keySet()) {
            RMAttributeInfo attributeInfo = (RMAttributeInfo)typeInfo.getAttributes().get(attributeName);
            if (attributeInfo.isComputed() || this.isIgnored(typeInfo, attributeName) || attributeInfo.getGetMethod() == null) continue;
            try {
                Object child = attributeInfo.getGetMethod().invoke((Object)rmObject, new Object[0]);
                this.addAttribute(result, pathSoFar, rmObject, child, attributeName, null);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void storeValue(Map<String, Object> result, String path, Object value) throws DuplicateKeyException {
        if (result.containsKey(path)) {
            throw new DuplicateKeyException("cannot add path twice: " + path + " with exis. value " + result.get(path) + " new value " + value);
        }
        result.put(path, value);
    }

    private boolean isIgnored(RMTypeInfo typeInfo, String attributeName) {
        return this.ignoredAttributes.stream().filter(ignored -> typeInfo.isDescendantOrEqual(ignored.getType()) && attributeName.equalsIgnoreCase(ignored.getAttributeName())).findAny().isPresent();
    }

    private Object getTypeIdFromValue(OpenEHRBase value) {
        RMTypeInfo typeInfo = this.modelInfoLookup.getTypeInfo(value.getClass());
        if (typeInfo != null) {
            return typeInfo.getRmName();
        }
        return this.modelInfoLookup.getNamingStrategy().getTypeName(value.getClass());
    }

    private boolean sameType(RMTypeInfo typeInfo, OpenEHRBase rmObject) {
        if (rmObject == null) {
            return false;
        }
        return this.modelInfoLookup.getTypeInfo(rmObject.getClass()).equals((Object)typeInfo);
    }

    private boolean typeHasDescendants(RMTypeInfo typeInfo) {
        if (typeInfo == null) {
            return true;
        }
        return !typeInfo.getDirectDescendantClasses().isEmpty();
    }

    private void addAttribute(Map<String, Object> result, String pathSoFar, OpenEHRBase parent, Object child, String attributeName, Integer index) throws DuplicateKeyException {
        if (child instanceof OpenEHRBase) {
            String newPath = this.joinPath(pathSoFar, attributeName, (OpenEHRBase)child, index, "/");
            RMAttributeInfo attributeInfo = this.modelInfoLookup.getAttributeInfo(parent.getClass(), attributeName);
            RMTypeInfo typeInfo = this.getAttributeTypeInfo(attributeInfo);
            this.buildPathsAndValuesInner(result, typeInfo, newPath, (OpenEHRBase)child);
            String archetypeId = this.modelInfoLookup.getArchetypeIdFromArchetypedRmObject(child);
            if (archetypeId != null) {
                this.storeValue(result, newPath, archetypeId);
            }
        } else if (child instanceof Collection) {
            HashMap<String, Integer> amountsPerNodeId = new HashMap<String, Integer>();
            for (Object c : (Collection)child) {
                int numberOfNonLocatables = 1;
                String archetypeNodeId = this.modelInfoLookup.getArchetypeNodeIdFromRMObject(c);
                if (archetypeNodeId != null) {
                    Integer numberOfPreviousOccurrences = (Integer)amountsPerNodeId.get(archetypeNodeId);
                    this.addAttribute(result, pathSoFar, parent, c, attributeName, numberOfPreviousOccurrences);
                    numberOfPreviousOccurrences = numberOfPreviousOccurrences == null ? 1 : numberOfPreviousOccurrences + 1;
                    amountsPerNodeId.put(archetypeNodeId, numberOfPreviousOccurrences);
                    continue;
                }
                this.addAttribute(result, pathSoFar, parent, c, attributeName, numberOfNonLocatables == 1 ? null : Integer.valueOf(numberOfNonLocatables));
                ++numberOfNonLocatables;
            }
        } else if (child != null) {
            String newPath = this.joinPath(pathSoFar, attributeName, null, index, this.writePipesForPrimitiveTypes ? "|" : "/");
            if (child instanceof Number) {
                this.storeValue(result, newPath, child);
            } else if (child instanceof TemporalAccessor) {
                Temporal t = (Temporal)child;
                boolean hoursSupported = t.isSupported(ChronoUnit.HOURS);
                boolean monthsSupported = t.isSupported(ChronoUnit.MONTHS);
                if (hoursSupported && monthsSupported) {
                    this.storeValue(result, newPath, DateTimeSerializerFormatters.ISO_8601_DATE_TIME.format(t));
                } else if (monthsSupported) {
                    this.storeValue(result, newPath, DateTimeSerializerFormatters.ISO_8601_DATE.format(t));
                } else if (hoursSupported) {
                    this.storeValue(result, newPath, DateTimeSerializerFormatters.ISO_8601_TIME.format(t));
                }
            } else if (child instanceof TemporalAmount) {
                this.storeValue(result, newPath, child);
            } else {
                this.storeValue(result, newPath, child.toString());
            }
        }
    }

    private RMTypeInfo getAttributeTypeInfo(RMAttributeInfo attributeInfo) {
        RMTypeInfo typeInfo = null;
        if (attributeInfo != null) {
            typeInfo = this.modelInfoLookup.getTypeInfo(attributeInfo.getTypeInCollection());
        }
        return typeInfo;
    }

    private String joinPath(String pathSoFar, String attributeName, OpenEHRBase rmObject, Integer index, String pathSeparator) {
        String name = this.modelInfoLookup.getNameFromRMObject((Object)rmObject);
        boolean wroteHumanReadableName = name != null && this.humanReadableFormat;
        String newPathSegment = wroteHumanReadableName ? this.addUnderScores(name) : attributeName;
        String nodeId = this.modelInfoLookup.getArchetypeNodeIdFromRMObject((Object)rmObject);
        if (nodeId != null && !wroteHumanReadableName) {
            if (this.indexNotation == IndexNotation.AFTER_A_COLON) {
                newPathSegment = newPathSegment + "[" + nodeId + "]";
                if (index != null) {
                    newPathSegment = newPathSegment + ":" + index;
                }
            } else {
                newPathSegment = index == null ? newPathSegment + "[" + nodeId + "]" : newPathSegment + "[" + nodeId + "," + index + "]";
            }
        } else if (index != null) {
            newPathSegment = this.indexNotation == IndexNotation.AFTER_A_COLON ? newPathSegment + ":" + index : newPathSegment + "[" + index + "]";
        }
        if (pathSoFar.endsWith("/")) {
            return pathSoFar + newPathSegment;
        }
        return pathSoFar + pathSeparator + newPathSegment;
    }

    private String addUnderScores(String name) {
        if (name == null) {
            return null;
        }
        return name.replaceAll("[^a-zA-Z0-9]", "_");
    }

    private class IgnoredAttribute {
        private RMTypeInfo type;
        private String attributeName;

        public IgnoredAttribute(RMTypeInfo type, String attributeName) {
            this.type = type;
            this.attributeName = attributeName;
        }

        public RMTypeInfo getType() {
            return this.type;
        }

        public void setType(RMTypeInfo type) {
            this.type = type;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }
    }
}

