/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.flattener;

import com.nedap.archie.aom.Archetype;
import com.nedap.archie.aom.OperationalTemplate;
import com.nedap.archie.archetypevalidator.ArchetypeValidationSettings;
import com.nedap.archie.archetypevalidator.ArchetypeValidator;
import com.nedap.archie.archetypevalidator.ValidationResult;
import com.nedap.archie.flattener.ArchetypeRepository;
import com.nedap.archie.rminfo.MetaModels;
import com.nedap.archie.rminfo.ReferenceModels;
import java.util.List;

public interface FullArchetypeRepository
extends ArchetypeRepository {
    public Archetype getFlattenedArchetype(String var1);

    public ValidationResult getValidationResult(String var1);

    public OperationalTemplate getOperationalTemplate(String var1);

    public void setValidationResult(ValidationResult var1);

    public void setFlattenedArchetype(Archetype var1);

    public void setOperationalTemplate(OperationalTemplate var1);

    public void removeValidationResult(String var1);

    public List<ValidationResult> getAllValidationResults();

    public ArchetypeValidationSettings getArchetypeValidationSettings();

    default public void compile(ReferenceModels models) {
        ArchetypeValidator validator = new ArchetypeValidator(models);
        this.compile(validator);
    }

    default public void compile(MetaModels models) {
        ArchetypeValidator validator = new ArchetypeValidator(models);
        this.compile(validator);
    }

    default public ValidationResult compileAndRetrieveValidationResult(String archetypeId, MetaModels models) {
        ValidationResult validationResult = this.getValidationResult(archetypeId);
        if (validationResult != null) {
            return validationResult;
        }
        Archetype archetype = this.getArchetype(archetypeId);
        if (archetype == null) {
            return null;
        }
        ArchetypeValidator validator = new ArchetypeValidator(models);
        return validator.validate(archetype, this);
    }

    default public void compile(ArchetypeValidator validator) {
        for (Archetype archetype : this.getAllArchetypes()) {
            if (this.getValidationResult(archetype.getArchetypeId().toString()) != null) continue;
            validator.validate(archetype, this);
        }
    }
}

