/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.flattener;

import com.nedap.archie.adlparser.modelconstraints.ReflectionConstraintImposer;
import com.nedap.archie.aom.Archetype;
import com.nedap.archie.aom.ArchetypeSlot;
import com.nedap.archie.aom.CArchetypeRoot;
import com.nedap.archie.aom.CAttribute;
import com.nedap.archie.aom.CAttributeTuple;
import com.nedap.archie.aom.CComplexObject;
import com.nedap.archie.aom.CComplexObjectProxy;
import com.nedap.archie.aom.CObject;
import com.nedap.archie.aom.OperationalTemplate;
import com.nedap.archie.aom.ResourceDescription;
import com.nedap.archie.aom.Template;
import com.nedap.archie.aom.TemplateOverlay;
import com.nedap.archie.aom.utils.ArchetypeParsePostProcesser;
import com.nedap.archie.flattener.AnnotationsFlattener;
import com.nedap.archie.flattener.ArchetypeRepository;
import com.nedap.archie.flattener.CAttributeFlattener;
import com.nedap.archie.flattener.FlattenerConfiguration;
import com.nedap.archie.flattener.FlattenerUtil;
import com.nedap.archie.flattener.IAttributeFlattenerSupport;
import com.nedap.archie.flattener.OperationalTemplateCreator;
import com.nedap.archie.flattener.OverridingArchetypeRepository;
import com.nedap.archie.flattener.RulesFlattener;
import com.nedap.archie.flattener.TerminologyFlattener;
import com.nedap.archie.flattener.TupleFlattener;
import com.nedap.archie.rminfo.MetaModelInterface;
import com.nedap.archie.rminfo.MetaModels;
import com.nedap.archie.rminfo.ReferenceModels;
import java.util.ArrayList;
import java.util.Stack;
import org.openehr.bmm.v2.validation.BmmRepository;

public class Flattener
implements IAttributeFlattenerSupport {
    private final MetaModels metaModels;
    private OverridingArchetypeRepository repository;
    private Archetype parent;
    private Archetype child;
    private Archetype result;
    private final FlattenerConfiguration config;
    private RulesFlattener rulesFlattener = new RulesFlattener();
    private AnnotationsFlattener annotationsFlattener = new AnnotationsFlattener();
    CAttributeFlattener cAttributeFlattener = new CAttributeFlattener(this);
    private TupleFlattener tupleFlattener = new TupleFlattener();
    private OperationalTemplateCreator optCreator = new OperationalTemplateCreator(this);

    public Flattener(ArchetypeRepository repository, ReferenceModels models) {
        this.repository = new OverridingArchetypeRepository(repository);
        this.metaModels = new MetaModels(models, (BmmRepository)null);
        this.config = FlattenerConfiguration.forFlattened();
    }

    public Flattener(ArchetypeRepository repository, MetaModels models) {
        this.repository = new OverridingArchetypeRepository(repository);
        this.metaModels = models;
        this.config = FlattenerConfiguration.forFlattened();
    }

    public Flattener(ArchetypeRepository repository, MetaModels models, FlattenerConfiguration configuration) {
        this.repository = new OverridingArchetypeRepository(repository);
        this.metaModels = models;
        this.config = configuration.clone();
    }

    public Flattener createOperationalTemplate(boolean makeTemplate) {
        this.config.setCreateOperationalTemplate(makeTemplate);
        if (makeTemplate) {
            this.config.setRemoveZeroOccurrencesObjects(true);
        }
        return this;
    }

    public Flattener removeZeroOccurrencesConstraints(boolean remove) {
        this.config.setRemoveZeroOccurrencesObjects(remove);
        return this;
    }

    public Flattener keepLanguages(String ... languages) {
        this.config.setLanguagesToKeep(languages);
        return this;
    }

    public Flattener removeLanguagesFromMetadata(boolean remove) {
        this.config.setRemoveLanguagesFromMetaData(remove);
        return this;
    }

    public Archetype flatten(Archetype toFlatten) {
        if (this.parent != null) {
            throw new IllegalStateException("You've used this flattener before - single use instance, please create a new one!");
        }
        this.metaModels.selectModel(toFlatten);
        String parentId = toFlatten.getParentArchetypeId();
        if (parentId == null) {
            if (this.config.isCreateOperationalTemplate()) {
                OperationalTemplate template = OperationalTemplateCreator.createOperationalTemplate(toFlatten);
                this.result = template;
                this.optCreator.fillSlots(template);
                this.fillOptEmptyOccurrences(this.result);
                TerminologyFlattener.filterLanguages(template, this.config.isRemoveLanguagesFromMetaData(), this.config.getLanguagesToKeep());
                this.result = template;
            } else {
                this.result = toFlatten.clone();
            }
            this.result.getDefinition().setArchetype(this.result);
            this.result.setDifferential(false);
            this.result.setGenerated(Boolean.valueOf(true));
            return this.result;
        }
        this.parent = this.repository.getArchetype(toFlatten.getParentArchetypeId());
        if (this.parent == null) {
            throw new IllegalArgumentException("parent archetype not found in repository: " + toFlatten.getParentArchetypeId());
        }
        this.child = toFlatten.clone();
        if (this.child instanceof Template) {
            Template childTemplate = (Template)this.child;
            for (TemplateOverlay overlay : childTemplate.getTemplateOverlays()) {
                this.repository.addExtraArchetype((Archetype)overlay);
            }
        }
        if (this.parent.getParentArchetypeId() != null) {
            this.parent = this.getNewFlattenerForParent().flatten(this.parent);
        }
        this.result = null;
        if (this.config.isCreateOperationalTemplate()) {
            this.result = OperationalTemplateCreator.createOperationalTemplate(this.parent);
            OperationalTemplateCreator.overrideArchetypeId(this.result, this.child);
        } else {
            this.result = this.child.clone();
            Archetype clonedParent = this.parent.clone();
            this.result.setDefinition(clonedParent.getDefinition());
            this.result.setTerminology(clonedParent.getTerminology());
            this.result.setRules(clonedParent.getRules());
        }
        new AnnotationsFlattener().flatten(this.parent, this.child, this.result);
        this.flattenDefinition(this.result, this.child);
        if (this.config.isCreateOperationalTemplate() && this.config.isRemoveZeroOccurrencesObjects()) {
            this.optCreator.removeZeroOccurrencesConstraints(this.result);
        } else {
            this.prohibitZeroOccurrencesConstraints(this.result);
        }
        String prefix = this.child.getArchetypeId().getConceptId() + "_";
        this.rulesFlattener.combineRules(this.child, this.result, prefix, "", "", true);
        if (this.config.isCreateOperationalTemplate()) {
            this.optCreator.fillSlots((OperationalTemplate)this.result);
        }
        this.fillOptEmptyOccurrences(this.result);
        TerminologyFlattener.flattenTerminology(this.result, this.child);
        if (this.config.isCreateOperationalTemplate()) {
            TerminologyFlattener.filterLanguages((OperationalTemplate)this.result, this.config.isRemoveLanguagesFromMetaData(), this.config.getLanguagesToKeep());
        }
        this.result.getDefinition().setArchetype(this.result);
        this.result.setDescription(this.child.getDescription());
        this.result.setOtherMetaData(this.child.getOtherMetaData());
        this.result.setBuildUid(this.child.getBuildUid());
        this.result.setOriginalLanguage(this.child.getOriginalLanguage());
        this.result.setTranslations(this.child.getTranslations());
        if (this.child instanceof Template && !this.config.isCreateOperationalTemplate()) {
            Template resultTemplate = (Template)this.result;
            resultTemplate.setTemplateOverlays(new ArrayList());
            Template childTemplate = (Template)this.child;
            for (TemplateOverlay overlay : ((Template)this.child).getTemplateOverlays()) {
                TemplateOverlay flatOverlay = (TemplateOverlay)this.getNewFlattener().flatten((Archetype)overlay);
                ResourceDescription description = (ResourceDescription)this.result.getDescription().clone();
                flatOverlay.setDescription(description);
                flatOverlay.setOriginalLanguage(this.result.getOriginalLanguage());
                flatOverlay.setTranslationList(this.result.getTranslationList());
                ArchetypeParsePostProcesser.fixArchetype((Archetype)flatOverlay);
                resultTemplate.getTemplateOverlays().add(flatOverlay);
            }
        }
        this.removeSiblingOrder(this.result);
        this.result.setDifferential(false);
        this.result.setGenerated(Boolean.valueOf(true));
        ArchetypeParsePostProcesser.fixArchetype((Archetype)this.result);
        new ReflectionConstraintImposer((MetaModelInterface)this.metaModels.getSelectedModel()).setSingleOrMultiple(this.result.getDefinition());
        return this.result;
    }

    private void fillOptEmptyOccurrences(Archetype result) {
        if (this.config.isCreateOperationalTemplate() && this.config.isFillEmptyOccurrences()) {
            this.optCreator.fillEmptyOccurrences(result);
        }
    }

    private void prohibitZeroOccurrencesConstraints(Archetype archetype) {
        Stack<Object> workList = new Stack<Object>();
        workList.push(archetype.getDefinition());
        while (!workList.isEmpty()) {
            CObject object = (CObject)workList.pop();
            for (CAttribute attribute : object.getAttributes()) {
                if (attribute.getExistence() != null && (Integer)attribute.getExistence().getUpper() == 0 && !attribute.getExistence().isUpperUnbounded()) {
                    attribute.setChildren(new ArrayList());
                    continue;
                }
                ArrayList<CObject> objectsToRemove = new ArrayList<CObject>();
                for (CObject child : attribute.getChildren()) {
                    if (!child.isAllowed()) {
                        if (child instanceof CComplexObject) {
                            ((CComplexObject)child).setAttributes(new ArrayList());
                        }
                        if (!this.config.isRemoveZeroOccurrencesObjects()) continue;
                        objectsToRemove.add(child);
                        continue;
                    }
                    workList.push(child);
                }
                attribute.getChildren().removeAll(objectsToRemove);
            }
        }
    }

    private void removeSiblingOrder(Archetype archetype) {
        Stack<Object> workList = new Stack<Object>();
        workList.push(archetype.getDefinition());
        while (!workList.isEmpty()) {
            CObject object = (CObject)workList.pop();
            for (CAttribute attribute : object.getAttributes()) {
                for (CObject child : attribute.getChildren()) {
                    workList.push(child);
                    if (child.getSiblingOrder() == null) continue;
                    child.setSiblingOrder(null);
                }
            }
        }
    }

    private void flattenDefinition(Archetype parent, Archetype specialized) {
        parent.setArchetypeId(specialized.getArchetypeId());
        this.createSpecializeCObject(null, (CObject)parent.getDefinition(), (CObject)specialized.getDefinition());
    }

    @Override
    public CObject createSpecializeCObject(CAttribute attribute, CObject parent, CObject specialized) {
        if (parent == null) {
            return specialized;
        }
        CObject newObject = this.cloneSpecializedObject(attribute, parent, specialized);
        this.specializeOccurrences(specialized, newObject);
        newObject.setSiblingOrder(FlattenerUtil.getPossiblyOverridenValue(newObject.getSiblingOrder(), specialized.getSiblingOrder()));
        newObject.setNodeId(FlattenerUtil.getPossiblyOverridenValue(newObject.getNodeId(), specialized.getNodeId()));
        newObject.setRmTypeName(FlattenerUtil.getPossiblyOverridenValue(newObject.getRmTypeName(), specialized.getRmTypeName()));
        this.specializeContent(parent, specialized, newObject);
        return newObject;
    }

    private void specializeContent(CObject parent, CObject specialized, CObject newObject) {
        if (parent instanceof CComplexObject) {
            if (!((CComplexObject)parent).isAnyAllowed() || !(specialized instanceof CComplexObjectProxy)) {
                if (!(specialized instanceof CComplexObject)) {
                    throw new IllegalArgumentException(String.format("cannot override complex object %s (%s) with non-complex object %s (%s)", parent.path(), parent.getClass().getSimpleName(), specialized.path(), specialized.getClass().getSimpleName()));
                }
                this.flattenCComplexObject((CComplexObject)newObject, (CComplexObject)specialized);
            }
        } else if (newObject instanceof ArchetypeSlot) {
            if (specialized instanceof ArchetypeSlot) {
                this.flattenArchetypeSlot((ArchetypeSlot)newObject, (ArchetypeSlot)specialized);
            } else if (!(specialized instanceof CArchetypeRoot)) {
                throw new IllegalArgumentException("Can only replace an archetype slot with an archetype root or another archetype slot, not with a " + newObject.getClass());
            }
        }
    }

    private void specializeOccurrences(CObject specialized, CObject newObject) {
        newObject.setOccurrences(FlattenerUtil.getPossiblyOverridenValue(newObject.getOccurrences(), specialized.getOccurrences()));
    }

    private CObject cloneSpecializedObject(CAttribute attribute, CObject parent, CObject specialized) {
        CObject newObject = attribute == null ? parent : (CObject)parent.clone();
        if (newObject instanceof ArchetypeSlot && specialized instanceof CArchetypeRoot) {
            newObject = (CObject)specialized.clone();
        }
        return newObject;
    }

    private void flattenArchetypeSlot(ArchetypeSlot parent, ArchetypeSlot specialized) {
        if (specialized.isClosed()) {
            parent.setClosed(true);
        }
        parent.setIncludes(FlattenerUtil.getPossiblyOverridenListValue(parent.getIncludes(), specialized.getIncludes()));
        parent.setExcludes(FlattenerUtil.getPossiblyOverridenListValue(parent.getExcludes(), specialized.getExcludes()));
    }

    private void flattenCComplexObject(CComplexObject newObject, CComplexObject specialized) {
        CArchetypeRoot specializedArchetypeRoot;
        if (specialized instanceof CArchetypeRoot && newObject instanceof CArchetypeRoot && (specializedArchetypeRoot = (CArchetypeRoot)specialized).getArchetypeRef() != null) {
            CArchetypeRoot newArchetypeRoot = (CArchetypeRoot)newObject;
            newArchetypeRoot.setArchetypeRef(specializedArchetypeRoot.getArchetypeRef());
        }
        for (CAttribute attribute : specialized.getAttributes()) {
            this.cAttributeFlattener.flattenSingleAttribute(newObject, attribute);
        }
        for (CAttributeTuple tuple : specialized.getAttributeTuples()) {
            this.tupleFlattener.flattenTuple(newObject, tuple);
        }
    }

    protected Flattener getNewFlattenerForParent() {
        Flattener result = new Flattener(this.repository, this.metaModels, this.config).createOperationalTemplate(false);
        if (this.config.isRemoveZeroOccurrencesInParents()) {
            result.removeZeroOccurrencesConstraints(true);
        }
        return result;
    }

    protected Flattener getNewFlattener() {
        return new Flattener(this.repository, this.metaModels, this.config).createOperationalTemplate(false);
    }

    private Flattener useComplexObjectForArchetypeSlotReplacement(boolean useComplexObjectForArchetypeSlotReplacement) {
        this.config.setUseComplexObjectForArchetypeSlotReplacement(useComplexObjectForArchetypeSlotReplacement);
        return this;
    }

    public boolean isUseComplexObjectForArchetypeSlotReplacement() {
        return this.config.isUseComplexObjectForArchetypeSlotReplacement();
    }

    @Override
    public MetaModels getMetaModels() {
        return this.metaModels;
    }

    public boolean getCreateOperationalTemplate() {
        return this.config.isCreateOperationalTemplate();
    }

    protected RulesFlattener getRulesFlattener() {
        return this.rulesFlattener;
    }

    protected AnnotationsFlattener getAnnotationsFlattener() {
        return this.annotationsFlattener;
    }

    public OverridingArchetypeRepository getRepository() {
        return this.repository;
    }

    FlattenerConfiguration getConfiguration() {
        return this.config;
    }
}

