/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.diff;

import com.nedap.archie.aom.CAttribute;
import com.nedap.archie.aom.CObject;
import com.nedap.archie.aom.SiblingOrder;
import com.nedap.archie.aom.utils.AOMUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DiffUtil {
    public static CObject findMatchingParentCObject(String specializedNodeId, List<CObject> parentCObjects) {
        for (CObject parentCObject : parentCObjects) {
            if (!specializedNodeId.equalsIgnoreCase(parentCObject.getNodeId())) continue;
            return parentCObject;
        }
        for (CObject parentCObject : parentCObjects) {
            if (!AOMUtils.isOverriddenIdCode((String)specializedNodeId, (String)parentCObject.getNodeId())) continue;
            return parentCObject;
        }
        return null;
    }

    public static CAttribute getMatchingAttribute(CObject result, CAttribute childAttribute) {
        if (result == null) {
            return null;
        }
        return result.getAttribute(childAttribute.getDifferentialPath() != null ? childAttribute.getDifferentialPath() : childAttribute.getRmAttributeName());
    }

    public static void addSiblingOrder(Map<SiblingOrder, List<CObject>> siblingOrders, SiblingOrder siblingOrder, CObject cObjectInResult) {
        List<CObject> cObjects = siblingOrders.get(siblingOrder);
        if (cObjects == null) {
            SiblingOrder existingSiblingOrder = DiffUtil.findSiblingOrder(siblingOrders, siblingOrder.getSiblingNodeId());
            if (existingSiblingOrder != null) {
                siblingOrders.get(existingSiblingOrder).add(cObjectInResult);
                return;
            }
            cObjects = new ArrayList<CObject>();
            siblingOrders.put(siblingOrder, cObjects);
        }
        cObjects.add(cObjectInResult);
    }

    public static void addOrderToAttribute(Map<SiblingOrder, List<CObject>> siblingOrders) {
        for (SiblingOrder order : siblingOrders.keySet()) {
            List<CObject> cObjects = siblingOrders.get(order);
            CObject first = cObjects.get(0);
            first.setSiblingOrder(order);
            CAttribute parent = first.getParent();
            List children = parent.getChildren();
            for (CObject cObject : cObjects) {
                int currentIndex = parent.getIndexOfMatchingCObjectChild(cObject);
                children.remove(currentIndex);
                children.add(cObject);
            }
        }
    }

    public static SiblingOrder findSiblingOrder(Map<SiblingOrder, List<CObject>> siblingOrders, String nodeId) {
        for (SiblingOrder key : siblingOrders.keySet()) {
            List<CObject> nodes = siblingOrders.get(key);
            if (!nodes.stream().filter(cObject -> cObject.getNodeId().equalsIgnoreCase(nodeId)).findAny().isPresent()) continue;
            return key;
        }
        return null;
    }
}

