/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.creation;

import com.nedap.archie.aom.Archetype;
import com.nedap.archie.aom.ArchetypeSlot;
import com.nedap.archie.aom.CArchetypeRoot;
import com.nedap.archie.aom.CAttribute;
import com.nedap.archie.aom.CComplexObject;
import com.nedap.archie.aom.CObject;
import com.nedap.archie.aom.CPrimitiveObject;
import com.nedap.archie.aom.OperationalTemplate;
import com.nedap.archie.aom.primitives.CBoolean;
import com.nedap.archie.aom.primitives.CDate;
import com.nedap.archie.aom.primitives.CDateTime;
import com.nedap.archie.aom.primitives.CDuration;
import com.nedap.archie.aom.primitives.CInteger;
import com.nedap.archie.aom.primitives.CReal;
import com.nedap.archie.aom.primitives.CString;
import com.nedap.archie.aom.primitives.CTerminologyCode;
import com.nedap.archie.aom.primitives.CTime;
import com.nedap.archie.aom.profile.AomProfile;
import com.nedap.archie.aom.profile.AomPropertyMapping;
import com.nedap.archie.aom.profile.AomTypeMapping;
import com.nedap.archie.aom.terminology.ArchetypeTerm;
import com.nedap.archie.aom.terminology.ArchetypeTerminology;
import com.nedap.archie.aom.terminology.ValueSet;
import com.nedap.archie.base.Interval;
import com.nedap.archie.base.MultiplicityInterval;
import com.nedap.archie.rminfo.MetaModel;
import com.nedap.archie.rminfo.MetaModels;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.openehr.bmm.core.BmmClass;
import org.openehr.bmm.core.BmmContainerProperty;
import org.openehr.bmm.core.BmmContainerType;
import org.openehr.bmm.core.BmmDefinedType;
import org.openehr.bmm.core.BmmEnumerationInteger;
import org.openehr.bmm.core.BmmEnumerationString;
import org.openehr.bmm.core.BmmModel;
import org.openehr.bmm.core.BmmParameterType;
import org.openehr.bmm.core.BmmProperty;
import org.openehr.bmm.core.BmmType;
import org.openehr.bmm.persistence.validation.BmmDefinitions;

public class ExampleJsonInstanceGenerator {
    public static final String MISSING_TERM_IN_ARCHETYPE_FOR_LANGUAGE = "missing term in archetype for language ";
    private final String language;
    private final MetaModels models;
    private OperationalTemplate archetype;
    private BmmModel bmm;
    private AomProfile aomProfile;
    private boolean useTypeNameWhenTermMissing = false;
    private boolean addUniqueNamesForSiblingNodes = false;
    private String typePropertyName = "@type";

    public ExampleJsonInstanceGenerator(MetaModels models, String language) {
        this.language = language;
        this.models = models;
    }

    public Map<String, Object> generate(OperationalTemplate archetype) {
        this.archetype = archetype;
        String rmRelease = archetype.getRmRelease();
        if (rmRelease == null || !rmRelease.equalsIgnoreCase("1.0.4") && !rmRelease.equalsIgnoreCase("1.1.0")) {
            rmRelease = "1.1.0";
        }
        this.models.selectModel((Archetype)archetype, rmRelease);
        this.aomProfile = this.models.getSelectedAomProfile();
        this.bmm = this.models.getSelectedBmmModel();
        return this.generate(archetype.getDefinition());
    }

    public boolean isUseTypeNameWhenTermMissing() {
        return this.useTypeNameWhenTermMissing;
    }

    public void setUseTypeNameWhenTermMissing(boolean useTypeNameWhenTermMissing) {
        this.useTypeNameWhenTermMissing = useTypeNameWhenTermMissing;
    }

    public void setTypePropertyName(String typePropertyName) {
        this.typePropertyName = typePropertyName;
    }

    public boolean isAddUniqueNamesForSiblingNodes() {
        return this.addUniqueNamesForSiblingNodes;
    }

    public void setAddUniqueNamesForSiblingNodes(boolean addUniqueNamesForSiblingNodes) {
        this.addUniqueNamesForSiblingNodes = addUniqueNamesForSiblingNodes;
    }

    private Map<String, Object> generate(CComplexObject cObject) {
        String type = this.getConcreteTypeName(cObject.getRmTypeName());
        Map<String, Object> result = this.generateCustomExampleType(type);
        if (result == null) {
            result = new LinkedHashMap<String, Object>();
            result.put(this.typePropertyName, type);
        }
        BmmClass classDefinition = this.bmm.getClassDefinition(cObject.getRmTypeName());
        this.addAdditionalPropertiesAtBegin(classDefinition, result, (CObject)cObject);
        for (CAttribute attribute : cObject.getAttributes()) {
            BmmProperty property = this.bmm.propertyAtPath(cObject.getRmTypeName(), attribute.getRmAttributeName());
            if (property == null || property.getComputed()) continue;
            ArrayList<Object> children = new ArrayList<Object>();
            for (CObject child : attribute.getChildren()) {
                MultiplicityInterval multiplicityInterval = child.effectiveOccurrences((arg_0, arg_1) -> ((MetaModel)this.models.getSelectedModel()).referenceModelPropMultiplicity(arg_0, arg_1));
                int occurrences = Math.max(1, (Integer)multiplicityInterval.getLower());
                if (multiplicityInterval.isProhibited()) {
                    occurrences = 0;
                } else if (multiplicityInterval.has((Object)2) && occurrences <= 1 && (attribute.getCardinality() == null || attribute.getCardinality().getInterval().isUpperUnbounded())) {
                    occurrences = 2;
                }
                for (int i = 0; i < occurrences; ++i) {
                    Map<String, Object> next;
                    if (child instanceof CComplexObject) {
                        next = this.generate((CComplexObject)child);
                        children.add(next);
                        continue;
                    }
                    if (child instanceof CPrimitiveObject) {
                        children.add(this.generateCPrimitive((CPrimitiveObject)child));
                        continue;
                    }
                    if (child instanceof ArchetypeSlot) {
                        next = new LinkedHashMap<String, Object>();
                        String concreteTypeName = this.getConcreteTypeName(child.getRmTypeName());
                        BmmClass childClassDefinition = this.bmm.getClassDefinition(concreteTypeName);
                        next.put(this.typePropertyName, concreteTypeName);
                        this.addAdditionalPropertiesAtBegin(classDefinition, next, child);
                        this.addRequiredPropertiesFromBmm(next, childClassDefinition);
                        this.addAdditionalPropertiesAtEnd(classDefinition, next, child);
                        children.add(next);
                        continue;
                    }
                    children.add("unsupported constraint: " + child.getClass().getSimpleName());
                }
            }
            if (property instanceof BmmContainerProperty) {
                this.ensureNoDuplicateName(children);
                result.put(attribute.getRmAttributeName(), children);
                continue;
            }
            if (children.isEmpty()) continue;
            result.put(attribute.getRmAttributeName(), children.get(0));
        }
        this.addRequiredPropertiesFromBmm(result, classDefinition);
        this.addAdditionalPropertiesAtEnd(classDefinition, result, (CObject)cObject);
        return result;
    }

    private void ensureNoDuplicateName(List<Object> children) {
        if (!this.addUniqueNamesForSiblingNodes) {
            return;
        }
        LinkedHashMap<String, String> nameToNodeIdMap = new LinkedHashMap<String, String>();
        for (Object child : children) {
            Map nameMap;
            String nameValue;
            if (!(child instanceof Map)) continue;
            Map json = (Map)child;
            String archetypeNodeId = (String)json.get("archetype_node_id");
            Object name = json.get("name");
            if (archetypeNodeId == null || !(name instanceof Map) || (nameValue = (String)(nameMap = (Map)name).get("value")) == null) continue;
            String existingNodeId = (String)nameToNodeIdMap.get(nameValue);
            if (existingNodeId != null && !existingNodeId.equalsIgnoreCase(archetypeNodeId)) {
                int index = 1;
                String newName = nameValue + " " + index;
                while (nameToNodeIdMap.containsKey(newName)) {
                    newName = nameValue + " " + ++index;
                }
                nameMap.put("value", newName);
                nameToNodeIdMap.put(newName, archetypeNodeId);
                continue;
            }
            nameToNodeIdMap.put(nameValue, archetypeNodeId);
        }
    }

    protected String getConcreteTypeName(String rmTypeName) {
        BmmClass classDefinition = this.bmm.getClassDefinition(rmTypeName);
        if (classDefinition.isAbstract()) {
            String customConcreteType = this.getConcreteTypeOverride(rmTypeName);
            if (customConcreteType != null) {
                return customConcreteType;
            }
            List allDescendants = classDefinition.findAllDescendants();
            for (String descendant : allDescendants) {
                BmmClass descendantClassDefinition = this.bmm.getClassDefinition(descendant);
                if (descendantClassDefinition.isAbstract()) continue;
                return BmmDefinitions.typeNameToClassKey((String)descendantClassDefinition.getType().getTypeName());
            }
        }
        return rmTypeName;
    }

    private void addRequiredPropertiesFromBmm(Map<String, Object> result, BmmClass classDefinition) {
        Map properties = classDefinition.getFlatProperties();
        for (BmmProperty property : properties.values()) {
            if (!property.getMandatory() || result.containsKey(property.getName())) continue;
            if (property.getName().equalsIgnoreCase("archetype_node_id")) {
                this.addRequiredProperty(result, property, "idX");
                continue;
            }
            this.addRequiredProperty(result, property);
        }
    }

    private void addRequiredProperty(Map<String, Object> result, BmmProperty property) {
        this.addRequiredProperty(result, property, null);
    }

    private void addRequiredProperty(Map<String, Object> result, BmmProperty property, String value) {
        BmmType type = property.getType();
        if (value != null) {
            result.put(property.getName(), value);
        } else if (property instanceof BmmContainerProperty) {
            ArrayList<Object> children = new ArrayList<Object>();
            MultiplicityInterval cardinality = ((BmmContainerProperty)property).getCardinality();
            if (cardinality.isMandatory()) {
                String actualType = ((BmmContainerType)type).getBaseType().getTypeName();
                children.add(this.createExampleFromTypeName(actualType));
            }
            result.put(property.getName(), children);
        } else if (type instanceof BmmParameterType) {
            result.put(property.getName(), this.createExampleFromTypeName(type.getEffectiveType().getTypeName()));
        } else if (type instanceof BmmDefinedType) {
            BmmClass propertyClass = ((BmmDefinedType)type).getBaseClass();
            if (propertyClass instanceof BmmEnumerationInteger) {
                result.put(property.getName(), 0);
            } else if (propertyClass instanceof BmmEnumerationString) {
                result.put(property.getName(), "string");
            } else {
                result.put(property.getName(), this.createExampleFromTypeName(type.getTypeName()));
            }
        }
    }

    private Object createExampleFromTypeName(String typeName) {
        String actualType = this.getConcreteTypeName(typeName);
        BmmClass classDefinition1 = this.bmm.getClassDefinition(actualType);
        if (classDefinition1 != null && classDefinition1.isPrimitiveType()) {
            if (this.aomProfile.getRmPrimitiveTypeEquivalences().get(actualType) != null) {
                actualType = (String)this.aomProfile.getRmPrimitiveTypeEquivalences().get(actualType);
            }
            return this.generatePrimitiveTypeExample(actualType);
        }
        return this.constructExampleType(actualType);
    }

    private Map<String, Object> constructExampleType(String actualType) {
        Map<String, Object> custom = this.generateCustomExampleType(actualType);
        if (custom != null) {
            return custom;
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        String className = this.getConcreteTypeName(actualType);
        BmmClass classDefinition = this.bmm.getClassDefinition(actualType);
        result.put(this.typePropertyName, className);
        if (classDefinition != null) {
            this.addRequiredPropertiesFromBmm(result, classDefinition);
        }
        return result;
    }

    private Object generatePrimitiveTypeExample(String typeName) {
        switch (typeName.toLowerCase()) {
            case "string": {
                return "string";
            }
            case "real": {
                return 42.0;
            }
            case "integer": {
                return 42;
            }
            case "date": {
                return "2018-01-01";
            }
            case "date_time": {
                return "2018-01-01T12:00:00+00:00";
            }
            case "time": {
                return "12:00:00";
            }
            case "duration": {
                return "PT10M";
            }
            case "boolean": {
                return true;
            }
        }
        return "unknown primitive type " + typeName;
    }

    private Object generateCPrimitive(CPrimitiveObject child) {
        Object customMapping = this.generateCustomMapping(child);
        if (customMapping != null) {
            return customMapping;
        }
        if (child instanceof CString) {
            CString string = (CString)child;
            if (string.getConstraint() != null && !string.getConstraint().isEmpty()) {
                return string.getConstraint().get(0);
            }
            return "string";
        }
        if (child instanceof CBoolean) {
            CBoolean bool = (CBoolean)child;
            if (bool.getConstraint() != null && !bool.getConstraint().isEmpty()) {
                return bool.getConstraint().get(0);
            }
            return true;
        }
        if (child instanceof CInteger) {
            CInteger integer = (CInteger)child;
            if (integer.getConstraint() != null && !integer.getConstraint().isEmpty()) {
                Interval longInterval = (Interval)integer.getConstraint().get(0);
                if (longInterval.isUpperUnbounded() && longInterval.isLowerUnbounded()) {
                    return 42;
                }
                if (longInterval.isUpperUnbounded()) {
                    return (Long)longInterval.getLower() + 1L;
                }
                if (longInterval.isLowerUnbounded()) {
                    return (Long)longInterval.getUpper() - 1L;
                }
                if (longInterval.isLowerIncluded()) {
                    return longInterval.getLower();
                }
                return (Long)longInterval.getUpper() + 1L;
            }
            return 42;
        }
        if (child instanceof CReal) {
            CReal real = (CReal)child;
            if (real.getConstraint() != null && !real.getConstraint().isEmpty()) {
                Interval doubleInterval = (Interval)real.getConstraint().get(0);
                if (doubleInterval.isUpperUnbounded() && doubleInterval.isLowerUnbounded()) {
                    return 42.0;
                }
                if (doubleInterval.isUpperUnbounded()) {
                    return (Double)doubleInterval.getLower() + 1.0;
                }
                if (doubleInterval.isLowerUnbounded()) {
                    return (Double)doubleInterval.getUpper() - 1.0;
                }
                if (doubleInterval.isLowerIncluded()) {
                    return doubleInterval.getLower();
                }
                return (Double)doubleInterval.getUpper() + 1.0;
            }
            return 42.0;
        }
        if (child instanceof CTerminologyCode) {
            return this.generateTerminologyCode((CTerminologyCode)child);
        }
        if (child instanceof CDuration) {
            return "PT12m";
        }
        if (child instanceof CDate) {
            return "2018-01-01";
        }
        if (child instanceof CTime) {
            return "12:00:00";
        }
        if (child instanceof CDateTime) {
            return "2018-01-01T12:00:00+0000";
        }
        return "TODO: unsupported primitive object constraint " + child.getClass();
    }

    private Object generateTerminologyCode(CTerminologyCode child) {
        if (this.aomProfile == null) {
            return "cannot convert CTerminologyCode without AOM profile";
        }
        AomTypeMapping termCodeMapping = (AomTypeMapping)this.aomProfile.getAomRmTypeMappings().get("TERMINOLOGY_CODE");
        if (termCodeMapping == null) {
            return "cannot convert a CTerminology code without an AOM profile containing at least a mapping of Terminology code";
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        String type = termCodeMapping.getTargetClassName();
        result.put(this.typePropertyName, type);
        AomPropertyMapping terminologyIdMapping = (AomPropertyMapping)termCodeMapping.getPropertyMappings().get("terminology_id");
        AomPropertyMapping codeStringMapping = (AomPropertyMapping)termCodeMapping.getPropertyMappings().get("code_string");
        String codeString = "term code";
        LinkedHashMap<String, String> terminologyId = new LinkedHashMap<String, String>();
        terminologyId.put(this.typePropertyName, "TERMINOLOGY_ID");
        terminologyId.put("value", "local");
        String termString = "term";
        if (child.getConstraint().isEmpty()) {
            codeString = "term code";
        } else {
            String constraint = (String)child.getConstraint().get(0);
            if (constraint.startsWith("ac")) {
                ArchetypeTerm term;
                ArchetypeTerminology terminology = this.archetype.getTerminology((CObject)child);
                ValueSet valueSet = (ValueSet)terminology.getValueSets().get(constraint);
                if (valueSet == null) {
                    valueSet = (ValueSet)this.archetype.getTerminology().getValueSets().get(constraint);
                }
                if (valueSet != null && !valueSet.getMembers().isEmpty() && (term = this.archetype.getTerm((CObject)child, codeString = (String)valueSet.getMembers().iterator().next(), this.language)) != null) {
                    termString = term.getText();
                }
            } else if (constraint.startsWith("at")) {
                codeString = constraint;
                ArchetypeTerm term = this.archetype.getTerm((CObject)child, constraint, this.language);
                if (term != null) {
                    termString = term.getText();
                }
            } else {
                codeString = "unknown term code mapping" + constraint;
            }
        }
        if (terminologyIdMapping != null) {
            result.put(terminologyIdMapping.getTargetPropertyName(), terminologyId);
        }
        if (codeStringMapping == null) {
            return "cannot convert a CTerminology code without an AOM profile containing at least a mapping of Terminology code";
        }
        String targetPropertyName = codeStringMapping.getTargetPropertyName();
        result.put(targetPropertyName, codeString);
        return result;
    }

    private String getConcreteTypeOverride(String rmTypeName) {
        if (rmTypeName.equalsIgnoreCase("ITEM")) {
            return "ELEMENT";
        }
        if (rmTypeName.equalsIgnoreCase("EVENT")) {
            return "POINT_EVENT";
        }
        return null;
    }

    private Object generateCustomMapping(CPrimitiveObject child) {
        if (child instanceof CTerminologyCode) {
            CTerminologyCode cTermCode = (CTerminologyCode)child;
            CAttribute parentAttribute = child.getParent();
            CComplexObject parentObject = (CComplexObject)parentAttribute.getParent();
            BmmClass classDefinition = this.bmm.getClassDefinition(parentObject.getRmTypeName());
            if (classDefinition == null) {
                return null;
            }
            BmmProperty property = (BmmProperty)classDefinition.getFlatProperties().get(parentAttribute.getRmAttributeName());
            if (property == null) {
                return null;
            }
            if (property.getType().getTypeName().equalsIgnoreCase("DV_CODED_TEXT")) {
                Object codePhrase = this.generateTerminologyCode(cTermCode);
                Map<String, Object> dvCodedText = this.constructExampleType("DV_CODED_TEXT");
                dvCodedText.put("defining_code", codePhrase);
                if (codePhrase instanceof Map) {
                    Map definingCode = (Map)codePhrase;
                    String codeString = (String)definingCode.get("code_string");
                    ArchetypeTerm term = this.archetype.getTerm((CObject)child, codeString, this.language);
                    dvCodedText.put("value", term == null ? this.getMissingTermText((CObject)child) : term.getText());
                }
                return dvCodedText;
            }
            return null;
        }
        return null;
    }

    private String getMissingTermText(CObject cObject) {
        if (this.useTypeNameWhenTermMissing && !(cObject instanceof CPrimitiveObject)) {
            return cObject.getRmTypeName();
        }
        return MISSING_TERM_IN_ARCHETYPE_FOR_LANGUAGE + this.language;
    }

    protected void addAdditionalPropertiesAtBegin(BmmClass classDefinition, Map<String, Object> result, CObject cObject) {
        if (classDefinition.getType().getTypeName().equalsIgnoreCase("LOCATABLE") || classDefinition.findAllAncestors().contains("LOCATABLE")) {
            LinkedHashMap<String, String> name = new LinkedHashMap<String, String>();
            name.put(this.typePropertyName, "DV_TEXT");
            ArchetypeTerm term = this.archetype.getTerm(cObject, this.language);
            if (term == null) {
                name.put("value", this.getMissingTermText(cObject));
            } else {
                name.put("value", term.getText());
            }
            result.put("name", name);
            if (!(cObject instanceof CPrimitiveObject)) {
                result.put("archetype_node_id", cObject.getNodeId());
            }
        }
        if (cObject instanceof ArchetypeSlot) {
            result.put("archetype_details", this.constructArchetypeDetails("openEHR-EHR-" + cObject.getRmTypeName() + ".archetype-slot.v1"));
        } else if (cObject instanceof CArchetypeRoot) {
            result.put("archetype_details", this.constructArchetypeDetails(((CArchetypeRoot)cObject).getArchetypeRef()));
        } else if (cObject.isRootNode()) {
            result.put("archetype_details", this.constructArchetypeDetails(cObject.getArchetype().getArchetypeId().getFullId()));
        }
    }

    private Map<String, Object> constructArchetypeDetails(String archetypeIdValue) {
        LinkedHashMap<String, Object> archetypeDetails = new LinkedHashMap<String, Object>();
        archetypeDetails.put(this.typePropertyName, "ARCHETYPED");
        LinkedHashMap<String, String> archetypeId = new LinkedHashMap<String, String>();
        archetypeId.put(this.typePropertyName, "ARCHETYPE_ID");
        archetypeId.put("value", archetypeIdValue);
        archetypeDetails.put("archetype_id", archetypeId);
        archetypeDetails.put("rm_version", "1.0.4");
        return archetypeDetails;
    }

    protected void addAdditionalPropertiesAtEnd(BmmClass classDefinition, Map<String, Object> result, CObject cObject) {
        if (classDefinition.getType().getTypeName().equalsIgnoreCase("DV_CODED_TEXT")) {
            try {
                Map definingCode = (Map)result.get("defining_code");
                String codeString = (String)definingCode.get("code_string");
                ArchetypeTerm term = this.archetype.getTerm(cObject, codeString, this.language);
                result.put("value", term.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private Map<String, Object> generateCustomExampleType(String actualType) {
        if (actualType.equalsIgnoreCase("DV_DATE_TIME")) {
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            result.put(this.typePropertyName, "DV_DATE_TIME");
            result.put("value", "2018-01-01T12:00:00+0000");
            return result;
        }
        if (actualType.equalsIgnoreCase("DV_DATE")) {
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            result.put(this.typePropertyName, "DV_DATE");
            result.put("value", "2018-01-01");
            return result;
        }
        if (actualType.equalsIgnoreCase("DV_TIME")) {
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            result.put(this.typePropertyName, "DV_TIME");
            result.put("value", "12:00:00");
            return result;
        }
        if (actualType.equalsIgnoreCase("DV_DURATION")) {
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            result.put(this.typePropertyName, "DV_DURATION");
            result.put("value", "PT20m");
            return result;
        }
        return null;
    }
}

