/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.archetypevalidator.validations;

import com.nedap.archie.aom.Archetype;
import com.nedap.archie.aom.AuthoredArchetype;
import com.nedap.archie.aom.OperationalTemplate;
import com.nedap.archie.aom.ResourceAnnotations;
import com.nedap.archie.aom.utils.AOMUtils;
import com.nedap.archie.archetypevalidator.ArchetypeValidationBase;
import com.nedap.archie.archetypevalidator.ErrorType;
import com.nedap.archie.query.AOMPathQuery;
import java.util.Map;
import org.openehr.utils.message.I18n;

public class AnnotationsValidation
extends ArchetypeValidationBase {
    @Override
    public void validate() {
        if (this.archetype instanceof AuthoredArchetype && this.archetype.getAnnotations() != null) {
            ResourceAnnotations annotations = this.archetype.getAnnotations();
            for (String language : annotations.getDocumentation().keySet()) {
                Map annotationsForLanguage = (Map)annotations.getDocumentation().get(language);
                for (String path : annotationsForLanguage.keySet()) {
                    Map annotationsForPath = (Map)annotationsForLanguage.get(path);
                    boolean isArchetypePath = AOMUtils.isArchetypePath((String)path);
                    OperationalTemplate operationalTemplate = this.repository.getOperationalTemplate(this.archetype.getArchetypeId().toString());
                    if (operationalTemplate == null) {
                        operationalTemplate = this.archetype;
                    }
                    if (isArchetypePath) {
                        if (this.hasPath(path, (Archetype)operationalTemplate) || this.flatParent != null && this.hasPath(path, this.flatParent)) continue;
                        this.addMessage(ErrorType.VRANP, I18n.t((String)"The path {0} referenced in the annotations does not exist in the flat archetype", (Object[])new Object[]{path}));
                        continue;
                    }
                    if (this.combinedModels.hasReferenceModelPath(this.archetype.getDefinition().getRmTypeName(), path)) continue;
                    this.addMessage(ErrorType.VRANP, I18n.t((String)"The path {0} referenced in the annotations does not exist in the flat archetype or reference model", (Object[])new Object[]{path}));
                }
            }
        }
    }

    private boolean hasPath(String path, Archetype archetype) {
        return !new AOMPathQuery(path).findList(archetype.getDefinition(), true).isEmpty();
    }
}

