/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.archetypevalidator;

import com.google.common.base.Strings;
import com.nedap.archie.archetypevalidator.ErrorType;
import org.openehr.utils.message.I18n;

public class ValidationMessage {
    private ErrorType type;
    private String pathInArchetype;
    private String message;
    private boolean warning;

    public ValidationMessage() {
    }

    public ValidationMessage(ErrorType type) {
        this.type = type;
    }

    public ValidationMessage(ErrorType type, String pathInArchetype) {
        this.type = type;
        this.pathInArchetype = pathInArchetype;
    }

    public ValidationMessage(ErrorType type, String pathInArchetype, String message) {
        this.type = type;
        this.pathInArchetype = pathInArchetype;
        this.message = message;
    }

    public ErrorType getType() {
        return this.type;
    }

    public void setType(ErrorType type) {
        this.type = type;
    }

    public String getPathInArchetype() {
        return this.pathInArchetype;
    }

    public void setPathInArchetype(String pathInArchetype) {
        this.pathInArchetype = pathInArchetype;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.warning) {
            result.append(I18n.t((String)"Warning", (Object[])new Object[0]));
        } else {
            result.append(I18n.t((String)"Error", (Object[])new Object[0]));
        }
        boolean outputNewLine = false;
        if (!Strings.isNullOrEmpty((String)this.message)) {
            result.append(": ");
            result.append(this.message);
            result.append("\n");
            outputNewLine = true;
        }
        if (!Strings.isNullOrEmpty((String)this.pathInArchetype)) {
            if (!outputNewLine) {
                result.append(" ");
            }
            result.append(I18n.t((String)"at path: ", (Object[])new Object[0]));
            result.append(this.pathInArchetype);
            result.append("\n");
            outputNewLine = true;
        }
        if (!outputNewLine) {
            result.append(" ");
        }
        result.append(this.type.getCode());
        result.append(": ");
        result.append(this.type.getMessage(new Object[0]));
        return result.toString();
    }

    public boolean isWarning() {
        return this.warning;
    }

    public void setWarning(boolean warning) {
        this.warning = warning;
    }
}

