/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.adl14;

import com.nedap.archie.adl14.ADL14ConversionConfiguration;
import com.nedap.archie.adl14.ADL14DescriptionConverter;
import com.nedap.archie.adl14.ADL14NodeIDConverter;
import com.nedap.archie.adl14.ADL2ConversionResult;
import com.nedap.archie.adl14.ADL2ConversionResultList;
import com.nedap.archie.adl14.DefaultRmStructureRemover;
import com.nedap.archie.adl14.log.ADL2ConversionLog;
import com.nedap.archie.adl14.log.ADL2ConversionRunLog;
import com.nedap.archie.aom.Archetype;
import com.nedap.archie.aom.ResourceDescription;
import com.nedap.archie.aom.Template;
import com.nedap.archie.aom.TemplateOverlay;
import com.nedap.archie.aom.utils.ArchetypeParsePostProcesser;
import com.nedap.archie.diff.Differentiator;
import com.nedap.archie.flattener.ArchetypeRepository;
import com.nedap.archie.flattener.Flattener;
import com.nedap.archie.flattener.InMemoryFullArchetypeRepository;
import com.nedap.archie.rminfo.MetaModels;
import com.nedap.archie.terminology.OpenEHRTerminologyAccess;
import com.nedap.archie.terminology.TerminologyAccess;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;

public class ADL14Converter {
    private final MetaModels metaModels;
    private TerminologyAccess terminologyAccess = OpenEHRTerminologyAccess.getInstance();
    private final ADL14ConversionConfiguration conversionConfiguration;
    private InMemoryFullArchetypeRepository existingRepository;

    public ADL14Converter(MetaModels metaModels, ADL14ConversionConfiguration conversionConfiguration) {
        this.metaModels = metaModels;
        this.conversionConfiguration = conversionConfiguration;
    }

    public void setExistingRepository(InMemoryFullArchetypeRepository existingRepository) {
        this.existingRepository = existingRepository;
    }

    public ADL2ConversionResultList convert(List<Archetype> archetypes) {
        return this.convert(archetypes, null);
    }

    public ADL2ConversionResultList convert(List<Archetype> archetypes, ADL2ConversionRunLog previousConversion) {
        ADL2ConversionResultList resultList = new ADL2ConversionResultList();
        InMemoryFullArchetypeRepository repository = this.existingRepository;
        if (repository == null) {
            repository = new InMemoryFullArchetypeRepository();
        }
        ArrayList<Archetype> unprocessed = new ArrayList<Archetype>(archetypes);
        ArrayList<TemplateOverlay> templateOverlays = new ArrayList<TemplateOverlay>();
        for (Archetype ar : unprocessed) {
            if (!(ar instanceof Template)) continue;
            Template t = (Template)ar;
            for (TemplateOverlay overlay : t.getTemplateOverlays()) {
                templateOverlays.add(overlay);
                overlay.setRmRelease(t.getRmRelease());
            }
        }
        unprocessed.addAll(templateOverlays);
        unprocessed.sort(Comparator.comparingInt(a -> a.specializationDepth()));
        Differentiator differentiator = new Differentiator(this.metaModels);
        for (Archetype archetype : unprocessed) {
            ADL2ConversionResult result = null;
            try {
                if (archetype.getParentArchetypeId() != null) {
                    Archetype parent = repository.getArchetype(archetype.getParentArchetypeId());
                    if (parent == null) {
                        throw new RuntimeException(MessageFormat.format("Cannot find parent {0} for archetype {1}", archetype.getParentArchetypeId(), archetype.getArchetypeId()));
                    }
                    Archetype flatParent = new Flattener((ArchetypeRepository)repository, this.metaModels).flatten(parent);
                    result = this.convert(archetype, flatParent, previousConversion);
                    if (result.getArchetype() != null) {
                        if (this.conversionConfiguration.isApplyDiff()) {
                            result.setArchetype(differentiator.differentiate(result.getArchetype(), flatParent, true));
                        } else {
                            result.setArchetype(differentiator.differentiate(result.getArchetype(), flatParent, false));
                        }
                    }
                    resultList.addConversionResult(result);
                } else {
                    result = this.convert(archetype, previousConversion);
                    resultList.addConversionResult(result);
                }
                if (result == null || result.getArchetype() == null || result.getArchetype().getArchetypeId() == null) continue;
                repository.addArchetype(result.getArchetype());
            }
            catch (Exception e) {
                result = new ADL2ConversionResult(archetype.getArchetypeId().toString(), e);
                resultList.addConversionResult(result);
            }
        }
        return resultList;
    }

    private ADL2ConversionResult convert(Archetype archetype, ADL2ConversionRunLog previousConversion) {
        return this.convert(archetype, null, previousConversion);
    }

    private ADL2ConversionResult convert(Archetype archetype, Archetype flatParent, ADL2ConversionRunLog previousConversion) {
        ADL2ConversionLog previousLog = previousConversion == null ? null : previousConversion.getConversionLog(archetype.getArchetypeId().getSemanticId());
        Archetype convertedArchetype = archetype.clone();
        new ADL14DescriptionConverter().convert(convertedArchetype);
        this.setCorrectVersions(convertedArchetype);
        this.convertHeader(convertedArchetype);
        ADL2ConversionResult result = new ADL2ConversionResult(convertedArchetype);
        ADL14NodeIDConverter adl14NodeIDConverter = new ADL14NodeIDConverter(this.metaModels, convertedArchetype, flatParent, this.conversionConfiguration, previousLog, result);
        ADL2ConversionLog conversionLog = adl14NodeIDConverter.convert();
        result.setConversionLog(conversionLog);
        new DefaultRmStructureRemover(this.metaModels, true).removeRMDefaults(convertedArchetype);
        ArchetypeParsePostProcesser.fixArchetype((Archetype)convertedArchetype);
        return result;
    }

    private void convertHeader(Archetype convertedArchetype) {
        if (convertedArchetype.getUid() != null && convertedArchetype.getUid().matches("[0-9]+(\\.[0-9]+)+")) {
            this.moveOidToMetadata(convertedArchetype, convertedArchetype.getUid(), "oid");
            convertedArchetype.setUid(null);
        }
        if (convertedArchetype.getBuildUid() != null && convertedArchetype.getBuildUid().matches("[0-9]+\\.([0-9]+)+")) {
            this.moveOidToMetadata(convertedArchetype, convertedArchetype.getBuildUid(), "build_oid");
            convertedArchetype.setBuildUid(null);
        }
    }

    private void moveOidToMetadata(Archetype convertedArchetype, String oid, String oidFieldName) {
        if (convertedArchetype.getDescription() == null) {
            convertedArchetype.setDescription(new ResourceDescription());
        }
        if (convertedArchetype.getDescription().getOtherDetails() == null) {
            convertedArchetype.getDescription().setOtherDetails(new LinkedHashMap());
        }
        convertedArchetype.getDescription().getOtherDetails().put(oidFieldName, oid);
    }

    private void setCorrectVersions(Archetype result) {
        result.setAdlVersion("2.0.6");
        result.setRmRelease(this.conversionConfiguration.getRmRelease());
        if (result.getArchetypeId().getMinorVersion() == null) {
            result.getArchetypeId().setReleaseVersion(result.getArchetypeId().getReleaseVersion() + ".0.0");
        }
    }
}

