/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rules.evaluation.evaluators.functions;

import com.nedap.archie.rules.PrimitiveType;
import com.nedap.archie.rules.evaluation.FunctionCallException;
import com.nedap.archie.rules.evaluation.FunctionImplementation;
import com.nedap.archie.rules.evaluation.Value;
import com.nedap.archie.rules.evaluation.ValueList;
import com.nedap.archie.rules.evaluation.evaluators.FunctionUtil;
import java.util.ArrayList;
import java.util.List;

public class FlatSum
implements FunctionImplementation {
    @Override
    public String getName() {
        return "flat_sum";
    }

    @Override
    public ValueList evaluate(List<ValueList> arguments) throws FunctionCallException {
        ValueList possiblyNullResult = FunctionUtil.checkAndHandleNull(arguments);
        if (possiblyNullResult != null) {
            possiblyNullResult.setType(PrimitiveType.Real);
            return possiblyNullResult;
        }
        double sum = 0.0;
        ValueList result = new ValueList();
        ArrayList<String> paths = new ArrayList<String>();
        for (ValueList argument : arguments) {
            List<Value> values = argument.getValues();
            for (Value val : values) {
                if (!val.isNull()) {
                    sum += FunctionUtil.castToDouble(val);
                }
                paths.addAll(val.getPaths());
            }
        }
        result.addValue(sum, paths);
        result.setType(PrimitiveType.Real);
        return result;
    }
}

