/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rules.evaluation.evaluators;

import com.google.common.collect.Lists;
import com.nedap.archie.rules.evaluation.FunctionCallException;
import com.nedap.archie.rules.evaluation.Value;
import com.nedap.archie.rules.evaluation.ValueList;
import java.util.ArrayList;
import java.util.List;

public class FunctionUtil {
    public static double castToDouble(Value value) throws FunctionCallException {
        if (value.getValue() instanceof Long) {
            return ((Long)value.getValue()).doubleValue();
        }
        if (value.getValue() instanceof Double) {
            return (Double)value.getValue();
        }
        throw new FunctionCallException("cannot cast " + value.getValue().getClass() + " to a number");
    }

    public static int checkEqualLength(List<ValueList> arguments) {
        int length = 1;
        boolean first = true;
        for (ValueList list : arguments) {
            if (first && list.size() != 1) {
                length = list.size();
                continue;
            }
            if (list.size() == 1 || list.size() == length) continue;
            return -1;
        }
        return length;
    }

    public static ValueList checkAndHandleNull(ValueList leftValues, ValueList rightValues) {
        return FunctionUtil.checkAndHandleNull(Lists.newArrayList((Object[])new ValueList[]{leftValues, rightValues}));
    }

    public static ValueList checkAndHandleNull(List<ValueList> arguments) {
        if (FunctionUtil.atLeastOneValueEmpty(arguments)) {
            ValueList result = new ValueList();
            result.addValue(Value.createNull(FunctionUtil.gatherPaths(arguments)));
            return result;
        }
        return null;
    }

    public static List<String> gatherPaths(List<ValueList> arguments) {
        ArrayList<String> result = new ArrayList<String>();
        for (ValueList list : arguments) {
            if (list.isEmpty()) continue;
            result.addAll(list.getAllPaths());
        }
        return result;
    }

    private static boolean atLeastOneValueEmpty(List<ValueList> arguments) {
        for (ValueList list : arguments) {
            if (!list.isEmpty()) continue;
            return true;
        }
        return false;
    }
}

