/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rules.evaluation.evaluators;

import com.google.common.collect.Lists;
import com.nedap.archie.query.RMObjectWithPath;
import com.nedap.archie.rules.Expression;
import com.nedap.archie.rules.ForAllStatement;
import com.nedap.archie.rules.PrimitiveType;
import com.nedap.archie.rules.RuleElement;
import com.nedap.archie.rules.evaluation.Evaluator;
import com.nedap.archie.rules.evaluation.RuleEvaluation;
import com.nedap.archie.rules.evaluation.Value;
import com.nedap.archie.rules.evaluation.ValueList;
import java.util.ArrayList;
import java.util.List;

public class ForAllEvaluator
implements Evaluator<ForAllStatement> {
    @Override
    public ValueList evaluate(RuleEvaluation evaluation, ForAllStatement statement) {
        Expression pathExpression = statement.getPathExpression();
        String variableName = statement.getVariableName();
        Expression toEvaluate = statement.getAssertion();
        ValueList pathValues = evaluation.evaluate((RuleElement)pathExpression);
        ArrayList<String> allPaths = new ArrayList<String>();
        boolean resultingCheck = true;
        for (Value value : pathValues.getValues()) {
            if (value.getPaths().size() > 1) {
                throw new IllegalStateException("for all path can only have one path value per value");
            }
            Object context = value.getValue();
            String path = value.getPaths().get(0);
            RMObjectWithPath rmObjectWithPath = new RMObjectWithPath(context, path);
            ValueList valueList = new ValueList(rmObjectWithPath);
            valueList.setType(PrimitiveType.ObjectReference);
            evaluation.getVariableMap().put(variableName, valueList);
            ValueList evaluated = evaluation.evaluate((RuleElement)toEvaluate);
            allPaths.addAll(evaluated.getAllPaths());
            if (evaluated.getType() == PrimitiveType.Boolean) {
                for (Value evaluatedValue : evaluated.getValues()) {
                    if (evaluatedValue.getValue() == null || ((Boolean)evaluatedValue.getValue()).booleanValue()) continue;
                    resultingCheck = false;
                }
                continue;
            }
            if (!evaluated.getSingleBooleanResult()) {
                resultingCheck = false;
                continue;
            }
            if (evaluated.getType() != PrimitiveType.Integer && evaluated.getType() != PrimitiveType.Real) continue;
            throw new UnsupportedOperationException("cannot convert type to boolean yet: " + evaluated.getType());
        }
        evaluation.getVariableMap().put(variableName, null);
        return new ValueList(Lists.newArrayList((Object[])new Value[]{new Value<Boolean>(resultingCheck, allPaths)}));
    }

    @Override
    public List<Class> getSupportedClasses() {
        return Lists.newArrayList((Object[])new Class[]{ForAllStatement.class});
    }
}

