/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rules.evaluation.evaluators;

import com.google.common.collect.Lists;
import com.nedap.archie.rminfo.ModelInfoLookup;
import com.nedap.archie.rules.BinaryOperator;
import com.nedap.archie.rules.Constraint;
import com.nedap.archie.rules.OperatorKind;
import com.nedap.archie.rules.PrimitiveType;
import com.nedap.archie.rules.RuleElement;
import com.nedap.archie.rules.evaluation.Evaluator;
import com.nedap.archie.rules.evaluation.RuleEvaluation;
import com.nedap.archie.rules.evaluation.Value;
import com.nedap.archie.rules.evaluation.ValueList;
import com.nedap.archie.rules.evaluation.evaluators.BinaryBooleanOperandEvaluator;
import com.nedap.archie.rules.evaluation.evaluators.BinaryStringOperandEvaluator;
import com.nedap.archie.rules.evaluation.evaluators.FunctionUtil;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public class BinaryOperatorEvaluator
implements Evaluator<BinaryOperator> {
    private static final double EPSILON = 1.0E-5;
    private BinaryBooleanOperandEvaluator booleanOperandEvaluator = new BinaryBooleanOperandEvaluator(this);
    private BinaryStringOperandEvaluator stringOperandEvaluator = new BinaryStringOperandEvaluator(this);
    private final ModelInfoLookup lookup;

    public BinaryOperatorEvaluator(ModelInfoLookup lookup) {
        this.lookup = lookup;
    }

    @Override
    public ValueList evaluate(RuleEvaluation evaluation, BinaryOperator statement) {
        switch (statement.getOperator()) {
            case plus: 
            case minus: 
            case multiply: 
            case divide: 
            case modulo: 
            case exponent: {
                return this.evaluateArithmeticOperator(evaluation, statement);
            }
            case gt: 
            case ge: 
            case lt: 
            case le: 
            case eq: 
            case ne: {
                return this.evaluateRelOpOperator(evaluation, statement);
            }
            case and: 
            case or: 
            case xor: {
                return this.evaluateBooleanOperator(evaluation, statement);
            }
            case matches: {
                return this.evaluateBooleanConstraint(evaluation, statement);
            }
            case implies: {
                return this.evaluateImplies(evaluation, statement);
            }
        }
        throw new RuntimeException("operation " + statement.getOperator() + " not yet supported");
    }

    private ValueList evaluateImplies(RuleEvaluation evaluation, BinaryOperator statement) {
        ValueList leftValue = evaluation.evaluate((RuleElement)statement.getLeftOperand());
        if (leftValue.getSingleBooleanResult()) {
            ValueList rightValue = evaluation.evaluate((RuleElement)statement.getRightOperand());
            return rightValue;
        }
        return new ValueList((Object)true, leftValue.getAllPaths());
    }

    private ValueList evaluateBooleanConstraint(RuleEvaluation evaluation, BinaryOperator statement) {
        ValueList leftValues = evaluation.evaluate((RuleElement)statement.getLeftOperand());
        if (!(statement.getRightOperand() instanceof Constraint)) {
            throw new IllegalArgumentException("cannot evaluate matches statement, right operand not a constraint");
        }
        Constraint constraint = (Constraint)statement.getRightOperand();
        ValueList result = new ValueList();
        result.setType(PrimitiveType.Boolean);
        for (Value value : leftValues.getValues()) {
            result.addValue(constraint.getItem().isValidValue(this.lookup, value.getValue()), value.getPaths());
        }
        return result;
    }

    private ValueList evaluateBooleanOperator(RuleEvaluation evaluation, BinaryOperator statement) {
        ValueList possibleNullResult;
        ValueList leftValues = evaluation.evaluate((RuleElement)statement.getLeftOperand());
        ValueList rightValues = evaluation.evaluate((RuleElement)statement.getRightOperand());
        if (statement.getOperator() != OperatorKind.or && (possibleNullResult = FunctionUtil.checkAndHandleNull(leftValues, rightValues)) != null) {
            possibleNullResult.setType(PrimitiveType.Boolean);
            return possibleNullResult;
        }
        BinaryOperatorEvaluator.checkisBoolean(leftValues, rightValues);
        ValueList result = new ValueList();
        result.setType(PrimitiveType.Boolean);
        if (leftValues.size() == rightValues.size()) {
            for (int i = 0; i < leftValues.size(); ++i) {
                Value leftValue = leftValues.get(i);
                Value rightValue = rightValues.get(i);
                List<String> paths = this.getPaths(leftValue, rightValue);
                result.addValue(this.evaluateBoolean(statement, (Boolean)leftValue.getValue(), (Boolean)rightValue.getValue()), paths);
            }
        } else if (leftValues.size() == 1) {
            Value leftValue = leftValues.get(0);
            for (Value rightValue : rightValues.getValues()) {
                List<String> paths = this.getPaths(leftValue, rightValue);
                result.addValue(this.evaluateBoolean(statement, (Boolean)leftValue.getValue(), (Boolean)rightValue.getValue()), paths);
            }
        } else if (rightValues.size() == 1) {
            Value rightValue = rightValues.get(0);
            for (Value leftValue : leftValues.getValues()) {
                List<String> paths = this.getPaths(leftValue, rightValue);
                result.addValue(this.evaluateBoolean(statement, (Boolean)leftValue.getValue(), (Boolean)rightValue.getValue()), paths);
            }
        } else {
            throw new IllegalArgumentException("sizes of operator arguments not compatible");
        }
        return result;
    }

    protected List<String> getPaths(Value<Boolean> leftValue, Value<Boolean> rightValue) {
        ArrayList<String> paths = new ArrayList<String>();
        paths.addAll(leftValue.getPaths());
        paths.addAll(rightValue.getPaths());
        return paths;
    }

    private Boolean evaluateBoolean(BinaryOperator statement, Boolean leftBoolean, Boolean rightBoolean) {
        switch (statement.getOperator()) {
            case and: {
                return leftBoolean & rightBoolean;
            }
            case or: {
                if (leftBoolean == null && rightBoolean == null) {
                    return null;
                }
                if (leftBoolean == null) {
                    if (rightBoolean.booleanValue()) {
                        return rightBoolean;
                    }
                    return null;
                }
                if (rightBoolean == null) {
                    if (leftBoolean.booleanValue()) {
                        return leftBoolean;
                    }
                    return null;
                }
                return leftBoolean | rightBoolean;
            }
            case xor: {
                return leftBoolean ^ rightBoolean;
            }
        }
        throw new IllegalArgumentException("Not a boolean operator: " + statement.getOperator());
    }

    private ValueList evaluateArithmeticOperator(RuleEvaluation evaluation, BinaryOperator statement) {
        ValueList rightValues;
        ValueList leftValues = evaluation.evaluate((RuleElement)statement.getLeftOperand());
        ValueList possibleNullResult = FunctionUtil.checkAndHandleNull(leftValues, rightValues = evaluation.evaluate((RuleElement)statement.getRightOperand()));
        if (possibleNullResult != null) {
            possibleNullResult.setType(PrimitiveType.Real);
            return possibleNullResult;
        }
        ValueList result = new ValueList();
        result.setType(PrimitiveType.Real);
        BinaryOperatorEvaluator.checkIsNumber(leftValues, rightValues);
        if (leftValues.size() == rightValues.size()) {
            for (int i = 0; i < leftValues.size(); ++i) {
                Value leftValue = leftValues.get(i);
                Value rightValue = rightValues.get(i);
                this.evaluateArithmetic(statement, result, rightValue.getValue(), leftValue.getValue(), this.getPaths(leftValue, rightValue));
            }
        } else if (leftValues.size() == 1) {
            Value leftValue = leftValues.get(0);
            for (Value rightValue : rightValues.getValues()) {
                this.evaluateArithmetic(statement, result, rightValue.getValue(), leftValue.getValue(), this.getPaths(leftValue, rightValue));
            }
        } else if (rightValues.size() == 1) {
            Value rightValue = rightValues.get(0);
            for (Value leftValue : leftValues.getValues()) {
                this.evaluateArithmetic(statement, result, rightValue.getValue(), leftValue.getValue(), this.getPaths(leftValue, rightValue));
            }
        } else {
            throw new IllegalArgumentException("sizes of operator arguments not compatible");
        }
        return result;
    }

    private void evaluateArithmetic(BinaryOperator statement, ValueList result, Object rightValue, Object leftValue, List<String> paths) {
        if (leftValue instanceof Long && rightValue instanceof Long) {
            result.addValue(this.evaluateIntegerArithmetic(statement.getOperator(), (Long)leftValue, (Long)rightValue), paths);
            result.setType(PrimitiveType.Integer);
        } else {
            result.addValue(this.evaluateRealArithmetic(statement.getOperator(), this.convertToDouble(leftValue), this.convertToDouble(rightValue)), paths);
            result.setType(PrimitiveType.Real);
        }
    }

    private Double evaluateRealArithmetic(OperatorKind operator, Double leftNumber, Double rightNumber) {
        switch (operator) {
            case plus: {
                return leftNumber + rightNumber;
            }
            case minus: {
                return leftNumber - rightNumber;
            }
            case multiply: {
                return leftNumber * rightNumber;
            }
            case divide: {
                return leftNumber / rightNumber;
            }
            case modulo: {
                return leftNumber % rightNumber;
            }
            case exponent: {
                return Math.pow(leftNumber, rightNumber);
            }
        }
        throw new IllegalArgumentException("Not an arithmetic operator: " + operator);
    }

    private Long evaluateIntegerArithmetic(OperatorKind operator, Long leftNumber, Long rightNumber) {
        switch (operator) {
            case plus: {
                return leftNumber + rightNumber;
            }
            case minus: {
                return leftNumber - rightNumber;
            }
            case multiply: {
                return leftNumber * rightNumber;
            }
            case divide: {
                return leftNumber / rightNumber;
            }
            case modulo: {
                return leftNumber % rightNumber;
            }
            case exponent: {
                return (long)Math.pow(leftNumber.longValue(), rightNumber.longValue());
            }
        }
        throw new IllegalArgumentException("Not an arithmetic operator: " + operator);
    }

    private ValueList evaluateRelOpOperator(RuleEvaluation evaluation, BinaryOperator statement) {
        ValueList rightValues;
        ValueList leftValues = evaluation.evaluate((RuleElement)statement.getLeftOperand());
        ValueList possibleNullResult = this.handlePossibleNullRelOpResult(statement, leftValues, rightValues = evaluation.evaluate((RuleElement)statement.getRightOperand()));
        if (possibleNullResult != null) {
            possibleNullResult.setType(PrimitiveType.Boolean);
            return possibleNullResult;
        }
        if (leftValues.getType() == PrimitiveType.Boolean || rightValues.getType() == PrimitiveType.Boolean) {
            if (!EnumSet.of(OperatorKind.eq, OperatorKind.ne).contains(statement.getOperator())) {
                throw new IllegalStateException("Operator " + statement.getOperator().toString() + " not valid for boolean type");
            }
            ValueList result = new ValueList();
            result.setType(PrimitiveType.Boolean);
            result.addValue(this.booleanOperandEvaluator.evaluateMultipleValuesBooleanRelOp(statement, leftValues, rightValues));
            return result;
        }
        if (leftValues.getType() == PrimitiveType.String || rightValues.getType() == PrimitiveType.String) {
            if (!EnumSet.of(OperatorKind.eq, OperatorKind.ne).contains(statement.getOperator())) {
                throw new IllegalStateException("Operator " + statement.getOperator().toString() + " not valid for boolean type");
            }
            ValueList result = new ValueList();
            result.setType(PrimitiveType.Boolean);
            result.addValue(this.stringOperandEvaluator.evaluateMultipleValuesStringRelOp(statement, leftValues, rightValues));
            return result;
        }
        BinaryOperatorEvaluator.checkIsNumberOrNull(leftValues, rightValues);
        ValueList result = new ValueList();
        result.setType(PrimitiveType.Boolean);
        result.addValue(this.evaluateMultipleValuesRelOp(statement, leftValues, rightValues));
        return result;
    }

    private ValueList handlePossibleNullRelOpResult(BinaryOperator statement, ValueList leftValues, ValueList rightValues) {
        switch (statement.getOperator()) {
            case eq: 
            case ne: {
                return null;
            }
            case gt: 
            case ge: 
            case lt: 
            case le: {
                return FunctionUtil.checkAndHandleNull(leftValues, rightValues);
            }
        }
        throw new IllegalStateException("unknown relop operator");
    }

    private Value evaluateMultipleValuesRelOp(BinaryOperator statement, ValueList leftValues, ValueList rightValues) {
        for (Value leftValue : leftValues.getValues()) {
            for (Value rightValue : rightValues.getValues()) {
                Value evaluatedRelOp = this.evaluateRelOp(statement, leftValue.getValue(), rightValue.getValue(), this.getPaths(leftValue, rightValue));
                if (!((Boolean)evaluatedRelOp.getValue()).booleanValue()) continue;
                return evaluatedRelOp;
            }
        }
        return new Value<Boolean>(false, this.getAllPaths(leftValues, rightValues));
    }

    protected List<String> getAllPaths(ValueList leftValue, ValueList rightValue) {
        ArrayList<String> allPaths = new ArrayList<String>();
        allPaths.addAll(leftValue.getAllPaths());
        allPaths.addAll(rightValue.getAllPaths());
        return allPaths;
    }

    private Value evaluateRelOp(BinaryOperator statement, Object leftValue, Object rightValue, List<String> paths) {
        if (leftValue == null || rightValue == null) {
            return new Value<Boolean>(this.evaluateNullRelOp(statement.getOperator(), leftValue, rightValue), paths);
        }
        if (leftValue instanceof Long && rightValue instanceof Long) {
            return new Value<Boolean>(this.evaluateIntegerRelOp(statement.getOperator(), (Long)leftValue, (Long)rightValue), paths);
        }
        return new Value<Boolean>(this.evaluateRealRelOp(statement.getOperator(), this.convertToDouble(leftValue), this.convertToDouble(rightValue)), paths);
    }

    protected Boolean evaluateNullRelOp(OperatorKind operator, Object leftValue, Object rightValue) {
        switch (operator) {
            case eq: {
                if (leftValue == null && rightValue == null) {
                    return true;
                }
                if (leftValue == null && rightValue != null || leftValue != null && rightValue == null) {
                    return false;
                }
            }
            case ne: {
                if (leftValue == null && rightValue == null) {
                    return false;
                }
                if ((leftValue != null || rightValue == null) && (leftValue == null || rightValue != null)) break;
                return true;
            }
        }
        return null;
    }

    private Boolean evaluateIntegerRelOp(OperatorKind operator, long leftNumber, long rightNumber) {
        switch (operator) {
            case eq: {
                return leftNumber == rightNumber;
            }
            case ne: {
                return leftNumber != rightNumber;
            }
            case gt: {
                return leftNumber > rightNumber;
            }
            case lt: {
                return leftNumber < rightNumber;
            }
            case ge: {
                return leftNumber >= rightNumber;
            }
            case le: {
                return leftNumber <= rightNumber;
            }
        }
        throw new IllegalArgumentException("Not a boolean operator: " + operator);
    }

    private Boolean evaluateRealRelOp(OperatorKind operator, Double leftNumber, Double rightNumber) {
        switch (operator) {
            case eq: {
                return Math.abs(leftNumber - rightNumber) < 1.0E-5;
            }
            case ne: {
                return Math.abs(leftNumber - rightNumber) >= 1.0E-5;
            }
            case gt: {
                return leftNumber > rightNumber;
            }
            case lt: {
                return leftNumber < rightNumber;
            }
            case ge: {
                return leftNumber >= rightNumber;
            }
            case le: {
                return leftNumber <= rightNumber;
            }
        }
        throw new IllegalArgumentException("Not a boolean operator: " + operator);
    }

    public static void checkisBoolean(ValueList leftValueList, ValueList rightValueList) {
        EnumSet<PrimitiveType> booleanTypes = EnumSet.of(PrimitiveType.Boolean);
        if (!booleanTypes.contains(leftValueList.getType())) {
            throw new RuntimeException("not a boolean with boolean operator: " + leftValueList.getType());
        }
        if (!booleanTypes.contains(rightValueList.getType())) {
            throw new RuntimeException("not a boolean with boolean operator: " + rightValueList.getType());
        }
    }

    public static void checkIsNumberOrNull(ValueList leftValueList, ValueList rightValueList) {
        if (leftValueList.isEmpty() || rightValueList.isEmpty()) {
            return;
        }
        EnumSet<PrimitiveType> numberTypes = EnumSet.of(PrimitiveType.Integer, PrimitiveType.Real);
        if (!numberTypes.contains(leftValueList.getType())) {
            throw new RuntimeException("Type supplied to operator should be a number, but it is not: " + leftValueList.getType());
        }
        if (!numberTypes.contains(rightValueList.getType())) {
            throw new RuntimeException("Type supplied to operator should be a number, but it is not: " + rightValueList.getType());
        }
    }

    public static void checkIsNumber(ValueList leftValueList, ValueList rightValueList) {
        EnumSet<PrimitiveType> numberTypes = EnumSet.of(PrimitiveType.Integer, PrimitiveType.Real);
        if (!numberTypes.contains(leftValueList.getType())) {
            throw new RuntimeException("Type supplied to operator should be a number, but it is not: " + leftValueList.getType());
        }
        if (!numberTypes.contains(rightValueList.getType())) {
            throw new RuntimeException("Type supplied to operator should be a number, but it is not: " + rightValueList.getType());
        }
    }

    private double convertToDouble(Object value) {
        return value instanceof Double ? ((Double)value).doubleValue() : ((Long)value).doubleValue();
    }

    @Override
    public List<Class> getSupportedClasses() {
        return Lists.newArrayList((Object[])new Class[]{BinaryOperator.class});
    }
}

