/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rules.evaluation;

import com.google.common.collect.ArrayListMultimap;
import com.nedap.archie.aom.Archetype;
import com.nedap.archie.creation.RMObjectCreator;
import com.nedap.archie.query.RMQueryContext;
import com.nedap.archie.rminfo.ModelInfoLookup;
import com.nedap.archie.rules.Expression;
import com.nedap.archie.rules.RuleElement;
import com.nedap.archie.rules.RuleStatement;
import com.nedap.archie.rules.evaluation.AssertionResult;
import com.nedap.archie.rules.evaluation.AssertionsFixer;
import com.nedap.archie.rules.evaluation.EvaluationResult;
import com.nedap.archie.rules.evaluation.Evaluator;
import com.nedap.archie.rules.evaluation.FixableAssertionsChecker;
import com.nedap.archie.rules.evaluation.FunctionImplementation;
import com.nedap.archie.rules.evaluation.ValueList;
import com.nedap.archie.rules.evaluation.VariableMap;
import com.nedap.archie.rules.evaluation.evaluators.AssertionEvaluator;
import com.nedap.archie.rules.evaluation.evaluators.BinaryOperatorEvaluator;
import com.nedap.archie.rules.evaluation.evaluators.ConstantEvaluator;
import com.nedap.archie.rules.evaluation.evaluators.ForAllEvaluator;
import com.nedap.archie.rules.evaluation.evaluators.FunctionEvaluator;
import com.nedap.archie.rules.evaluation.evaluators.ModelReferenceEvaluator;
import com.nedap.archie.rules.evaluation.evaluators.UnaryOperatorEvaluator;
import com.nedap.archie.rules.evaluation.evaluators.VariableDeclarationEvaluator;
import com.nedap.archie.rules.evaluation.evaluators.VariableReferenceEvaluator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleEvaluation<T> {
    private static Logger logger = LoggerFactory.getLogger(RuleEvaluation.class);
    private final JAXBContext jaxbContext;
    private Archetype archetype;
    private List<Evaluator> evaluators = new ArrayList<Evaluator>();
    private HashMap<Class, Evaluator> classToEvaluator = new HashMap();
    private FunctionEvaluator functionEvaluator;
    private T root;
    private VariableMap variables;
    EvaluationResult evaluationResult;
    private List<AssertionResult> assertionResults;
    private RMQueryContext queryContext;
    private ArrayListMultimap<RuleElement, ValueList> ruleElementValues = ArrayListMultimap.create();
    private FixableAssertionsChecker fixableAssertionsChecker;
    private ModelInfoLookup modelInfoLookup;
    private RMObjectCreator creator;
    private final AssertionsFixer assertionsFixer;

    public RuleEvaluation(ModelInfoLookup modelInfoLookup, JAXBContext jaxbContext, Archetype archetype) {
        this.modelInfoLookup = modelInfoLookup;
        this.creator = new RMObjectCreator(modelInfoLookup);
        this.jaxbContext = jaxbContext;
        this.assertionsFixer = new AssertionsFixer(this, this.creator);
        this.archetype = archetype;
        this.functionEvaluator = new FunctionEvaluator();
        this.add(new VariableDeclarationEvaluator());
        this.add(new ConstantEvaluator());
        this.add(new AssertionEvaluator());
        this.add(new BinaryOperatorEvaluator(modelInfoLookup));
        this.add(new UnaryOperatorEvaluator());
        this.add(new VariableReferenceEvaluator());
        this.add(new ModelReferenceEvaluator());
        this.add(new ForAllEvaluator());
        this.add(this.functionEvaluator);
    }

    private void add(Evaluator evaluator) {
        this.evaluators.add(evaluator);
        for (Class clazz : evaluator.getSupportedClasses()) {
            this.classToEvaluator.put(clazz, evaluator);
        }
    }

    public EvaluationResult evaluate(T root, List<RuleStatement> rules) {
        this.root = this.modelInfoLookup.clone(root);
        this.ruleElementValues = ArrayListMultimap.create();
        this.variables = new VariableMap();
        this.assertionResults = new ArrayList<AssertionResult>();
        this.evaluationResult = new EvaluationResult();
        this.queryContext = new RMQueryContext(this.modelInfoLookup, this.root, this.jaxbContext);
        this.fixableAssertionsChecker = new FixableAssertionsChecker(this.ruleElementValues);
        for (RuleStatement rule : rules) {
            this.evaluate((RuleElement)rule);
        }
        return this.evaluationResult;
    }

    public ValueList evaluate(RuleElement rule) {
        Evaluator evaluator = this.classToEvaluator.get(rule.getClass());
        if (evaluator != null) {
            ValueList valueList = evaluator.evaluate(this, rule);
            this.ruleElementValueSet(rule, valueList);
            logger.debug("evaluated rule: {}", (Object)valueList);
            return valueList;
        }
        throw new UnsupportedOperationException("no evaluator present for rule type " + rule.getClass().getSimpleName());
    }

    public T getRMRoot() {
        return this.root;
    }

    public void registerFunction(FunctionImplementation function) {
        this.functionEvaluator.registerFunction(function);
    }

    public VariableMap getVariableMap() {
        return this.variables;
    }

    private void ruleElementValueSet(RuleElement expression, ValueList values) {
        this.ruleElementValues.put((Object)expression, (Object)values);
    }

    public RMQueryContext getQueryContext() {
        return this.queryContext;
    }

    public void refreshQueryContext() {
        this.queryContext = new RMQueryContext(this.modelInfoLookup, this.root, this.jaxbContext);
    }

    public void assertionEvaluated(String tag, Expression expression, ValueList valueList) {
        AssertionResult assertionResult = new AssertionResult();
        assertionResult.setTag(tag);
        assertionResult.setAssertion(expression);
        boolean result = valueList.getSingleBooleanResult();
        assertionResult.setResult(result);
        assertionResult.setRawResult(valueList);
        this.evaluationResult.addAssertionResult(assertionResult);
        this.fixableAssertionsChecker.checkAssertionForFixablePatterns(assertionResult, expression, 0);
        Map<String, Object> valuesToUpdate = this.assertionsFixer.fixAssertions(this.archetype, assertionResult);
        for (String path : valuesToUpdate.keySet()) {
            Object value = valuesToUpdate.get(path);
            assertionResult.setSetPathValue(path, new ValueList(value));
        }
    }

    public EvaluationResult getEvaluationResult() {
        return this.evaluationResult;
    }

    public ModelInfoLookup getModelInfoLookup() {
        return this.modelInfoLookup;
    }
}

