/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rmobjectvalidator.validations;

import com.nedap.archie.aom.ArchetypeConstraint;
import com.nedap.archie.aom.CPrimitiveObject;
import com.nedap.archie.query.RMObjectWithPath;
import com.nedap.archie.rminfo.ModelInfoLookup;
import com.nedap.archie.rmobjectvalidator.ConstraintToStringUtil;
import com.nedap.archie.rmobjectvalidator.RMObjectValidationMessage;
import com.nedap.archie.rmobjectvalidator.RMObjectValidationMessageIds;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openehr.utils.message.I18n;

public class RMPrimitiveObjectValidation {
    public static List<RMObjectValidationMessage> validate(ModelInfoLookup lookup, List<RMObjectWithPath> rmObjects, String pathSoFar, CPrimitiveObject cobject) {
        if (cobject == null) {
            return new ArrayList<RMObjectValidationMessage>();
        }
        if (cobject.getSocParent() != null) {
            return Collections.emptyList();
        }
        if (rmObjects.size() != 1) {
            ArrayList<RMObjectValidationMessage> result = new ArrayList<RMObjectValidationMessage>();
            result.add(RMPrimitiveObjectValidation.createValidationMessage(rmObjects, pathSoFar, cobject));
            return result;
        }
        Object rmObject = rmObjects.get(0).getObject();
        return RMPrimitiveObjectValidation.validate_inner(lookup, rmObject, pathSoFar, cobject);
    }

    static List<RMObjectValidationMessage> validate_inner(ModelInfoLookup lookup, Object rmObject, String pathSoFar, CPrimitiveObject cobject) {
        ArrayList<RMObjectValidationMessage> result = new ArrayList<RMObjectValidationMessage>();
        if (!cobject.isValidValue(lookup, rmObject)) {
            result.add(RMPrimitiveObjectValidation.createValidationMessage(rmObject, pathSoFar, cobject));
        }
        return result;
    }

    private static RMObjectValidationMessage createValidationMessage(Object value, String pathSoFar, CPrimitiveObject cobject) {
        String message;
        List constraint = cobject.getConstraint();
        if (constraint.size() == 1) {
            String constraintStr = ConstraintToStringUtil.constraintElementToString(constraint.get(0));
            message = RMObjectValidationMessageIds.rm_INVALID_FOR_CONSTRAINT.getMessage(new Object[]{RMPrimitiveObjectValidation.getValueString(value), constraintStr});
        } else {
            String constraintStr = ConstraintToStringUtil.constraintListToString(constraint);
            message = RMObjectValidationMessageIds.rm_INVALID_FOR_CONSTRAINT_MULTIPLE.getMessage(new Object[]{RMPrimitiveObjectValidation.getValueString(value)}) + "\n" + constraintStr;
        }
        return new RMObjectValidationMessage((ArchetypeConstraint)cobject, pathSoFar, message);
    }

    private static String getValueString(Object value) {
        if (value == null) {
            return I18n.t((String)"empty", (Object[])new Object[0]);
        }
        return value instanceof String ? "\"" + value.toString() + "\"" : value.toString();
    }
}

