/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rmobjectvalidator;

import com.nedap.archie.adlparser.modelconstraints.ModelConstraintImposer;
import com.nedap.archie.aom.ArchetypeConstraint;
import com.nedap.archie.aom.CAttribute;
import com.nedap.archie.aom.CComplexObject;
import com.nedap.archie.aom.CObject;
import com.nedap.archie.aom.terminology.ArchetypeTerm;
import com.nedap.archie.rminfo.ModelInfoLookup;
import com.nedap.archie.rminfo.RMAttributeInfo;
import com.nedap.archie.rminfo.RMTypeInfo;
import com.nedap.archie.rmobjectvalidator.RMObjectValidationMessage;
import com.nedap.archie.rmobjectvalidator.RMObjectValidationMessageType;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

class RMObjectValidationUtil {
    RMObjectValidationUtil() {
    }

    public static String getParentObservationTerm(CAttribute attribute) {
        String result = "";
        CObject parent = attribute.getParent();
        while (result.equals("") && parent != null) {
            ArchetypeTerm parentTerm;
            CAttribute attributeParent = parent.getParent();
            if (attributeParent == null || !(parent = attributeParent.getParent()).getRmTypeName().equals("OBSERVATION") || (parentTerm = parent.getTerm()) == null) continue;
            result = parentTerm.getText();
        }
        return result;
    }

    public static boolean hasNoneWithWrongType(List<RMObjectValidationMessage> subResult) {
        return subResult.stream().noneMatch(message -> message.getType() == RMObjectValidationMessageType.WRONG_TYPE);
    }

    public static List<CAttribute> getDefaultAttributeConstraints(CObject cObject, List<CAttribute> attributes, ModelInfoLookup lookup, ModelConstraintImposer constraintImposer) {
        ArrayList<CAttribute> result = new ArrayList<CAttribute>();
        Set alreadyConstrainedAttributes = attributes.stream().map(attribute -> attribute.getRmAttributeName()).collect(Collectors.toSet());
        RMTypeInfo typeInfo = lookup.getTypeInfo(cObject.getRmTypeName());
        if (typeInfo != null) {
            for (RMAttributeInfo defaultAttribute : typeInfo.getAttributes().values()) {
                if (defaultAttribute.isComputed() || alreadyConstrainedAttributes.contains(defaultAttribute.getRmName())) continue;
                CAttribute attribute2 = constraintImposer.getDefaultAttribute(cObject.getRmTypeName(), defaultAttribute.getRmName());
                attribute2.setParent((ArchetypeConstraint)cObject);
                result.add(attribute2);
            }
        }
        return result;
    }

    public static List<CAttribute> getDefaultAttributeConstraints(String rmTypeName, List<CAttribute> attributes, ModelInfoLookup lookup, ModelConstraintImposer constraintImposer) {
        CComplexObject fakeParent = new CComplexObject();
        fakeParent.setRmTypeName(rmTypeName);
        return RMObjectValidationUtil.getDefaultAttributeConstraints((CObject)fakeParent, attributes, lookup, constraintImposer);
    }

    public static String stripLastPathSegment(String path) {
        if (path.equals("/")) {
            return "";
        }
        int lastSlashIndex = path.lastIndexOf(47);
        if (lastSlashIndex == -1) {
            return path;
        }
        return path.substring(0, lastSlashIndex);
    }
}

