/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.json;

import com.google.common.base.Charsets;
import com.nedap.archie.json.JSONSchemaCreator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonStructure;
import org.leadpony.justify.api.JsonSchema;
import org.leadpony.justify.api.JsonValidationService;
import org.leadpony.justify.api.Problem;
import org.leadpony.justify.api.ProblemHandler;
import org.openehr.bmm.core.BmmModel;

public class JsonSchemaValidator {
    JsonSchema schema;

    public JsonSchemaValidator(BmmModel bmmModel, boolean allowAdditionalProperties) {
        JsonObject schemaJson = new JSONSchemaCreator().allowAdditionalProperties(allowAdditionalProperties).create(bmmModel);
        JsonValidationService service = JsonValidationService.newInstance();
        this.schema = service.readSchema((InputStream)this.createByteArrayInputStream(schemaJson.toString()));
    }

    private ByteArrayInputStream createByteArrayInputStream(String json) {
        return new ByteArrayInputStream(json.getBytes(Charsets.UTF_8));
    }

    public List<Problem> validate(String json) throws IOException {
        JsonValidationService service = JsonValidationService.newInstance();
        final ArrayList<Problem> allProblems = new ArrayList<Problem>();
        ProblemHandler problemHandler = new ProblemHandler(){

            public void handleProblems(List<Problem> problems) {
                allProblems.addAll(problems);
            }
        };
        try (JsonReader reader = service.createReader((InputStream)this.createByteArrayInputStream(json), this.schema, problemHandler);){
            JsonStructure structure = reader.read();
            ArrayList<Problem> arrayList = allProblems;
            return arrayList;
        }
    }
}

