/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.flattener;

import com.nedap.archie.aom.Archetype;
import com.nedap.archie.aom.OperationalTemplate;
import com.nedap.archie.archetypevalidator.ArchetypeValidationSettings;
import com.nedap.archie.archetypevalidator.ValidationResult;
import com.nedap.archie.flattener.FullArchetypeRepository;
import com.nedap.archie.flattener.InMemoryFullArchetypeRepository;
import com.nedap.archie.flattener.MutableArchetypeRepository;
import java.util.ArrayList;
import java.util.List;

public class OverridingInMemFullArchetypeRepository
implements FullArchetypeRepository,
MutableArchetypeRepository {
    private final FullArchetypeRepository originalRepository;
    private final InMemoryFullArchetypeRepository extraArchetypes = new InMemoryFullArchetypeRepository();

    public OverridingInMemFullArchetypeRepository() {
        this.originalRepository = new InMemoryFullArchetypeRepository();
    }

    public OverridingInMemFullArchetypeRepository(FullArchetypeRepository fullArchetypeRepository) {
        this.originalRepository = fullArchetypeRepository;
    }

    @Override
    public Archetype getFlattenedArchetype(String archetypeId) {
        Archetype result = this.extraArchetypes.getFlattenedArchetype(archetypeId);
        if (result != null) {
            return result;
        }
        return this.originalRepository.getFlattenedArchetype(archetypeId);
    }

    @Override
    public ValidationResult getValidationResult(String archetypeId) {
        ValidationResult result = this.extraArchetypes.getValidationResult(archetypeId);
        if (result != null) {
            return result;
        }
        return this.originalRepository.getValidationResult(archetypeId);
    }

    @Override
    public OperationalTemplate getOperationalTemplate(String archetypeId) {
        OperationalTemplate result = this.extraArchetypes.getOperationalTemplate(archetypeId);
        if (result != null) {
            return result;
        }
        return this.originalRepository.getOperationalTemplate(archetypeId);
    }

    @Override
    public void setValidationResult(ValidationResult result) {
        if (this.extraArchetypes.getArchetype(result.getArchetypeId()) != null) {
            this.extraArchetypes.setValidationResult(result);
        } else {
            this.originalRepository.setValidationResult(result);
        }
    }

    @Override
    public void setFlattenedArchetype(Archetype archetype) {
        if (this.extraArchetypes.getArchetype(archetype.getArchetypeId().toString()) != null) {
            this.extraArchetypes.setFlattenedArchetype(archetype);
        } else {
            this.originalRepository.setFlattenedArchetype(archetype);
        }
    }

    @Override
    public void addArchetype(Archetype archetype) {
        if (!(this.originalRepository instanceof MutableArchetypeRepository)) {
            throw new UnsupportedOperationException("original archetype repository is not a mutable repository");
        }
        ((MutableArchetypeRepository)((Object)this.originalRepository)).addArchetype(archetype);
    }

    @Override
    public void setOperationalTemplate(OperationalTemplate template) {
        this.originalRepository.setOperationalTemplate(template);
    }

    @Override
    public void removeValidationResult(String archetypeId) {
        ValidationResult result = this.extraArchetypes.getValidationResult(archetypeId);
        if (result != null) {
            this.extraArchetypes.removeValidationResult(archetypeId);
        } else {
            this.originalRepository.removeValidationResult(archetypeId);
        }
    }

    @Override
    public List<ValidationResult> getAllValidationResults() {
        ArrayList<ValidationResult> result = new ArrayList<ValidationResult>(this.extraArchetypes.getAllValidationResults());
        result.addAll(this.originalRepository.getAllValidationResults());
        return result;
    }

    @Override
    public ArchetypeValidationSettings getArchetypeValidationSettings() {
        return this.originalRepository.getArchetypeValidationSettings();
    }

    @Override
    public Archetype getArchetype(String archetypeId) {
        Archetype result = this.extraArchetypes.getArchetype(archetypeId);
        if (result != null) {
            return result;
        }
        return this.originalRepository.getArchetype(archetypeId);
    }

    @Override
    public List<Archetype> getAllArchetypes() {
        ArrayList<Archetype> result = new ArrayList<Archetype>(this.extraArchetypes.getAllArchetypes());
        result.addAll(this.originalRepository.getAllArchetypes());
        return result;
    }

    public void addExtraArchetype(Archetype override) {
        this.extraArchetypes.addArchetype(override);
    }

    public void addExtraOperationalTemplate(OperationalTemplate override) {
        this.extraArchetypes.setOperationalTemplate(override);
    }

    public FullArchetypeRepository getExtraArchetypeRepository() {
        return this.extraArchetypes;
    }
}

