/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.flattener;

import com.nedap.archie.aom.Archetype;
import com.nedap.archie.aom.CAttribute;
import com.nedap.archie.aom.CObject;
import com.nedap.archie.aom.CPrimitiveObject;
import com.nedap.archie.aom.primitives.COrdered;
import com.nedap.archie.aom.primitives.CString;
import com.nedap.archie.base.Interval;
import java.util.List;
import java.util.Objects;

public class AssumedValueFiller {
    public static void fillAssumedValues(Archetype archetype) {
        AssumedValueFiller.fillAssumedValues((CObject)archetype.getDefinition());
    }

    public static void fillAssumedValues(CObject cObject) {
        if (cObject instanceof CPrimitiveObject) {
            AssumedValueFiller.fillAssumedValue((CPrimitiveObject)cObject);
        } else {
            for (CAttribute attribute : cObject.getAttributes()) {
                for (CObject child : attribute.getChildren()) {
                    AssumedValueFiller.fillAssumedValues(child);
                }
            }
        }
    }

    private static void fillAssumedValue(CPrimitiveObject cObject) {
        if (cObject instanceof COrdered) {
            AssumedValueFiller.fillAssumedValueForOrdered((COrdered)cObject);
        } else if (cObject instanceof CString) {
            AssumedValueFiller.fillAssumedValueForString((CString)cObject);
        }
    }

    private static void fillAssumedValueForString(CString cObject) {
        String singleConstraint;
        CString cString = cObject;
        List constraint = cString.getConstraint();
        if (constraint != null && constraint.size() == 1 && !CString.isRegexConstraint((String)(singleConstraint = (String)constraint.get(0)))) {
            cString.setAssumedValue(singleConstraint);
        }
    }

    private static void fillAssumedValueForOrdered(COrdered cObject) {
        Interval interval;
        COrdered cOrdered = cObject;
        List constraint = cOrdered.getConstraint();
        if (constraint != null && constraint.size() == 1 && !(interval = (Interval)constraint.get(0)).isLowerUnbounded() && !interval.isUpperUnbounded() && interval.isLowerIncluded() && interval.isUpperIncluded() && Objects.equals(interval.getLower(), interval.getUpper())) {
            cOrdered.setAssumedValue(interval.getLower());
        }
    }
}

